/*
 * Decompiled with CFR 0.152.
 */
package org.qetools.task_generator.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.BasicCredentials;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.JiraException;
import org.qetools.task_generator.Utils;
import org.qetools.task_generator.api.JiraClient;
import org.qetools.task_generator.api.JiraIssue;
import org.qetools.task_generator.api.JiraQuery;
import org.qetools.task_generator.impl.JiraIssueRcarz;

public class JiraClientRcarz
implements JiraClient {
    private String url;
    private String username;
    private String password;
    private net.rcarz.jiraclient.JiraClient jira;

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void initialize() {
        try {
            this.jira = new net.rcarz.jiraclient.JiraClient(this.url, new BasicCredentials(this.username, this.password));
        }
        catch (JiraException e) {
            throw new RuntimeException("Cannot initialize jira client.", e);
        }
    }

    @Override
    public JiraIssue create(Map<String, String> fields) {
        Issue issue;
        try {
            Issue.FluentCreate builder = this.jira.createIssue(fields.get("project").toString(), fields.get("issuetype").toString());
            if (fields.get("summary") != null) {
                builder.field("summary", fields.get("summary"));
            }
            if (fields.get("assignee") != null) {
                builder.field("assignee", fields.get("assignee"));
            }
            if (fields.get("description") != null) {
                builder.field("description", fields.get("description"));
            }
            if (fields.get("fixVersion") != null) {
                builder.field("fixVersions", Utils.list(fields.get("fixVersion")));
            }
            if (fields.get("components") != null) {
                builder.field("components", Utils.list(fields.get("components")));
            }
            if (fields.get("epic") != null) {
                builder.field("customfield_12311140", fields.get("epic"));
            }
            if (fields.get("parent") != null) {
                builder.field("parent", fields.get("parent"));
            }
            if (fields.get("name") != null) {
                builder.field("customfield_12311141", fields.get("name"));
            }
            if (fields.get("security") != null) {
                builder.field("security", fields.get("security"));
            }
            issue = builder.execute();
        }
        catch (JiraException e) {
            throw new RuntimeException("Error during creating an issue.", e);
        }
        return new JiraIssueRcarz(issue);
    }

    public List<JiraIssue> search(String jql) {
        ArrayList<JiraIssue> jiraIssues = new ArrayList<JiraIssue>();
        Issue.SearchResult searchResult = null;
        try {
            searchResult = this.jira.searchIssues(jql);
        }
        catch (JiraException e) {
            throw new RuntimeException("Error during searching issues.", e);
        }
        if (searchResult == null) {
            throw new RuntimeException("Search result is null.");
        }
        for (Issue issue : searchResult.issues) {
            jiraIssues.add(new JiraIssueRcarz(issue));
        }
        return jiraIssues;
    }

    @Override
    public JiraIssue get(JiraQuery jiraQuery) {
        List<JiraIssue> issues = this.search(jiraQuery.getJiraQueryString());
        if (issues.isEmpty()) {
            return null;
        }
        return issues.get(0);
    }
}

