/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.restcomm.connect.rvd.model.StepJsonDeserializer;
import org.restcomm.connect.rvd.model.StepJsonSerializer;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.ProjectState;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.server.NodeName;
import org.restcomm.connect.rvd.model.server.ProjectOptions;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

public class BuildService {
    protected Gson gson;
    private WorkspaceStorage workspaceStorage;

    public BuildService(WorkspaceStorage workspaceStorage) {
        this.workspaceStorage = workspaceStorage;
        this.gson = new GsonBuilder().registerTypeAdapter(Step.class, (Object)new StepJsonDeserializer()).registerTypeAdapter(Step.class, (Object)new StepJsonSerializer()).create();
    }

    public void buildProject(String projectName, ProjectState projectState) throws StorageException {
        ProjectOptions projectOptions = new ProjectOptions();
        for (Node node : projectState.getNodes()) {
            this.buildNode(node, projectName);
            NodeName nodeName = new NodeName();
            nodeName.setName(node.getName());
            nodeName.setLabel(node.getLabel());
            projectOptions.getNodeNames().add(nodeName);
        }
        projectOptions.setDefaultTarget(projectState.getHeader().getStartNodeName());
        FsProjectStorage.storeProjectOptions((ProjectOptions)projectOptions, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }

    public void buildProject(String projectName) throws StorageException {
        ProjectState state = FsProjectStorage.loadProject((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        this.buildProject(projectName, state);
    }

    private void buildNode(Node node, String projectName) throws StorageException {
        FsProjectStorage.storeNode((Node)node, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }
}

