/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.commons.http.SslMode;
import org.restcomm.connect.rvd.configuration.CustomIntegerConverter;
import org.restcomm.connect.rvd.configuration.RestcommConfig;
import org.restcomm.connect.rvd.configuration.RvdConfig;
import org.restcomm.connect.rvd.configuration.RvdMaxPerHost;
import org.restcomm.connect.rvd.exceptions.RestcommConfigNotFound;
import org.restcomm.connect.rvd.exceptions.RestcommConfigurationException;
import org.restcomm.connect.rvd.exceptions.XmlParserException;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.utils.RvdUtils;
import org.restcomm.connect.rvd.utils.XmlParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileRvdConfiguration
implements RvdConfiguration {
    static Logger logger = RvdLoggers.local;
    private Integer maxMediaFileSize;
    private String workspaceBasePath;
    private RvdConfig rvdConfig;
    private RestcommConfig restcommConfig;
    private String contextRootPath;
    private String contextPath;
    private URI restcommBaseUri;
    private Integer externalServiceTimeout;
    private Boolean videoSupport;
    private SslMode sslMode;
    private String hostnameOverride;
    private Boolean useHostnameToResolveRelativeUrl;
    private String baseUrl;
    private Boolean useAbsoluteApplicationUrl;
    private boolean ussdSupport;
    private String welcomeMessage;
    private String rvdInstanceId;
    private Boolean dynamicRestcommResolving;

    public FileRvdConfiguration(ServletContext servletContext) {
        this(servletContext.getContextPath(), servletContext.getRealPath("/"));
    }

    public FileRvdConfiguration(String contextPath, String contextRootPath) {
        this.contextRootPath = RvdUtils.addTrailingSlashIfMissing((String)contextRootPath);
        this.contextPath = contextPath;
        logger.info((Object)("context filesystem root path is " + this.contextRootPath));
        logger.info((Object)("context path is " + this.contextPath));
        this.load();
    }

    public FileRvdConfiguration(String workspaceBasePath, RvdConfig rvdConfig, RestcommConfig restcommConfig, String contextPath, String contextRootPath, URI restcommBaseUri) {
        this.workspaceBasePath = workspaceBasePath;
        this.rvdConfig = rvdConfig;
        this.restcommConfig = restcommConfig;
        this.contextPath = contextPath;
        this.contextRootPath = contextRootPath;
        this.restcommBaseUri = restcommBaseUri;
    }

    private void load() {
        this.rvdConfig = FileRvdConfiguration.loadRvdXmlConfig((String)(this.contextRootPath + "WEB-INF/rvd.xml"));
        String workspaceBasePath = this.contextRootPath + "workspace";
        if (this.rvdConfig.getWorkspaceLocation() != null && !"".equals(this.rvdConfig.getWorkspaceLocation())) {
            workspaceBasePath = this.rvdConfig.getWorkspaceLocation().startsWith("/") ? this.rvdConfig.getWorkspaceLocation() : this.contextRootPath + this.rvdConfig.getWorkspaceLocation();
        }
        this.workspaceBasePath = workspaceBasePath;
        RvdLoggers.global.info((Object)("workspace located under " + workspaceBasePath));
        try {
            this.restcommConfig = this.loadRestcommXmlConfig(this.contextRootPath + "../restcomm.war/WEB-INF/conf/restcomm.xml");
        }
        catch (RestcommConfigNotFound e) {
            try {
                this.restcommConfig = this.loadRestcommXmlConfig(this.contextRootPath + "WEB-INF/restcomm.xml");
            }
            catch (RestcommConfigNotFound restcommConfigNotFound) {
                this.restcommConfig = null;
                logger.log((Priority)Level.WARN, (Object)"could not load restcomm configuration");
            }
        }
        this.videoSupport = this.rvdConfig.getVideoSupport();
        this.maxMediaFileSize = this.rvdConfig.getMaxMediaFileSize();
        if (this.restcommConfig != null) {
            this.sslMode = this.restcommConfig.getSslMode();
        }
        if (this.rvdConfig.getSslMode() != null) {
            this.sslMode = SslMode.valueOf((String)this.rvdConfig.getSslMode());
        }
        if (this.sslMode == null) {
            this.sslMode = DEFAULT_SSL_MODE;
        }
        if (this.restcommConfig != null) {
            this.hostnameOverride = this.restcommConfig.getHostname();
        }
        if (this.rvdConfig.getHostnameOverride() != null) {
            this.hostnameOverride = this.rvdConfig.getHostnameOverride();
        }
        if (this.restcommConfig != null) {
            this.useHostnameToResolveRelativeUrl = this.restcommConfig.getUseHostnameToResolveRelativeUrl();
        }
        if (this.rvdConfig.getUseHostnameToResolveRelativeUrl() != null) {
            this.useHostnameToResolveRelativeUrl = this.rvdConfig.getUseHostnameToResolveRelativeUrl();
        }
        if (this.useHostnameToResolveRelativeUrl == null) {
            this.useHostnameToResolveRelativeUrl = true;
        }
        if (!RvdUtils.isEmpty((String)this.rvdConfig.getBaseUrl())) {
            this.baseUrl = this.rvdConfig.getBaseUrl();
        }
        this.useAbsoluteApplicationUrl = !RvdUtils.isEmpty((Boolean)this.rvdConfig.useAbsoluteApplicationUrl()) ? this.rvdConfig.useAbsoluteApplicationUrl() : Boolean.valueOf(false);
        if (RvdUtils.isEmpty((String)this.rvdConfig.getUssdSupport())) {
            this.ussdSupport = true;
        } else {
            try {
                this.ussdSupport = Boolean.parseBoolean(this.rvdConfig.getUssdSupport());
            }
            catch (Exception e) {
                this.ussdSupport = true;
                logger.warn((Object)LoggingHelper.buildMessage(RvdConfiguration.class, (String)"load", null, (String)("Error parsing rvd.xml:ussd/enabled option. Falling back to default: " + this.ussdSupport)), (Throwable)e);
            }
        }
        this.initExternalServiceTimeout();
        this.rvdInstanceId = RvdUtils.isEmpty((String)this.rvdConfig.getInstanceId()) ? UUID.randomUUID().toString().replace("-", "").substring(0, 8) : this.rvdConfig.getInstanceId();
        this.dynamicRestcommResolving = !RvdUtils.isEmpty((Boolean)this.rvdConfig.getDynamicRestcommResolving()) ? this.rvdConfig.getDynamicRestcommResolving() : Boolean.valueOf(false);
        this.loadWhitelabelConfig(this.contextRootPath + "WEB-INF/whitelabel.xml");
    }

    public static RvdConfig loadRvdXmlConfig(String pathToXml) {
        try {
            FileInputStream input = new FileInputStream(pathToXml);
            XStream xstream = new XStream();
            xstream.alias("rvd", RvdConfig.class);
            xstream.alias("rvdMaxPerHost", RvdMaxPerHost.class);
            xstream.omitField(RvdConfig.class, "corsWhitelist");
            xstream.omitField(RvdConfig.class, "ussd");
            xstream.registerConverter((Converter)new CustomIntegerConverter());
            RvdConfig rvdConfig = (RvdConfig)xstream.fromXML((InputStream)input);
            XmlParser xml = new XmlParser(pathToXml);
            rvdConfig.setAllowedCorsOrigins(xml.getElementList("/rvd/corsWhitelist/origin"));
            rvdConfig.setUssdSupport(xml.getElementContent("/rvd/ussdSupport"));
            return rvdConfig;
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)LoggingHelper.buildMessage(RvdConfiguration.class, (String)"loadRvdXmlConfig", null, (String)("RVD configuration file not found: " + pathToXml)));
            return null;
        }
        catch (XmlParserException e) {
            logger.warn((Object)LoggingHelper.buildMessage(RvdConfiguration.class, (String)"loadRvdXmlConfig", null, (String)("Error parsing RVD configuration file: " + pathToXml)), (Throwable)e);
            return null;
        }
    }

    private RestcommConfig loadRestcommXmlConfig(String pathToXml) throws RestcommConfigNotFound {
        try {
            RestcommConfig restcommConfig = new RestcommConfig(pathToXml);
            return restcommConfig;
        }
        catch (RestcommConfigNotFound e) {
            throw e;
        }
        catch (RestcommConfigurationException e) {
            logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void loadWhitelabelConfig(String pathToXml) {
        this.welcomeMessage = "Welcome to Telestax Restcom Visual Designer Demo";
        try {
            XmlParser xml = new XmlParser(pathToXml);
            String value = xml.getElementContent("/whitelabel/welcomeMessage");
            if (value != null) {
                this.welcomeMessage = value;
            }
            logger.info((Object)("Loaded whitelabeling information: " + pathToXml));
        }
        catch (XmlParserException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                logger.info((Object)("No whitelabeling file found (" + pathToXml + "). Hardcoded defaults will be used."));
            } else {
                logger.error((Object)LoggingHelper.buildMessage(RvdConfiguration.class, (String)"loadWhitelabelConfig", null, (String)("Error parsing whitelabeling configuration file: " + pathToXml)), (Throwable)e);
            }
            return;
        }
    }

    public String getWorkspaceBasePath() {
        return this.workspaceBasePath;
    }

    public String getProjectBasePath(String projectName) {
        return this.workspaceBasePath + File.separator + projectName;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public Integer getExternalServiceTimeout() {
        return this.externalServiceTimeout;
    }

    private void initExternalServiceTimeout() {
        if (this.externalServiceTimeout != null) {
            return;
        }
        if (this.rvdConfig != null && this.rvdConfig.getExternalServiceTimeout() != null && this.rvdConfig.getExternalServiceTimeout().trim().length() > 0) {
            try {
                this.externalServiceTimeout = Integer.parseInt(this.rvdConfig.getExternalServiceTimeout());
            }
            catch (NumberFormatException e) {
                logger.warn((Object)LoggingHelper.buildMessage(this.getClass(), (String)"getExternalServiceTimeout", null, (String)("Cannot parse RVD ES timeout configuration setting. Will use default: 5000" + (e.getMessage() != null ? " - " + e.getMessage() : ""))));
                this.externalServiceTimeout = 5000;
            }
        } else {
            this.externalServiceTimeout = 5000;
        }
    }

    public boolean getUseHostnameToResolveRelativeUrl() {
        return this.useHostnameToResolveRelativeUrl;
    }

    public String getHostnameOverride() {
        return this.hostnameOverride;
    }

    public String getRestcommBaseUri() {
        return this.rvdConfig.getRestcommBaseUrl();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Gson gson = new Gson();
        buffer.append("--- Effective RVD Configuration ---");
        buffer.append("\n instanceId:\t").append(this.getRvdInstanceId());
        buffer.append("\n maxMediaFileSize:\t").append(this.getMaxMediaFileSize());
        buffer.append("\n workspaceBasePath (evaluated from rvd.xml/workspaceLocation):\t").append(this.getWorkspaceBasePath());
        buffer.append("\n contextRootPath:\t").append(this.contextRootPath);
        buffer.append("\n contextPath:\t").append(this.contextPath);
        buffer.append("\n videoSupport:\t").append(this.getVideoSupport());
        buffer.append("\n sslMode:\t").append(this.getSslMode());
        buffer.append("\n hostnameOverride:\t").append(this.getHostnameOverride());
        buffer.append("\n useHostnameToResolveRelativeUrl:\t").append(this.getUseHostnameToResolveRelativeUrl());
        buffer.append("\n baseUrl:\t").append(this.getBaseUrl());
        buffer.append("\n userAbsoluteApplicationUrl:\t").append(this.useAbsoluteApplicationUrl());
        buffer.append("\n ussdSupport:\t").append(this.isUssdSupport());
        buffer.append("\n welcomeMessage:\t").append(this.getWelcomeMessage());
        buffer.append("\n restcommBaseUri:\t").append(this.getRestcommBaseUri());
        buffer.append("\n dynamicRestcommResoloving:\t").append(this.getDynamicRestcommResolving());
        buffer.append("\n\nNote, restcommBaseUri is the configured value in rvd.xml. Actual value may vary. ");
        return buffer.toString();
    }

    public String getApplicationsRelativeUrl() {
        return "/restcomm-rvd/services/apps";
    }

    public Integer getMaxMediaFileSize() {
        return this.maxMediaFileSize;
    }

    public Boolean getVideoSupport() {
        return RvdUtils.isTrue((Boolean)this.videoSupport);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean useAbsoluteApplicationUrl() {
        return this.useAbsoluteApplicationUrl;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isUssdSupport() {
        return this.ussdSupport;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getRvdInstanceId() {
        return this.rvdInstanceId;
    }

    public Integer getExternalServiceMaxConns() {
        return this.rvdConfig != null && this.rvdConfig.getExternalServiceMaxConns() != null ? this.rvdConfig.getExternalServiceMaxConns() : 2000;
    }

    public Integer getExternalServiceMaxConnsPerRoute() {
        return this.rvdConfig != null && this.rvdConfig.getExternalServiceMaxConnsPerRoute() != null ? this.rvdConfig.getExternalServiceMaxConnsPerRoute() : 10;
    }

    public Integer getExternalServiceTTL() {
        return this.rvdConfig != null && this.rvdConfig.getExternalServiceTTL() != null ? this.rvdConfig.getExternalServiceTTL() : 30000;
    }

    public Integer getDefaultHttpTimeout() {
        return this.rvdConfig != null && this.rvdConfig.getDefaultHttpTimeout() != null ? this.rvdConfig.getDefaultHttpTimeout() : 1000;
    }

    public Integer getDefaultHttpMaxConns() {
        return this.rvdConfig != null && this.rvdConfig.getDefaultHttpMaxConns() != null ? this.rvdConfig.getDefaultHttpMaxConns() : 200;
    }

    public Integer getDefaultHttpMaxConnsPerRoute() {
        return this.rvdConfig != null && this.rvdConfig.getDefaultHttpMaxConnsPerRoute() != null ? this.rvdConfig.getDefaultHttpMaxConnsPerRoute() : 100;
    }

    public Integer getDefaultHttpTTL() {
        return this.rvdConfig != null && this.rvdConfig.getDefaultHttpTTL() != null ? this.rvdConfig.getDefaultHttpTTL() : 300000;
    }

    public List<RvdMaxPerHost> getExternalServiceMaxPerRoute() {
        return this.rvdConfig != null && this.rvdConfig.getExternalServicepMaxPerRoute() != null ? this.rvdConfig.getExternalServicepMaxPerRoute() : null;
    }

    public List<RvdMaxPerHost> getDefaultHttpMaxPerRoute() {
        return this.rvdConfig != null && this.rvdConfig.getDefaultHttpMaxPerRoute() != null ? this.rvdConfig.getDefaultHttpMaxPerRoute() : null;
    }

    public Boolean getDynamicRestcommResolving() {
        return this.dynamicRestcommResolving;
    }
}

