/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.concurrency.ResidentProjectInfo;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.logging.ProjectLogger;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.server.ProjectOptions;
import org.restcomm.connect.rvd.storage.ProjectDao;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

public class ProjectAwareRvdContext
extends RvdContext {
    private String projectName;
    private ProjectLogger projectLogger;
    private ProjectSettings projectSettings;
    private ProjectOptions projectOptions;

    public ProjectAwareRvdContext(String projectName, ResidentProjectInfo residentInfo, HttpServletRequest request, ServletContext servletContext, RvdConfiguration configuration, LoggingContext loggingPrefix, ProjectDao projectDao) throws ProjectDoesNotExist {
        super(request, servletContext, configuration, loggingPrefix);
        if (projectName == null) {
            throw new IllegalArgumentException();
        }
        this.projectLogger = new ProjectLogger(projectName, this.getConfiguration(), this.getMarshaler(), residentInfo.logRotationSemaphore);
        try {
            this.projectSettings = projectDao.loadSettings();
            if (this.projectSettings == null) {
                this.projectSettings = ProjectSettings.createDefault();
            }
            this.projectOptions = projectDao.loadProjectOptions();
            if (this.projectOptions == null) {
                throw new ProjectDoesNotExist("Project '" + projectName + "' does not exist.");
            }
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public ProjectLogger getProjectLogger() {
        return this.projectLogger;
    }

    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    public ProjectOptions getProjectOptions() {
        return this.projectOptions;
    }
}

