/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.restcomm.connect.rvd.commons.http.SslMode;
import org.restcomm.connect.rvd.configuration.RvdMaxPerHost;

public interface RvdConfiguration {
    public static final SslMode DEFAULT_SSL_MODE = SslMode.strict;
    public static final boolean DEFAULT_USE_HOSTNAME_TO_RESOLVE_RELATIVE_URL = true;
    public static final boolean DEFAULT_USE_ABSOLUTE_APPLICATION_URL = false;
    public static final boolean DEFAULT_USSD_SUPPORT = true;
    public static final String DEFAULT_WELCOME_MESSAGE = "Welcome to Telestax Restcom Visual Designer Demo";
    public static final boolean DEFAULT_DYNAMIC_RESTCOMM_RESOLVING = false;
    public static final String WORKSPACE_DIRECTORY_NAME = "workspace";
    public static final String PROTO_DIRECTORY_PREFIX = "_proto";
    public static final String REST_SERVICES_PATH = "services";
    public static final String USERS_DIRECTORY_NAME = "@users";
    public static final String WAVS_DIRECTORY_NAME = "wavs";
    public static final String RVD_PROJECT_VERSION = "1.13";
    public static final String PACKAGING_VERSION = "1.0";
    public static final String RAS_APPLICATION_VERSION = "2";
    public static final String STICKY_PREFIX = "sticky_";
    public static final String MODULE_PREFIX = "module_";
    public static final String CORE_VARIABLE_PREFIX = "core_";
    public static final String PACKAGING_DIRECTORY_NAME = "packaging";
    public static final int DEFAULT_ES_TIMEOUT = 5000;
    public static final int DEFAULT_ES_MAX_CONNS = 2000;
    public static final int DEFAULT_ES_MAX_CONNS_PER_ROUTE = 10;
    public static final int DEFAULT_ES_TTL = 30000;
    public static final int DEFAULT_HTTP_TIMEOUT = 1000;
    public static final int DEFAULT_HTTP_MAX_CONNS = 200;
    public static final int DEFAULT_HTTP_MAX_CONNS_PER_ROUTE = 100;
    public static final int DEFAULT_HTTP_TTL = 300000;
    public static final String[] DEFAULT_HTTP_MAX_PER_ROUTE = new String[0];
    public static final String PROJECT_LOG_FILENAME = "rvdapp";
    public static final int PROJECT_LOG_BACKLOG_COUNT = 3;
    public static final int PROJECT_LOG_ROTATION_SIZE = 300000;
    public static final String DEFAULT_APPSTORE_DOMAIN = "apps.restcomm.com";
    public static final HashSet<String> builtinRestcommParameters = new HashSet<String>(Arrays.asList("CallSid", "AccountSid", "From", "To", "Body", "CallStatus", "ApiVersion", "Direction", "CallerName", "CallTimestamp", "ForwardedFrom", "SmsSid", "SmsStatus", "InstanceId", "ReferTarget", "Transferor", "Transferee"));
    public static final String RESTCOMM_HEADER_PREFIX = "SipHeader_";
    public static final String RESTCOMM_HEADER_PREFIX_DIAL = "DialSipHeader_";
    public static final String DEFAULT_MEDIA_ALLOWED_EXTENSIONS = "wav|mp4";
    public static final String ADMINISTRATOR_ROLE = "Administrator";

    public String getWorkspaceBasePath();

    public String getProjectBasePath(String var1);

    public SslMode getSslMode();

    public Integer getExternalServiceTimeout();

    public Integer getExternalServiceMaxConns();

    public Integer getExternalServiceMaxConnsPerRoute();

    public Integer getExternalServiceTTL();

    public List<RvdMaxPerHost> getExternalServiceMaxPerRoute();

    public Integer getDefaultHttpTimeout();

    public Integer getDefaultHttpMaxConns();

    public Integer getDefaultHttpMaxConnsPerRoute();

    public Integer getDefaultHttpTTL();

    public List<RvdMaxPerHost> getDefaultHttpMaxPerRoute();

    public boolean getUseHostnameToResolveRelativeUrl();

    public String getHostnameOverride();

    public String getRestcommBaseUri();

    public Boolean getDynamicRestcommResolving();

    public String getApplicationsRelativeUrl();

    public Integer getMaxMediaFileSize();

    public Boolean getVideoSupport();

    public String getBaseUrl();

    public Boolean useAbsoluteApplicationUrl();

    public String getContextPath();

    public boolean isUssdSupport();

    public String getWelcomeMessage();

    public String getRvdInstanceId();
}

