/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.bootstrap;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.ApplicationContext;
import org.restcomm.connect.rvd.ApplicationContextBuilder;
import org.restcomm.connect.rvd.FileRvdConfiguration;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.bootstrap.WorkspaceBootstrapper;
import org.restcomm.connect.rvd.commons.http.CustomHttpClientBuilder;
import org.restcomm.connect.rvd.concurrency.ProjectRegistry;
import org.restcomm.connect.rvd.configuration.RestcommLocationResolver;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.upgrade.UpgradeService;

public class RvdInitializationServlet
extends HttpServlet {
    static Logger logger = RvdLoggers.global;

    public void init(ServletConfig config) throws ServletException {
        FileRvdConfiguration rvdConfiguration;
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        RvdLoggers.init((String)servletContext.getRealPath("/../../log/rvd/"));
        logger.info((Object)"--- Initializing RVD. Project version: 1.13 ---");
        try {
            FileRvdConfiguration fileRvdconfiguration = new FileRvdConfiguration(servletContext);
            logger.info((Object)fileRvdconfiguration.toString());
            rvdConfiguration = fileRvdconfiguration;
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Error loading rvd configuration file rvd.xml. RVD operation will be broken.", (Throwable)e);
            throw e;
        }
        CustomHttpClientBuilder httpClientBuilder = new CustomHttpClientBuilder((RvdConfiguration)rvdConfiguration);
        CloseableHttpClient buildHttpClient = httpClientBuilder.buildHttpClient();
        RestcommLocationResolver restcommResolver = new RestcommLocationResolver((RvdConfiguration)rvdConfiguration);
        ApplicationContext appContext = new ApplicationContextBuilder().setConfiguration((RvdConfiguration)rvdConfiguration).setHttpClientBuilder(httpClientBuilder).setDefaultHttpClient(buildHttpClient).setExternalHttpClient(httpClientBuilder.buildExternalHttpClient()).setProjectRegistry(new ProjectRegistry()).setRestcommResolver(restcommResolver).build();
        servletContext.setAttribute(ApplicationContext.class.getName(), (Object)appContext);
        WorkspaceBootstrapper workspaceBootstrapper = new WorkspaceBootstrapper(rvdConfiguration.getWorkspaceBasePath());
        workspaceBootstrapper.run();
        ModelMarshaler marshaler = new ModelMarshaler();
        WorkspaceStorage workspaceStorage = new WorkspaceStorage(rvdConfiguration.getWorkspaceBasePath(), marshaler);
        UpgradeService upgradeService = new UpgradeService(workspaceStorage);
        try {
            upgradeService.upgradeWorkspace();
        }
        catch (StorageException e) {
            logger.log((Priority)Level.ERROR, (Object)("Error upgrading workspace at " + rvdConfiguration.getWorkspaceBasePath()), (Throwable)e);
        }
    }

    public void destroy() {
        logger.info((Object)" --- shutting down RVD --- ");
        ApplicationContext appCtx = (ApplicationContext)this.getServletContext().getAttribute(ApplicationContext.class.getName());
        HttpClientUtils.closeQuietly((HttpClient)appCtx.getDefaultHttpClient());
        HttpClientUtils.closeQuietly((HttpClient)appCtx.getExternaltHttpClient());
        super.destroy();
    }
}

