/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.commons.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.commons.http.SslMode;
import org.restcomm.connect.rvd.configuration.RvdMaxPerHost;

public class CustomHttpClientBuilder {
    private RvdConfiguration configuration;

    public CustomHttpClientBuilder(RvdConfiguration configuration) {
        this.configuration = configuration;
    }

    public CloseableHttpClient buildExternalHttpClient() {
        return this.buildClient(this.configuration.getExternalServiceTimeout(), this.configuration.getExternalServiceMaxConns(), this.configuration.getExternalServiceMaxConnsPerRoute(), this.configuration.getExternalServiceTTL(), this.configuration.getExternalServiceMaxPerRoute());
    }

    public CloseableHttpClient buildHttpClient() {
        return this.buildClient(this.configuration.getDefaultHttpTimeout(), this.configuration.getDefaultHttpMaxConns(), this.configuration.getDefaultHttpMaxConnsPerRoute(), this.configuration.getDefaultHttpTTL(), this.configuration.getDefaultHttpMaxPerRoute());
    }

    private CloseableHttpClient buildClient(Integer timeout, Integer maxConns, Integer maxConnsPerRoute, Integer timeToLive, List<RvdMaxPerHost> routes) {
        HttpClientBuilder builder = HttpClients.custom();
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(timeout.intValue()).setConnectionRequestTimeout(timeout.intValue()).setSocketTimeout(timeout.intValue());
        builder.setDefaultRequestConfig(configBuilder.build());
        builder.setMaxConnPerRoute(maxConnsPerRoute.intValue());
        builder.setMaxConnTotal(maxConns.intValue());
        builder.setConnectionTimeToLive((long)timeToLive.intValue(), TimeUnit.MILLISECONDS);
        SSLConnectionSocketFactory sslsf = null;
        sslsf = this.configuration.getSslMode() == SslMode.strict ? this.buildStrictFactory() : this.buildAllowallFactory();
        if (sslsf != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        if (routes != null && routes.size() > 0) {
            if (sslsf == null) {
                PublicSuffixMatcher publicSuffixMatcherCopy = PublicSuffixMatcherLoader.getDefault();
                DefaultHostnameVerifier hostnameVerifierCopy = new DefaultHostnameVerifier(publicSuffixMatcherCopy);
                sslsf = new SSLConnectionSocketFactory(SSLContexts.createDefault(), (HostnameVerifier)hostnameVerifierCopy);
            }
            Registry reg = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(reg, null, null, null, (long)timeToLive.intValue(), TimeUnit.MILLISECONDS);
            poolingmgr.setMaxTotal(maxConns.intValue());
            poolingmgr.setDefaultMaxPerRoute(maxConnsPerRoute.intValue());
            for (RvdMaxPerHost route : routes) {
                try {
                    URL url = new URL(route.getUrl());
                    HttpRoute r = new HttpRoute(new HttpHost(url.getHost(), url.getPort()));
                    poolingmgr.setMaxPerRoute(r, route.getMaxConnections().intValue());
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            builder.setConnectionManager((HttpClientConnectionManager)poolingmgr);
        }
        CloseableHttpClient httpclient = builder.build();
        return httpclient;
    }

    private SSLConnectionSocketFactory buildStrictFactory() {
        SSLConnectionSocketFactory sslsf = null;
        String[] protocols = this.getSSLPrototocolsFromSystemProperties();
        if (protocols != null) {
            SSLContext sslcontext = SSLContexts.createDefault();
            sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, (HostnameVerifier)new DefaultHostnameVerifier());
        }
        return sslsf;
    }

    private SSLConnectionSocketFactory buildAllowallFactory() {
        SSLContext sslcontext;
        String[] protocols = this.getSSLPrototocolsFromSystemProperties();
        try {
            sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, protocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        return sslsf;
    }

    private String[] getSSLPrototocolsFromSystemProperties() {
        String protocols = System.getProperty("jdk.tls.client.protocols");
        if (protocols == null) {
            protocols = System.getProperty("https.protocols");
        }
        if (protocols != null) {
            String[] protocolsArray = protocols.split(",");
            return protocolsArray;
        }
        return null;
    }
}

