/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.configuration;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.http.utils.UriUtils;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class RestcommLocationResolver {
    static Logger logger = RvdLoggers.local;
    RvdConfiguration config;
    URI baseUrlCache = null;
    boolean cached = false;

    public RestcommLocationResolver(RvdConfiguration config) {
        this.config = config;
    }

    public URI resolveRestcommBaseUrl(HttpServletRequest request) {
        URI resultUri = null;
        if (this.config.getDynamicRestcommResolving().booleanValue()) {
            String origin = RvdUtils.getOriginFromRequest((HttpServletRequest)request);
            try {
                resultUri = new URI(origin);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Couldn't parse '" + origin + "'", e);
            }
        }
        if (this.cached) {
            resultUri = this.baseUrlCache;
        } else {
            this.cached = true;
            String rawUrl = this.config.getRestcommBaseUri();
            if (!RvdUtils.isEmpty((String)rawUrl)) {
                try {
                    URI uri = new URI(rawUrl);
                    if (!RvdUtils.isEmpty((String)uri.getScheme()) && !RvdUtils.isEmpty((String)uri.getHost())) {
                        resultUri = uri;
                    } else {
                        logger.error((Object)("Invalid restcommBaseUrl in rvd.xml: " + rawUrl + ". Will use automatic value."));
                    }
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Couldn't parse '" + rawUrl + "'", e);
                }
            }
            if (resultUri == null) {
                UriUtils uriUtils = new UriUtils(this.config);
                try {
                    URI uri = new URI("");
                    resultUri = uriUtils.resolve(uri);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            this.baseUrlCache = resultUri;
            logger.info((Object)("using fixed location for restcomm server - " + resultUri.toString()));
        }
        return resultUri;
    }
}

