/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http;

import com.google.gson.Gson;
import org.restcomm.connect.rvd.exceptions.ExceptionResult;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.http.RvdResponse;
import org.restcomm.connect.rvd.jsonvalidation.exceptions.ValidationException;
import org.restcomm.connect.rvd.validation.ValidationReport;

public class RvdResponse {
    Status rvdStatus;
    ExceptionResult exception;
    ValidationReport report;
    Object payload;

    public RvdResponse() {
        this.rvdStatus = Status.OK;
    }

    public RvdResponse(Status status) {
        this.rvdStatus = status;
    }

    public RvdResponse setStatus(Status status) {
        this.rvdStatus = status;
        return this;
    }

    public RvdResponse setValidationException(ValidationException e) {
        if (e != null) {
            this.exception = new ExceptionResult(e.getClass().getSimpleName(), e.getMessage(), e.getValidationResult());
            this.rvdStatus = Status.INVALID;
        }
        return this;
    }

    public RvdResponse setExceptionInfo(RvdException e) {
        if (e != null) {
            this.exception = e.getExceptionSummary();
        }
        return this;
    }

    public RvdResponse setExceptionInfo(ExceptionResult exceptionInfo) {
        this.exception = exceptionInfo;
        return this;
    }

    public RvdResponse setReport(ValidationReport report) {
        this.report = report;
        return this;
    }

    public RvdResponse setOkPayload(Object payload) {
        this.payload = payload;
        this.rvdStatus = Status.OK;
        return this;
    }

    public String asJson() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }
}

