/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.cors;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.ws.rs.ext.Provider;
import org.restcomm.connect.rvd.FileRvdConfiguration;
import org.restcomm.connect.rvd.configuration.RvdConfig;

@Provider
public class CorsFilter
implements ContainerResponseFilter {
    List<String> allowedOrigins;

    public CorsFilter() {
        URL url = CorsFilter.class.getClassLoader().getResource("rvd.version");
        String rootPath = url.getFile();
        String webInfPath = rootPath.substring(0, rootPath.indexOf("/classes/"));
        File rvdXmlFile = new File(webInfPath + "/rvd.xml");
        RvdConfig rvdConfig = FileRvdConfiguration.loadRvdXmlConfig((String)rvdXmlFile.getAbsolutePath());
        this.allowedOrigins = rvdConfig.getAllowedCorsOrigins();
    }

    public ContainerResponse filter(ContainerRequest cres, ContainerResponse response) {
        String requestOrigin = cres.getHeaderValue("Origin");
        if (requestOrigin != null && this.allowedOrigins != null && !this.allowedOrigins.isEmpty() && (this.allowedOrigins.contains(requestOrigin) || this.allowedOrigins.contains("*"))) {
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Origin", (Object)requestOrigin);
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization");
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
            response.getHttpHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
            response.getHttpHeaders().add((Object)"Access-Control-Max-Age", (Object)"1209600");
        }
        return response;
    }
}

