/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.BasicAuthCredentials;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.model.LoginForm;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfo;

@Path(value="auth")
public class LoginRestService
extends SecuredRestService {
    @PostConstruct
    public void init() {
        super.init();
    }

    public LoginRestService() {
    }

    LoginRestService(UserIdentityContext context) {
        super(context);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="login")
    public Response postLogin(@Context HttpServletRequest request) throws IOException {
        Gson gson = new Gson();
        String data = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
        LoginForm form = (LoginForm)gson.fromJson(data, LoginForm.class);
        BasicAuthCredentials creds = new BasicAuthCredentials(form.getUsername(), form.getPassword());
        RestcommAccountInfo accountInfo = this.accountProvider.getActiveAccount(creds);
        if (accountInfo != null) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="keepalive")
    public Response keepalive() {
        this.secure();
        return Response.ok().build();
    }
}

