/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.ApplicationContext;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.AccessApiException;
import org.restcomm.connect.rvd.exceptions.AuthorizationException;
import org.restcomm.connect.rvd.exceptions.NotificationProcessingError;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.http.resources.NotificationsRestService;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.project.RvdProject;
import org.restcomm.connect.rvd.restcomm.RestcommApplicationResponse;
import org.restcomm.connect.rvd.restcomm.RestcommApplicationsResponse;
import org.restcomm.connect.rvd.restcomm.RestcommClient;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;

@Path(value="notifications")
public class NotificationsRestService
extends SecuredRestService {
    private LoggingContext logging = new LoggingContext("[designer]");
    private ProjectService projectService;

    public NotificationsRestService() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.logging.appendAccountSid(this.getUserIdentityContext().getAccountSid());
        RvdContext rvdContext = new RvdContext(this.request, this.servletContext, this.applicationContext.getConfiguration(), this.logging);
        WorkspaceStorage storage = new WorkspaceStorage(this.applicationContext.getConfiguration().getWorkspaceBasePath(), rvdContext.getMarshaler());
        this.projectService = new ProjectService(rvdContext, storage);
    }

    NotificationsRestService(UserIdentityContext userIdentityContext, ProjectService projectService) {
        super(userIdentityContext);
        this.projectService = projectService;
    }

    public NotificationsRestService(ApplicationContext applicationContext, UserIdentityContext userIdentityContext, ProjectService projectService) {
        super(applicationContext, userIdentityContext);
        this.projectService = projectService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response postNotifications(@Context HttpServletRequest req) {
        this.secure();
        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"postNotification", (String)(this.logging.getPrefix() + "received notifications")));
        }
        try {
            JsonArray notifications;
            JsonParser parse = new JsonParser();
            try {
                notifications = parse.parse((Reader)new InputStreamReader((InputStream)req.getInputStream(), Charset.forName("UTF-8"))).getAsJsonArray();
            }
            catch (IOException e) {
                RvdLoggers.global.log((Priority)Level.ERROR, (Object)"could not parse notification from restcomm", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            for (int i = 0; i < notifications.size(); ++i) {
                JsonObject notif = notifications.get(i).getAsJsonObject();
                String type = notif.get("type").getAsString();
                if (NotificationType.accountClosed.toString().equals(type)) {
                    String accountSid = notif.get("accountSid").getAsString();
                    try {
                        this.processAccountRemovalNotification(accountSid);
                        continue;
                    }
                    catch (NotificationProcessingError e) {
                        RvdLoggers.global.log((Priority)Level.ERROR, (Object)(this.logging.getPrefix() + "error processing restcomm notification"), (Throwable)e);
                        if (e.getType() == NotificationProcessingError.Type.AccountIsMissing || e.getType() == NotificationProcessingError.Type.AccountNotAccessible) continue;
                        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                    }
                }
                if (!NotificationType.applicationRemoved.equals((Object)type)) continue;
                String applicationSid = notif.get("applicationSid").getAsString();
                this.processApplicationRemovalNotification(applicationSid);
            }
        }
        catch (ProjectDoesNotExist e) {
            RvdLoggers.global.log((Priority)Level.WARN, (Object)(this.logging.getPrefix() + "ProjectDoesNotExist exception: " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (RvdException e) {
            RvdLoggers.global.log((Priority)Level.ERROR, (Object)"exception", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().build();
    }

    void processApplicationRemovalNotification(String applicationSid) throws RvdException {
        RvdProject project = this.projectService.load(applicationSid);
        if (!this.getLoggedUsername().equalsIgnoreCase(project.getState().getHeader().getOwner())) {
            throw new AuthorizationException();
        }
        this.projectService.deleteProject(applicationSid);
    }

    void processAccountRemovalNotification(String removedAccountSid) throws RvdException {
        RestcommClient client = new RestcommClient(this.restcommBaseUrl, this.getUserIdentityContext().getEffectiveAuthorizationHeader(), this.applicationContext.getDefaultHttpClient());
        RestcommApplicationsResponse applications = null;
        try {
            applications = (RestcommApplicationsResponse)client.get("/restcomm/2012-04-24/Accounts/" + removedAccountSid + "/Applications.json").done(new Gson(), RestcommApplicationsResponse.class);
        }
        catch (AccessApiException e) {
            if (404 == e.getStatusCode()) {
                throw new NotificationProcessingError("Cannot find removed account '" + removedAccountSid + "'. No projects will be removed", NotificationProcessingError.Type.AccountIsMissing);
            }
            if (403 == e.getStatusCode()) {
                throw new NotificationProcessingError("User " + this.getLoggedUsername() + " can't access account " + removedAccountSid + " and remove its projects", NotificationProcessingError.Type.AccountNotAccessible);
            }
            throw new NotificationProcessingError("User " + this.getLoggedUsername() + " failed project for account " + removedAccountSid + ". Couldn't fetch application list. " + (e.getStatusCode() != null ? "status: " + e.getStatusCode() : ""));
        }
        if (applications != null) {
            for (RestcommApplicationResponse app : applications) {
                try {
                    this.projectService.deleteProject(app.getSid());
                }
                catch (ProjectDoesNotExist e) {
                    RvdLoggers.global.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"processAccountRemovalNotification", (String)"{0} project {1} wasn't removed because it wasn't found", (Object[])new Object[]{this.logging.getPrefix(), app.getSid()}));
                }
            }
        }
    }
}

