/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.BuildService;
import org.restcomm.connect.rvd.ProjectApplicationsApi;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.ApplicationAlreadyExists;
import org.restcomm.connect.rvd.exceptions.ApplicationApiNotSynchedException;
import org.restcomm.connect.rvd.exceptions.ApplicationsApiSyncException;
import org.restcomm.connect.rvd.exceptions.AuthorizationException;
import org.restcomm.connect.rvd.exceptions.ForbiddenResourceException;
import org.restcomm.connect.rvd.exceptions.IncompatibleProjectVersion;
import org.restcomm.connect.rvd.exceptions.InvalidServiceParameters;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.StreamDoesNotFitInFile;
import org.restcomm.connect.rvd.exceptions.project.ProjectException;
import org.restcomm.connect.rvd.exceptions.project.UnsupportedProjectVersion;
import org.restcomm.connect.rvd.http.RvdResponse;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.jsonvalidation.exceptions.ValidationException;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.CallControlInfo;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.project.ProjectState;
import org.restcomm.connect.rvd.model.project.StateHeader;
import org.restcomm.connect.rvd.storage.FsCallControlInfoStorage;
import org.restcomm.connect.rvd.storage.FsProjectDao;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.ProjectDao;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.BadWorkspaceDirectoryStructure;
import org.restcomm.connect.rvd.storage.exceptions.ProjectAlreadyExists;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.storage.exceptions.WavItemDoesNotExist;
import org.restcomm.connect.rvd.upgrade.UpgradeService;
import org.restcomm.connect.rvd.upgrade.exceptions.UpgradeException;
import org.restcomm.connect.rvd.utils.RvdUtils;

@Path(value="projects")
public class ProjectRestService
extends SecuredRestService {
    @Context
    HttpServletRequest request;
    private ProjectService projectService;
    private RvdConfiguration configuration;
    private ProjectState activeProject;
    private ModelMarshaler marshaler;
    private WorkspaceStorage workspaceStorage;
    private LoggingContext logging;
    RvdContext rvdContext;
    static Pattern mediaFilenamePattern = Pattern.compile(".*\\.(wav|mp4)$");

    @PostConstruct
    public void init() {
        super.init();
        this.logging = new LoggingContext("[designer]");
        this.logging.appendAccountSid(this.getUserIdentityContext().getAccountSid());
        this.rvdContext = new RvdContext(this.request, this.servletContext, this.applicationContext.getConfiguration(), this.logging);
        this.configuration = this.rvdContext.getConfiguration();
        this.marshaler = this.rvdContext.getMarshaler();
        this.workspaceStorage = new WorkspaceStorage(this.configuration.getWorkspaceBasePath(), this.marshaler);
        this.projectService = new ProjectService(this.rvdContext, this.workspaceStorage);
    }

    public ProjectRestService() {
    }

    ProjectRestService(UserIdentityContext context) {
        super(context);
    }

    void assertProjectStateAvailable(String projectName, ProjectDao projectDao) throws StorageException, ProjectDoesNotExist {
        ProjectState project = projectDao.loadProject();
        if (project == null) {
            throw new ProjectDoesNotExist("Project " + projectName + " does not exist");
        }
        if (project.getHeader().getOwner() != null) {
            String loggedUser = this.getUserIdentityContext().getAccountUsername();
            if (loggedUser != null) {
                if (loggedUser.equals(project.getHeader().getOwner())) {
                    this.activeProject = project;
                    return;
                }
                throw new ForbiddenResourceException();
            }
            throw new AuthorizationException();
        }
        this.activeProject = project;
    }

    @GET
    @Produces(value={"application/json"})
    public Response listProjects(@Context HttpServletRequest request) {
        List items;
        this.secure();
        try {
            items = this.projectService.getAvailableProjectsByOwner(this.getLoggedUsername());
            this.projectService.fillStartUrlsForProjects(items, request);
        }
        catch (BadWorkspaceDirectoryStructure e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (ProjectException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson((Object)items), (String)"application/json").build();
    }

    @PUT
    @Path(value="{name}")
    public Response createProject(@PathParam(value="name") String name, @QueryParam(value="kind") String kind, @QueryParam(value="ticket") String ticket) {
        this.secure();
        ProjectApplicationsApi applicationsApi = null;
        String applicationSid = null;
        if (RvdLoggers.local.isTraceEnabled()) {
            RvdLoggers.local.log((Priority)Level.TRACE, (Object)(this.logging.getPrefix() + " Will create project labeled " + name));
        }
        try {
            applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext, this.restcommBaseUrl);
            applicationSid = applicationsApi.createApplication(name, kind);
            ProjectState projectState = this.projectService.createProject(applicationSid, kind, this.getLoggedUsername());
            BuildService buildService = new BuildService(this.workspaceStorage);
            buildService.buildProject(applicationSid, projectState);
        }
        catch (ProjectAlreadyExists e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            try {
                applicationsApi.rollbackCreateApplication(applicationSid);
            }
            catch (ApplicationsApiSyncException e1) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidServiceParameters e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"createProject", (String)this.logging.getPrefix(), (String)e.getMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ApplicationAlreadyExists e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (ApplicationsApiSyncException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (UnsupportedEncodingException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Gson gson = new Gson();
        JsonObject projectInfo = new JsonObject();
        projectInfo.addProperty("name", name);
        projectInfo.addProperty("sid", applicationSid);
        projectInfo.addProperty("kind", kind);
        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"createProject", (String)"{0}created {1} project {2} ({3})", (Object[])new Object[]{this.logging.getPrefix(), kind, name, applicationSid}));
        }
        return Response.ok((Object)gson.toJson((JsonElement)projectInfo), (String)"application/json").build();
    }

    @GET
    @Path(value="{applicationSid}/info")
    public Response projectInfo(@PathParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        this.assertProjectStateAvailable(applicationSid, projectDao);
        StateHeader header = this.activeProject.getHeader();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.marshaler.getGson().toJson((Object)header)).type("application/json").build();
    }

    @POST
    @Path(value="{applicationSid}")
    public Response updateProject(@Context HttpServletRequest request, @PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        this.logging.appendApplicationSid(applicationSid);
        if (applicationSid != null && !applicationSid.equals("")) {
            try {
                ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
                ProjectState existingProject = projectDao.loadProject();
                if (existingProject == null) {
                    throw new ProjectDoesNotExist("project '" + applicationSid + "' does not exist (state data not found).");
                }
                if (this.getLoggedUsername().equals(existingProject.getHeader().getOwner()) || existingProject.getHeader().getOwner() == null) {
                    this.projectService.updateProject(request, applicationSid, existingProject);
                    if (RvdLoggers.local.isDebugEnabled()) {
                        RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"updateProject", (String)this.logging.getPrefix(), (String)"updated project"));
                    }
                    return this.buildOkResponse();
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (ValidationException e) {
                RvdResponse rvdResponse = new RvdResponse().setValidationException(e);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)rvdResponse.asJson()).build();
            }
            catch (IncompatibleProjectVersion e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.asJson()).type("application/json").build();
            }
            catch (RvdException e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, e);
            }
        }
        RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"updateProject", (String)this.logging.getPrefix(), (String)"no id specified when updating project"));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="{applicationSid}/cc")
    public Response storeCcInfo(@PathParam(value="applicationSid") String applicationSid, @Context HttpServletRequest request) {
        this.secure();
        this.logging.appendApplicationSid(applicationSid);
        try {
            String data = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            CallControlInfo ccInfo = (CallControlInfo)this.marshaler.toModel(data, CallControlInfo.class);
            if (ccInfo != null) {
                FsCallControlInfoStorage.storeInfo((CallControlInfo)ccInfo, (String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
                if (RvdLoggers.local.isDebugEnabled()) {
                    RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"storeCcInfo", (String)this.logging.getPrefix(), (String)"updated web trigger settings (enabled)"));
                }
            } else {
                FsCallControlInfoStorage.clearInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
                if (RvdLoggers.local.isDebugEnabled()) {
                    RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"storeCcInfo", (String)this.logging.getPrefix(), (String)"updated web trigger settings (disabled)"));
                }
            }
            return Response.ok().build();
        }
        catch (IOException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/cc")
    public Response getCcInfo(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            CallControlInfo ccInfo = FsCallControlInfoStorage.loadInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)this.marshaler.toData((Object)ccInfo), (String)"application/json").build();
        }
        catch (StorageEntityNotFound e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="{applicationSid}/rename")
    public Response renameProject(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="newName") String projectNewName, @QueryParam(value="ticket") String ticket) throws StorageException, ProjectDoesNotExist {
        this.secure();
        if (!RvdUtils.isEmpty((String)applicationSid) && !RvdUtils.isEmpty((String)projectNewName)) {
            ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
            this.assertProjectStateAvailable(applicationSid, projectDao);
            try {
                ProjectApplicationsApi applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext, this.restcommBaseUrl);
                try {
                    applicationsApi.renameApplication(applicationSid, projectNewName);
                }
                catch (ApplicationApiNotSynchedException e) {
                    RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"renameProject", (String)this.logging.getPrefix(), (String)e.getMessage()));
                }
                return Response.ok().build();
            }
            catch (ApplicationAlreadyExists e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            catch (ApplicationsApiSyncException e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @PUT
    @Path(value="{applicationSid}/upgrade")
    public Response upgradeProject(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (!RvdUtils.isEmpty((String)applicationSid)) {
            try {
                UpgradeService upgradeService = new UpgradeService(this.workspaceStorage);
                upgradeService.upgradeProject(applicationSid);
                if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                    RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeProject", (String)"{0} project {1} upgraded to version {2}", (Object[])new Object[]{this.logging.getPrefix(), applicationSid, "1.13"}));
                }
                BuildService buildService = new BuildService(this.workspaceStorage);
                buildService.buildProject(applicationSid, this.activeProject);
                if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                    RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeProject", (String)this.logging.getPrefix(), (String)("project " + applicationSid + " built")));
                }
                return Response.ok().build();
            }
            catch (StorageException e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            catch (UpgradeException e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.asJson()).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @DELETE
    @Path(value="{applicationSid}")
    public Response deleteProject(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="ticket") String ticket) throws RvdException {
        this.secure();
        this.logging.appendApplicationSid(applicationSid);
        if (!RvdUtils.isEmpty((String)applicationSid)) {
            try {
                try {
                    ProjectApplicationsApi applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext, this.restcommBaseUrl);
                    applicationsApi.removeApplication(applicationSid);
                    this.projectService.deleteProject(applicationSid);
                    if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                        RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"deleteProject", (String)this.logging.getPrefix(), (String)"project removed"));
                    }
                    return Response.ok().build();
                }
                catch (RvdException e) {
                    e.setApplicationSid(applicationSid);
                    e.setAccountSid(this.getUserIdentityContext().getAccountSid());
                    throw e;
                }
            }
            catch (StorageException e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)(this.logging.getPrefix() + "error deleting project " + applicationSid), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            catch (ApplicationsApiSyncException e) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)(this.logging.getPrefix() + "error deleting project through the API " + applicationSid), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="{applicationSid}/archive")
    public Response downloadArchive(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="projectName") String projectName) throws StorageException, ProjectDoesNotExist, UnsupportedEncodingException, EncoderException {
        this.secure();
        this.logging.appendApplicationSid(applicationSid);
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"downloadArchive", (String)(this.logging.getPrefix() + "downloading raw archive for project " + applicationSid)));
        }
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        this.assertProjectStateAvailable(applicationSid, projectDao);
        try {
            InputStream archiveStream = this.projectService.archiveProject(applicationSid);
            String dispositionHeader = "attachment; filename*=UTF-8''" + RvdUtils.myUrlEncode((String)(projectName + ".zip"));
            return Response.ok((Object)archiveStream, (String)"application/zip").header("Content-Disposition", (Object)dispositionHeader).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return null;
        }
    }

    @POST
    public Response importProjectArchive(@Context HttpServletRequest request, @QueryParam(value="name") String nameOverride) {
        this.secure();
        if (RvdLoggers.local.isTraceEnabled()) {
            RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"importProjectArchive", (String)this.logging.getPrefix(), (String)"importing project from raw archive"));
        }
        ProjectApplicationsApi applicationsApi = null;
        String applicationSid = null;
        try {
            if (request.getHeader("Content-Type") != null && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
                Gson gson = new Gson();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                JsonArray fileinfos = new JsonArray();
                int filesCounted = 0;
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    JsonObject fileinfo = new JsonObject();
                    fileinfo.addProperty("field", item.getFieldName());
                    if (item.getName() != null) {
                        ++filesCounted;
                        String tempName = "RvdImport-" + UUID.randomUUID().toString().replace("-", "");
                        applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext, this.restcommBaseUrl);
                        applicationSid = applicationsApi.createApplication(tempName, "");
                        String effectiveProjectName = null;
                        try {
                            this.projectService.importProjectFromRawArchive(item.openStream(), applicationSid, this.getLoggedUsername());
                            effectiveProjectName = FilenameUtils.getBaseName((String)item.getName());
                            if (filesCounted == 1 && nameOverride != null) {
                                effectiveProjectName = nameOverride;
                            }
                            ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
                            String projectString = projectDao.loadProjectStateRaw();
                            ProjectState state = (ProjectState)this.marshaler.toModel(projectString, ProjectState.class);
                            String projectKind = state.getHeader().getProjectKind();
                            applicationsApi.updateApplication(applicationSid, effectiveProjectName, null, projectKind);
                            if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                                RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"importProjectArchive", (String)"{0}imported project {1} from raw archive ''{2}''", (Object[])new Object[]{this.logging.getPrefix(), applicationSid, item.getName()}));
                            }
                        }
                        catch (Exception e) {
                            applicationsApi.rollbackCreateApplication(applicationSid);
                            throw e;
                        }
                        fileinfo.addProperty("name", effectiveProjectName);
                        fileinfo.addProperty("id", applicationSid);
                    }
                    if (item.getName() == null) {
                        RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"importProjectArchive", (String)this.logging.getPrefix(), (String)"non-file part found in upload"));
                        fileinfo.addProperty("value", this.read(item.openStream()));
                    }
                    fileinfos.add((JsonElement)fileinfo);
                }
                return Response.ok((Object)gson.toJson((JsonElement)fileinfos), (String)"application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (UnsupportedProjectVersion | StorageException e) {
            RvdLoggers.local.log((Priority)Level.WARN, (Object)this.logging.getPrefix(), e);
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, RvdResponse.Status.ERROR, (RvdException)e);
        }
        catch (ApplicationAlreadyExists e) {
            RvdLoggers.local.log((Priority)Level.WARN, (Object)this.logging.getPrefix(), (Throwable)e);
            try {
                applicationsApi.rollbackCreateApplication(applicationSid);
            }
            catch (ApplicationsApiSyncException e1) {
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
                return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, (RvdException)((Object)e));
            }
            return this.buildErrorResponse(Response.Status.CONFLICT, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (Exception e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}")
    @Produces(value={"application/json"})
    public Response openProject(@PathParam(value="applicationSid") String applicationSid, @Context HttpServletRequest request) throws StorageException, ProjectDoesNotExist {
        this.secure();
        this.logging.appendApplicationSid(applicationSid);
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        try {
            this.assertProjectStateAvailable(applicationSid, projectDao);
        }
        catch (RvdException e) {
            e.setAccountSid(this.getUserIdentityContext().getAccountSid());
            e.setApplicationSid(applicationSid);
            throw e;
        }
        return Response.ok().entity((Object)this.marshaler.toData((Object)this.activeProject)).build();
    }

    @POST
    @Path(value="{applicationSid}/wavs")
    public Response uploadWavFile(@PathParam(value="applicationSid") String applicationSid, @Context HttpServletRequest request) throws StorageException, ProjectDoesNotExist {
        this.secure();
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        this.assertProjectStateAvailable(applicationSid, projectDao);
        this.logging.appendPrefix(applicationSid);
        try {
            if (request.getHeader("Content-Type") != null && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
                Gson gson = new Gson();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                JsonArray fileinfos = new JsonArray();
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    JsonObject fileinfo = new JsonObject();
                    fileinfo.addProperty("fieldName", item.getFieldName());
                    String filename = item.getName();
                    if (filename != null) {
                        if (!mediaFilenamePattern.matcher(filename).matches()) {
                            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage((String)this.logging.getPrefix(), (String)("Media filename/extension not allowed: " + filename)));
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\":\"FILE_EXT_NOT_ALLOWED\"}").build();
                        }
                        try {
                            this.projectService.addWavToProject(applicationSid, filename, item.openStream());
                        }
                        catch (StreamDoesNotFitInFile e) {
                            Integer maxSize = this.rvdContext.getConfiguration().getMaxMediaFileSize();
                            RvdLoggers.local.log((Priority)Level.INFO, (Object)(LoggingHelper.buildMessage((String)this.logging.getPrefix(), (String)("Media file too big. Maximum size is " + maxSize)) + " bytes"));
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"error\":\"FILE_TOO_BIG\", \"maxSize\": " + maxSize + "}")).build();
                        }
                        fileinfo.addProperty("name", filename);
                        if (RvdLoggers.local.isDebugEnabled()) {
                            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)(this.logging.getPrefix() + " uploaded wav " + filename));
                        }
                    } else {
                        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                            RvdLoggers.local.log((Priority)Level.INFO, (Object)(this.logging.getPrefix() + " non-file part found in upload"));
                        }
                        fileinfo.addProperty("value", this.read(item.openStream()));
                    }
                    fileinfos.add((JsonElement)fileinfo);
                }
                return Response.ok((Object)gson.toJson((JsonElement)fileinfos), (String)"application/json").build();
            }
            String json_response = "{\"result\":[{\"size\":" + this.size((InputStream)request.getInputStream()) + "}]}";
            return Response.ok((Object)json_response, (String)"application/json").build();
        }
        catch (Exception e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="{applicationSid}/wavs")
    public Response removeWavFile(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="filename") String wavname, @Context HttpServletRequest request) throws StorageException, ProjectDoesNotExist {
        this.secure();
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        this.assertProjectStateAvailable(applicationSid, projectDao);
        try {
            this.projectService.removeWavFromProject(applicationSid, wavname);
            return Response.ok().build();
        }
        catch (WavItemDoesNotExist e) {
            if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"removeWavFile", (String)"{0} cannot remove {1} from {2}", (Object[])new Object[]{this.logging.getPrefix(), wavname, applicationSid}));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/wavs")
    @Produces(value={"application/json"})
    public Response listWavs(@PathParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        this.assertProjectStateAvailable(applicationSid, projectDao);
        try {
            List items = this.projectService.getWavs(applicationSid);
            Gson gson = new Gson();
            return Response.ok((Object)gson.toJson((Object)items), (String)"application/json").build();
        }
        catch (BadWorkspaceDirectoryStructure e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)(this.logging.getPrefix() + "error getting wav list for project " + applicationSid), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/{placeholder: (wavs|media)}/{filename}.{ext: (wav|mp4)}")
    public Response getWavNoQueryParams(@PathParam(value="applicationSid") String applicationSid, @PathParam(value="filename") String filename, @PathParam(value="ext") String extension) {
        try {
            InputStream wavStream = FsProjectStorage.getWav((String)applicationSid, (String)(filename + "." + extension), (WorkspaceStorage)this.workspaceStorage);
            String mediaType = "mp4".equals(extension) ? "video/mp4" : "audio/x-wav";
            return Response.ok((Object)wavStream, (String)mediaType).header("Content-Disposition", (Object)("attachment; filename = " + filename + "." + extension)).build();
        }
        catch (WavItemDoesNotExist e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="{applicationSid}/build")
    public Response buildProject(@PathParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        ProjectDao projectDao = this.buildProjectDao(applicationSid, this.workspaceStorage);
        this.assertProjectStateAvailable(applicationSid, projectDao);
        BuildService buildService = new BuildService(this.workspaceStorage);
        try {
            buildService.buildProject(applicationSid, this.activeProject);
            return Response.ok().build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="{applicationSid}/settings")
    public Response saveProjectSettings(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        this.logging.appendApplicationSid(applicationSid);
        try {
            String data = IOUtils.toString((InputStream)this.request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            ProjectSettings projectSettings = (ProjectSettings)this.marshaler.toModel(data, ProjectSettings.class);
            FsProjectDao projectDao = new FsProjectDao(applicationSid, this.workspaceStorage);
            projectDao.storeSettings(projectSettings);
            if (RvdLoggers.local.isDebugEnabled()) {
                RvdLoggers.local.log((Priority)Level.DEBUG, (Object)(this.logging.getPrefix() + " saved settings for project " + applicationSid));
            }
            return Response.ok().build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (IOException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/settings")
    public Response getProjectSettings(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            ProjectDao dao = this.buildProjectDao(applicationSid, this.workspaceStorage);
            ProjectSettings projectSettings = dao.loadSettings();
            if (projectSettings == null) {
                return Response.ok((Object)this.marshaler.toData(new Object())).build();
            }
            return Response.ok((Object)this.marshaler.toData((Object)projectSettings)).build();
        }
        catch (StorageEntityNotFound e) {
            return Response.ok().build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private ProjectDao buildProjectDao(String applicationName, WorkspaceStorage storage) {
        FsProjectDao dao = new FsProjectDao(applicationName, storage);
        return dao;
    }
}

