/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.ProjectAwareRvdContext;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.exceptions.AccessApiException;
import org.restcomm.connect.rvd.exceptions.ESRequestException;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.ResponseWrapperException;
import org.restcomm.connect.rvd.exceptions.callcontrol.CallControlBadRequestException;
import org.restcomm.connect.rvd.exceptions.callcontrol.CallControlException;
import org.restcomm.connect.rvd.exceptions.callcontrol.CallControlInvalidConfigurationException;
import org.restcomm.connect.rvd.exceptions.callcontrol.UnauthorizedCallControlAccess;
import org.restcomm.connect.rvd.exceptions.callcontrol.WebTriggerNotApplicable;
import org.restcomm.connect.rvd.exceptions.callcontrol.WebTriggerNotAvailable;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.AccountProvider;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.exceptions.BadExternalServiceResponse;
import org.restcomm.connect.rvd.interpreter.exceptions.ESProcessFailed;
import org.restcomm.connect.rvd.interpreter.exceptions.RemoteServiceError;
import org.restcomm.connect.rvd.interpreter.serialization.RcmlSerializer;
import org.restcomm.connect.rvd.logging.CustomLogger;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.CallControlInfo;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.UserProfile;
import org.restcomm.connect.rvd.model.callcontrol.CallControlAction;
import org.restcomm.connect.rvd.model.callcontrol.CallControlStatus;
import org.restcomm.connect.rvd.model.project.StateHeader;
import org.restcomm.connect.rvd.model.rcml.RcmlResponse;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfo;
import org.restcomm.connect.rvd.restcomm.RestcommCall;
import org.restcomm.connect.rvd.restcomm.RestcommCallArray;
import org.restcomm.connect.rvd.restcomm.RestcommClient;
import org.restcomm.connect.rvd.stats.AggregateStats;
import org.restcomm.connect.rvd.stats.StatsHelper;
import org.restcomm.connect.rvd.storage.FsCallControlInfoStorage;
import org.restcomm.connect.rvd.storage.FsProfileDao;
import org.restcomm.connect.rvd.storage.FsProjectDao;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.ProjectDao;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.storage.exceptions.WavItemDoesNotExist;
import org.restcomm.connect.rvd.utils.RvdUtils;

@Path(value="apps")
public class RvdController
extends SecuredRestService {
    LoggingContext logging;
    Pattern appIdPattern = Pattern.compile("^apps\\/([a-zA-Z0-9]+)(\\/|$)");
    private ProjectAwareRvdContext rvdContext;
    private WorkspaceStorage workspaceStorage;
    private ModelMarshaler marshaler;
    private ProjectDao projectDao;
    @Context
    UriInfo uriInfo;
    String applicationId;

    @PostConstruct
    public void init() {
        super.init();
        this.applicationId = this.extractAppIdFromPath(this.uriInfo.getPath());
        if (this.applicationId == null) {
            throw new ResponseWrapperException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        try {
            this.logging = new LoggingContext();
            this.logging.appendApplicationSid(this.applicationId);
            this.marshaler = new ModelMarshaler();
            WorkspaceStorage workspaceStorage = new WorkspaceStorage(this.applicationContext.getConfiguration().getWorkspaceBasePath(), this.marshaler);
            this.projectDao = new FsProjectDao(this.applicationId, workspaceStorage);
            this.rvdContext = new ProjectAwareRvdContext(this.applicationId, this.applicationContext.getProjectRegistry().getResidentProjectInfo(this.applicationId), this.request, this.servletContext, this.applicationContext.getConfiguration(), this.logging, this.projectDao);
        }
        catch (ProjectDoesNotExist projectDoesNotExist) {
            throw new ResponseWrapperException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        this.marshaler = this.rvdContext.getMarshaler();
        this.workspaceStorage = this.rvdContext.getWorkspaceStorage();
    }

    public RvdController() {
    }

    RvdController(UserIdentityContext context) {
        super(context);
    }

    private Response runInterpreter(String appname, HttpServletRequest httpRequest, MultivaluedMap<String, String> requestParams) {
        String rcmlResponse;
        RcmlSerializer serializer = new RcmlSerializer();
        try {
            FsProjectDao projectDao = new FsProjectDao(appname, this.workspaceStorage);
            Interpreter interpreter = new Interpreter(appname, httpRequest, requestParams, this.applicationContext, this.logging, (CustomLogger)this.rvdContext.getProjectLogger(), this.rvdContext.getProjectSettings(), this.rvdContext.getProjectOptions(), (ProjectDao)projectDao);
            RcmlResponse steplist = interpreter.interpret();
            rcmlResponse = serializer.serialize(steplist);
            ProjectSettings projectSettings = this.rvdContext.getProjectSettings();
            if (projectSettings.getLogging().booleanValue() && projectSettings.getLoggingRCML() != null && projectSettings.getLoggingRCML().booleanValue()) {
                interpreter.getProjectLogger().log().tag("RCML").messageNoMarshalling((Object)rcmlResponse).done();
            }
        }
        catch (ESRequestException | BadExternalServiceResponse | ESProcessFailed | RemoteServiceError e) {
            RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"runInterpreter", (String)"{0}{1}{2}", (Object[])new Object[]{this.logging.getPrefix(), "[app-error] ", e.getMessage()}));
            if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
                this.rvdContext.getProjectLogger().log().tag("EXCEPTION").message((Object)e.getMessage()).done();
            }
            rcmlResponse = serializer.serialize(Interpreter.rcmlOnException());
        }
        catch (Exception e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
                this.rvdContext.getProjectLogger().log().tag("EXCEPTION").message((Object)e.getMessage()).done();
            }
            rcmlResponse = serializer.serialize(Interpreter.rcmlOnException());
        }
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"runInterpreter", (String)(this.logging.getPrefix() + "[RCML]"), (String)rcmlResponse));
        }
        return Response.ok((Object)rcmlResponse, (String)"application/xml").build();
    }

    @GET
    @Path(value="{appname}/controller")
    @Produces(value={"application/xml"})
    public Response controllerGet(@Context HttpServletRequest httpRequest, @Context UriInfo ui) {
        this.logging.appendCallSid((String)ui.getQueryParameters().getFirst((Object)"CallSid"));
        if (RvdLoggers.global.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.global.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"controllerGet", (String)this.logging.getPrefix(), (String)"incoming GET request"));
        }
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"controllerGet", (String)"{0}request details: {1}", (Object[])new Object[]{this.logging.getPrefix(), ui.getRequestUri().toString()}));
        }
        AggregateStats projectStats = this.applicationContext.getProjectRegistry().getResidentProjectInfo((String)this.applicationId).stats;
        StatsHelper.countRcmlRequestIncoming((AggregateStats)projectStats);
        AggregateStats globalStats = this.applicationContext.getGlobalStats();
        StatsHelper.countRcmlRequestIncoming((AggregateStats)globalStats);
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String string = (String)headerNames.nextElement();
        }
        MultivaluedMap requestParams = ui.getQueryParameters();
        return this.runInterpreter(this.applicationId, httpRequest, requestParams);
    }

    @POST
    @Path(value="{appname}/controller")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml"})
    public Response controllerPost(@Context HttpServletRequest httpRequest, MultivaluedMap<String, String> requestParams, @Context UriInfo ui) {
        this.logging.appendCallSid((String)requestParams.getFirst((Object)"CallSid"));
        if (RvdLoggers.global.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.global.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"controllerPost", (String)this.logging.getPrefix(), (String)"incoming POST request"));
        }
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"controllerPost", (String)"{0}POST request: {1} form: {2}", (Object[])new Object[]{this.logging.getPrefix(), ui.getRequestUri().toString(), requestParams.toString()}));
        }
        AggregateStats projectStats = this.applicationContext.getProjectRegistry().getResidentProjectInfo((String)this.applicationId).stats;
        StatsHelper.countRcmlRequestIncoming((AggregateStats)projectStats);
        AggregateStats globalStats = this.applicationContext.getGlobalStats();
        StatsHelper.countRcmlRequestIncoming((AggregateStats)globalStats);
        return this.runInterpreter(this.applicationId, httpRequest, requestParams);
    }

    @GET
    @Path(value="{appname}/resources/{filename}")
    public Response getWav(@PathParam(value="filename") String filename) {
        try {
            InputStream wavStream = FsProjectStorage.getWav((String)this.applicationId, (String)filename, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)wavStream, (String)"audio/x-wav").header("Content-Disposition", (Object)("attachment; filename = " + filename)).build();
        }
        catch (WavItemDoesNotExist e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            RvdLoggers.local.log((Priority)Level.ERROR, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"getWav", (String)this.logging.getPrefix(), (String)e.getMessage()), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private RestcommCallArray executeAction(String projectName, HttpServletRequest request, String toParam, String fromParam, String accessToken, UriInfo ui, AccountProvider accountProvider) throws StorageException, CallControlException {
        URIBuilder uriBuilder;
        String rcmlUrl;
        RestcommClient restcommClient;
        CallControlInfo info;
        this.logging.appendPrefix("[WT] ");
        if (RvdLoggers.global.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.global.log((Priority)Level.INFO, (Object)(this.logging.getPrefix() + "incoming triggering request " + ui.getRequestUri().toString()));
        }
        if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
            this.rvdContext.getProjectLogger().log().tag("WebTrigger").messageNoMarshalling((Object)("WebTrigger incoming request: " + ui.getRequestUri().toString())).done();
        }
        String rawState = this.projectDao.loadProjectStateRaw();
        StateHeader projectHeader = ProjectService.parseHeader((String)projectName, (String)rawState);
        try {
            info = FsCallControlInfoStorage.loadInfo((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        }
        catch (StorageEntityNotFound e) {
            if (!"voice".equals(projectHeader.getProjectKind())) {
                throw new WebTriggerNotApplicable("WebTrigger not applicable to this kind of project: " + projectHeader.getProjectKind(), (Throwable)e);
            }
            throw new WebTriggerNotAvailable("WebTrigger not available for this project", (Throwable)e);
        }
        String owner = projectHeader.getOwner();
        if (RvdUtils.isEmpty((String)owner)) {
            throw new CallControlException("Project '" + projectName + "' has no owner and can't be started using WebTrigger.");
        }
        String effectiveAuthHeader = null;
        String accountSid = null;
        if (!RvdUtils.isEmpty((String)info.accessToken) && !RvdUtils.isEmpty((String)accessToken)) {
            if (!info.accessToken.equals(accessToken)) {
                throw new UnauthorizedCallControlAccess("WebTrigger authorization error");
            }
            FsProfileDao profileDao = new FsProfileDao(this.workspaceStorage);
            UserProfile profile = profileDao.loadUserProfile(owner);
            if (profile == null || RvdUtils.isEmpty((String)profile.getUsername()) || RvdUtils.isEmpty((String)profile.getToken())) {
                throw new UnauthorizedCallControlAccess("Profile missing creds or no profile at all for user '" + owner + "'. Web trigger cannot be used for project belonging to this user.");
            }
            effectiveAuthHeader = RvdUtils.isEmpty((String)profile.getUsername()) ? null : "Basic " + RvdUtils.buildHttpAuthorizationToken((String)profile.getUsername(), (String)profile.getToken());
            RestcommAccountInfo accountInfo = accountProvider.getActiveAccount(profile.getUsername(), effectiveAuthHeader);
            if (accountInfo == null) {
                throw new UnauthorizedCallControlAccess("WebTrigger authorization error");
            }
            accountSid = accountInfo.getSid();
        }
        if (effectiveAuthHeader == null && this.getUserIdentityContext().getAccountInfo() != null) {
            effectiveAuthHeader = this.getUserIdentityContext().getEffectiveAuthorizationHeader();
            accountSid = this.getUserIdentityContext().getAccountInfo().getSid();
        }
        if (effectiveAuthHeader == null) {
            throw new UnauthorizedCallControlAccess("WebTrigger authorization error");
        }
        try {
            restcommClient = new RestcommClient(this.restcommBaseUrl, effectiveAuthHeader, this.applicationContext.getDefaultHttpClient());
        }
        catch (RestcommClient.RestcommClientInitializationException e) {
            throw new CallControlException("WebTrigger", (Throwable)e);
        }
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeAction", (String)this.logging.getPrefix(), (String)("reaching restcomm at '" + this.restcommBaseUrl + "'")));
        }
        if (RvdUtils.isEmpty((String)(rcmlUrl = ((CallControlInfo.Lane)info.lanes.get((int)0)).startPoint.rcmlUrl))) {
            uriBuilder = new URIBuilder(this.restcommBaseUrl);
            uriBuilder.setPath("/restcomm-rvd/services/apps/" + projectName + "/controller");
            try {
                rcmlUrl = uriBuilder.build().toString();
            }
            catch (URISyntaxException e) {
                throw new CallControlException("URI parsing error while generating the rcml url", (Throwable)e);
            }
        }
        try {
            uriBuilder = new URIBuilder(rcmlUrl);
            MultivaluedMap requestParams = ui.getQueryParameters();
            for (String paramName : requestParams.keySet()) {
                if ("token".equals(paramName) || "from".equals(paramName) || "to".equals(paramName) || RvdConfiguration.builtinRestcommParameters.contains(paramName)) continue;
                if (RvdUtils.isEmpty((String)info.userParamScope) || "mod".equals(info.userParamScope)) {
                    uriBuilder.addParameter(Interpreter.nameModuleRequestParam((String)paramName), (String)requestParams.getFirst((Object)paramName));
                    continue;
                }
                if ("app".equals(info.userParamScope)) {
                    uriBuilder.addParameter(Interpreter.nameStickyRequestParam((String)paramName), (String)requestParams.getFirst((Object)paramName));
                    continue;
                }
                throw new UnsupportedOperationException("WebTrigger userParamScope not supported: " + info.userParamScope);
            }
            rcmlUrl = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new CallControlException("Error copying user supplied parameters to rcml url", (Throwable)e);
        }
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeAction", (String)(this.logging.getPrefix() + "rcmlUrl: " + rcmlUrl)));
        }
        String to = toParam;
        String toOverride = ((CallControlInfo.Lane)info.lanes.get((int)0)).startPoint.to;
        if (!RvdUtils.isEmpty((String)toOverride)) {
            to = toOverride;
        }
        String from = fromParam;
        String fromOverride = ((CallControlInfo.Lane)info.lanes.get((int)0)).startPoint.from;
        if (!RvdUtils.isEmpty((String)fromOverride)) {
            from = fromOverride;
        }
        if (RvdUtils.isEmpty((String)from) && !RvdUtils.isEmpty((String)projectName)) {
            from = projectName.substring(0, projectName.length() < 10 ? projectName.length() : 10);
        }
        if (RvdUtils.isEmpty((String)rcmlUrl)) {
            throw new CallControlInvalidConfigurationException("Could not determine application RCML url.");
        }
        if (RvdUtils.isEmpty((String)from) || RvdUtils.isEmpty((String)to)) {
            throw new CallControlBadRequestException("Either <i>from</i> or <i>to</i> value is missing. Make sure they are both passed as query parameters or are defined in the Web Trigger configuration.").setStatusCode(Integer.valueOf(400));
        }
        try {
            if (RvdUtils.isEmpty((String)accountSid)) {
                RestcommAccountInfo accountResponse = (RestcommAccountInfo)restcommClient.get("/restcomm/2012-04-24/Accounts.json/" + this.getLoggedUsername()).done(this.marshaler.getGson(), RestcommAccountInfo.class);
                accountSid = accountResponse.getSid();
            }
            RestcommCallArray response = (RestcommCallArray)restcommClient.post("/restcomm/2012-04-24/Accounts/" + accountSid + "/Calls.json").addParam("From", from).addParam("To", to).addParam("Url", rcmlUrl).done(this.marshaler.getGson(), RestcommCallArray.class);
            if (RvdLoggers.local.isDebugEnabled()) {
                RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeAction", (String)(this.logging.getPrefix() + "joined '" + to + "' with " + rcmlUrl)));
            }
            return response;
        }
        catch (AccessApiException e) {
            throw new CallControlException(e.getMessage(), (Throwable)e).setStatusCode(e.getStatusCode());
        }
    }

    @GET
    @Path(value="{appname}/start{extension: (.html)?}")
    @Produces(value={"text/html"})
    public Response executeActionHtml(@Context HttpServletRequest request, @QueryParam(value="to") String toParam, @QueryParam(value="from") String fromParam, @QueryParam(value="token") String accessToken, @Context UriInfo ui) {
        String selectedMediaType = "text/html";
        try {
            RestcommCallArray calls = this.executeAction(this.applicationId, request, toParam, fromParam, accessToken, ui, this.accountProvider);
            StringBuffer messageBuffer = new StringBuffer("[");
            for (int i = 0; i < calls.size(); ++i) {
                messageBuffer.append(((RestcommCall)calls.get(i)).getSid());
                if (i >= calls.size() - 1) continue;
                messageBuffer.append(",");
            }
            messageBuffer.append("]");
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "success", "Created call with SID " + messageBuffer.toString() + " from " + ((RestcommCall)calls.get(0)).getFrom() + " to " + ((RestcommCall)calls.get(0)).getTo(), Integer.valueOf(200));
        }
        catch (UnauthorizedCallControlAccess e) {
            if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeActionHtml", (String)this.logging.getPrefix(), (String)e.getMessage()));
            }
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "failure", "Authentication error", Integer.valueOf(401));
        }
        catch (WebTriggerNotApplicable | WebTriggerNotAvailable e) {
            RvdLoggers.global.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeActionHtml", (String)this.logging.getPrefix(), (String)e.getMessage()));
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "failure", e.getMessage(), Integer.valueOf(404));
        }
        catch (CallControlException e) {
            RvdLoggers.global.log((Priority)Level.WARN, (Object)(this.logging.getPrefix() + e.getMessage()));
            int httpStatus = 500;
            if (e.getStatusCode() != null) {
                httpStatus = e.getStatusCode();
            }
            return this.buildWebTriggerHtmlResponse("Web Trigger", "Create call", "failure", "", Integer.valueOf(httpStatus));
        }
        catch (StorageException e) {
            RvdLoggers.global.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(selectedMediaType).build();
        }
    }

    @GET
    @Path(value="{appname}/start.json")
    @Produces(value={"application/json"})
    public Response executeActionJson(@Context HttpServletRequest request, @QueryParam(value="to") String toParam, @QueryParam(value="from") String fromParam, @QueryParam(value="token") String accessToken, @Context UriInfo ui) {
        String selectedMediaType = "application/json";
        try {
            RestcommCallArray calls = this.executeAction(this.applicationId, request, toParam, fromParam, accessToken, ui, this.accountProvider);
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.success, Integer.valueOf(200), (Object)calls);
        }
        catch (UnauthorizedCallControlAccess e) {
            if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeActionJson", (String)this.logging.getPrefix(), (String)e.getMessage()));
            }
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.failure, Integer.valueOf(401), null);
        }
        catch (WebTriggerNotApplicable | WebTriggerNotAvailable e) {
            RvdLoggers.global.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"executeActionHtml", (String)this.logging.getPrefix(), (String)e.getMessage()));
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.failure, Integer.valueOf(404), (Object)e.getMessage());
        }
        catch (CallControlException e) {
            RvdLoggers.global.log((Priority)Level.WARN, (Object)(this.logging.getPrefix() + e.getMessage()));
            int httpStatus = 500;
            if (e.getStatusCode() != null) {
                httpStatus = e.getStatusCode();
            }
            return this.buildWebTriggerJsonResponse(CallControlAction.createCall, CallControlStatus.failure, Integer.valueOf(httpStatus), null);
        }
        catch (StorageException e) {
            RvdLoggers.global.log((Priority)Level.ERROR, (Object)this.logging.getPrefix(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(selectedMediaType).build();
        }
    }

    @GET
    @Path(value="{appname}/log")
    public Response appLog() {
        this.secure();
        this.logging.appendAccountSid(this.getUserIdentityContext().getAccountSid());
        ProjectSettings projectSettings = this.rvdContext.getProjectSettings();
        if (projectSettings == null || !projectSettings.getLogging().booleanValue()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            FileInputStream logStream = new FileInputStream(this.rvdContext.getProjectLogger().getLogFilePath());
            return Response.ok((Object)logStream, (String)"text/plain").header("Cache-Control", (Object)"no-cache, no-store, must-revalidate").header("Pragma", (Object)"no-cache").build();
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @Path(value="{appname}/log")
    public Response resetAppLog() {
        this.secure();
        this.logging.appendAccountSid(this.getUserIdentityContext().getAccountSid());
        ProjectSettings projectSettings = this.rvdContext.getProjectSettings();
        if (projectSettings == null || !projectSettings.getLogging().booleanValue()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.rvdContext.getProjectLogger().reset();
        if (RvdLoggers.local.isDebugEnabled()) {
            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"resetAppLog", (String)this.logging.getPrefix(), (String)"application log was reset"));
        }
        return Response.ok().build();
    }

    String extractAppIdFromPath(String path) {
        String uri_string = path.toString();
        Matcher matcher = this.appIdPattern.matcher(uri_string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

