/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import org.restcomm.connect.rvd.ApplicationContext;
import org.restcomm.connect.rvd.exceptions.AuthorizationException;
import org.restcomm.connect.rvd.http.RestService;
import org.restcomm.connect.rvd.identity.AccountProvider;
import org.restcomm.connect.rvd.identity.DefaultAccountProvider;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfo;

public class SecuredRestService
extends RestService {
    private UserIdentityContext userIdentityContext;
    protected AccountProvider accountProvider;

    public void init() {
        super.init();
        this.accountProvider = new DefaultAccountProvider(this.restcommBaseUrl, this.applicationContext.getDefaultHttpClient());
        String authorizationHeader = this.request.getHeader("Authorization");
        this.userIdentityContext = new UserIdentityContext(authorizationHeader, this.accountProvider);
    }

    public SecuredRestService() {
    }

    SecuredRestService(UserIdentityContext context) {
        this.userIdentityContext = context;
    }

    public SecuredRestService(ApplicationContext applicationContext, UserIdentityContext userIdentityContext) {
        super(applicationContext);
        this.userIdentityContext = userIdentityContext;
    }

    public UserIdentityContext getUserIdentityContext() {
        return this.userIdentityContext;
    }

    protected void secure() {
        RestcommAccountInfo account = this.userIdentityContext.getAccountInfo();
        if (account != null && "active".equals(account.getStatus())) {
            return;
        }
        throw new AuthorizationException();
    }

    protected String getLoggedUsername() {
        return this.userIdentityContext.getAccountUsername();
    }
}

