/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.concurrency.ProjectRegistry;
import org.restcomm.connect.rvd.concurrency.ResidentProjectInfo;
import org.restcomm.connect.rvd.exceptions.AuthorizationException;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.project.StateHeader;
import org.restcomm.connect.rvd.model.stats.AppStatsDto;
import org.restcomm.connect.rvd.stats.AggregateStats;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

@Path(value="stats")
public class StatsRestService
extends SecuredRestService {
    RvdConfiguration config;
    WorkspaceStorage workspace;

    @PostConstruct
    public void init() {
        super.init();
        this.config = this.applicationContext.getConfiguration();
        this.workspace = new WorkspaceStorage(this.config.getWorkspaceBasePath(), null);
    }

    protected void secure() {
        super.secure();
    }

    @GET
    @Path(value="app/{appId}")
    public Response getApplicationStatsTotal(@PathParam(value="appId") String appId) throws StorageException, ProjectDoesNotExist {
        this.checkApplicationAccess(appId);
        ProjectRegistry registry = this.applicationContext.getProjectRegistry();
        ResidentProjectInfo projectInfo = registry.getResidentProjectInfo(appId);
        AppStatsDto dto = new AppStatsDto();
        dto.setInstanceId(this.config.getRvdInstanceId());
        dto.setRcmlRequestsTotal(Integer.valueOf(projectInfo.stats.rcmlRequestsTotal.get()));
        dto.setStartTime(Long.valueOf(projectInfo.stats.startTime.get()));
        dto.setEsCallsPending(Integer.valueOf(projectInfo.stats.esCallsPending.get()));
        dto.setEsCallsServerError(Integer.valueOf(projectInfo.stats.esCallsServerError.get()));
        dto.setEsCallsTimeout(Integer.valueOf(projectInfo.stats.esCallsTimeout.get()));
        dto.setEsCallsSuccess(Integer.valueOf(projectInfo.stats.esCallsSuccess.get()));
        dto.setEsCallsTotal(Integer.valueOf(projectInfo.stats.esCallsTotal.get()));
        Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").create();
        String data = gson.toJson((Object)dto);
        return Response.ok((Object)data, (String)"application/json").build();
    }

    @DELETE
    @Path(value="app/{appId}")
    public Response resetApplicationStats(@PathParam(value="appId") String appId) throws StorageException, ProjectDoesNotExist {
        this.checkApplicationAccess(appId);
        ResidentProjectInfo projectInfo = this.applicationContext.getProjectRegistry().getResidentProjectInfo(appId);
        projectInfo.setStats(new AggregateStats());
        RvdLoggers.local.log((Priority)Level.INFO, (Object)"Application stats were reset");
        return Response.noContent().build();
    }

    @GET
    @Path(value="global")
    public Response getGlobalStatsTotal() {
        this.checkGlobalAccess();
        AggregateStats stats = this.applicationContext.getGlobalStats();
        AppStatsDto dto = new AppStatsDto();
        dto.setInstanceId(this.config.getRvdInstanceId());
        dto.setRcmlRequestsTotal(Integer.valueOf(stats.rcmlRequestsTotal.get()));
        dto.setStartTime(Long.valueOf(stats.startTime.get()));
        dto.setEsCallsPending(Integer.valueOf(stats.esCallsPending.get()));
        dto.setEsCallsServerError(Integer.valueOf(stats.esCallsServerError.get()));
        dto.setEsCallsTimeout(Integer.valueOf(stats.esCallsTimeout.get()));
        dto.setEsCallsSuccess(Integer.valueOf(stats.esCallsSuccess.get()));
        dto.setEsCallsTotal(Integer.valueOf(stats.esCallsTotal.get()));
        Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").create();
        String data = gson.toJson((Object)dto);
        return Response.ok((Object)data, (String)"application/json").build();
    }

    @DELETE
    @Path(value="global")
    public Response resetGlobalStats() {
        this.checkGlobalAccess();
        this.applicationContext.setGlobalStats(new AggregateStats());
        RvdLoggers.local.log((Priority)Level.INFO, (Object)"Global stats were reset");
        return Response.noContent().build();
    }

    void checkApplicationAccess(String appId) throws ProjectDoesNotExist, StorageException {
        this.secure();
        WorkspaceStorage workspace = new WorkspaceStorage(this.config.getWorkspaceBasePath(), null);
        if (!FsProjectStorage.projectExists((String)appId, (WorkspaceStorage)workspace)) {
            throw new ProjectDoesNotExist(appId);
        }
        StateHeader projectHeader = FsProjectStorage.loadStateHeader((String)appId, (WorkspaceStorage)workspace);
        String owner = projectHeader.getOwner();
        String clientEmail = this.getUserIdentityContext().getAccountInfo().getEmail_address();
        String clientRole = this.getUserIdentityContext().getAccountInfo().getRole();
        if (!("Administrator".equals(clientRole) || clientEmail != null && clientEmail.equals(owner))) {
            throw new AuthorizationException();
        }
    }

    void checkGlobalAccess() {
        this.secure();
        String clientRole = this.getUserIdentityContext().getAccountInfo().getRole();
        if (!"Administrator".equals(clientRole)) {
            throw new AuthorizationException();
        }
    }
}

