/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.identity;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.restcomm.connect.rvd.identity.AccountProvider;
import org.restcomm.connect.rvd.identity.BasicAuthCredentials;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfo;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class DefaultAccountProvider
implements AccountProvider {
    URI restcommUrl = null;
    CloseableHttpClient client;

    public DefaultAccountProvider(URI restcommUrl, CloseableHttpClient client) {
        if (restcommUrl == null) {
            throw new IllegalStateException("restcommUrl cannot be null");
        }
        this.restcommUrl = restcommUrl;
        this.client = client;
    }

    private URI buildAccountQueryUrl(String usernameOrSid) {
        try {
            URI uri = new URIBuilder(this.restcommUrl.toString()).setPath("/restcomm/2012-04-24/Accounts.json/" + usernameOrSid).build();
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public RestcommAccountInfo getAccount(String accountName, String authorizationHeader) {
        block4: {
            HttpGet GETRequest = new HttpGet(this.buildAccountQueryUrl(accountName));
            GETRequest.addHeader("Authorization", authorizationHeader);
            try {
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)GETRequest);
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String accountJson = EntityUtils.toString((HttpEntity)entity);
                        Gson gson = new Gson();
                        RestcommAccountInfo accountResponse = (RestcommAccountInfo)gson.fromJson(accountJson, RestcommAccountInfo.class);
                        return accountResponse;
                    }
                    break block4;
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public RestcommAccountInfo getActiveAccount(String accountName, String authorizationHeader) {
        RestcommAccountInfo response = this.getAccount(accountName, authorizationHeader);
        if (!"active".equals(response.getStatus())) {
            return null;
        }
        return response;
    }

    public RestcommAccountInfo getActiveAccount(BasicAuthCredentials creds) {
        String header = "Basic " + RvdUtils.buildHttpAuthorizationToken((String)creds.getUsername(), (String)creds.getPassword());
        return this.getActiveAccount(creds.getUsername(), header);
    }
}

