/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.interpreter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.ApplicationContext;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.UndefinedTarget;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.Target;
import org.restcomm.connect.rvd.interpreter.exceptions.BadExternalServiceResponse;
import org.restcomm.connect.rvd.interpreter.exceptions.InvalidAccessOperationAction;
import org.restcomm.connect.rvd.logging.CustomLogger;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.StepJsonDeserializer;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.rcml.RcmlResponse;
import org.restcomm.connect.rvd.model.rcml.RcmlStep;
import org.restcomm.connect.rvd.model.server.NodeName;
import org.restcomm.connect.rvd.model.server.ProjectOptions;
import org.restcomm.connect.rvd.model.steps.es.AccessOperation;
import org.restcomm.connect.rvd.model.steps.es.ExternalServiceStep;
import org.restcomm.connect.rvd.model.steps.es.ValueExtractor;
import org.restcomm.connect.rvd.model.steps.hangup.RcmlHungupStep;
import org.restcomm.connect.rvd.storage.ProjectDao;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Interpreter {
    private ApplicationContext applicationContext;
    private HttpServletRequest httpRequest;
    private CustomLogger projectLogger;
    private LoggingContext loggingContext;
    private ProjectSettings projectSettings;
    private ProjectOptions projectOptions;
    private ProjectDao projectDao;
    private Gson gson;
    private String targetParam;
    private Target target;
    private String appName;
    MultivaluedMap<String, String> requestParams;
    private String contextPath;
    private Map<String, String> variables = new HashMap();
    private List<NodeName> nodeNames;
    private RcmlResponse rcmlResult;

    public static RcmlResponse rcmlOnException() {
        RcmlResponse response = new RcmlResponse();
        response.steps.add(new RcmlHungupStep());
        return response;
    }

    public Interpreter(String appName, HttpServletRequest httpRequest, MultivaluedMap<String, String> requestParams, ApplicationContext applicationContext, LoggingContext loggingContext, CustomLogger projectLogger, ProjectSettings projectSettings, ProjectOptions projectOptions, ProjectDao projectDao) throws StorageException {
        this.httpRequest = httpRequest;
        this.targetParam = (String)requestParams.getFirst((Object)"target");
        this.appName = appName;
        this.requestParams = requestParams;
        this.projectLogger = projectLogger;
        this.applicationContext = applicationContext;
        this.loggingContext = loggingContext;
        this.projectSettings = projectSettings;
        this.projectOptions = projectOptions;
        this.projectDao = projectDao;
        this.contextPath = httpRequest.getContextPath();
        this.init();
    }

    private void init() throws StorageException {
        this.gson = new GsonBuilder().registerTypeAdapter(Step.class, (Object)new StepJsonDeserializer()).create();
        this.processBootstrapParameters();
        this.processRequestParameters();
    }

    public CustomLogger getProjectLogger() {
        return this.projectLogger;
    }

    public LoggingContext getLoggingContext() {
        return this.loggingContext;
    }

    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    public RvdConfiguration getConfiguration() {
        return this.applicationContext.getConfiguration();
    }

    public String getAppName() {
        return this.appName;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    ProjectDao getProjectDao() {
        return this.projectDao;
    }

    void setProjectDao(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    public RcmlResponse interpret() throws RvdException {
        this.nodeNames = this.projectOptions.getNodeNames();
        if (this.targetParam == null || "".equals(this.targetParam)) {
            this.targetParam = this.projectOptions.getDefaultTarget();
            if (this.targetParam == null) {
                throw new UndefinedTarget();
            }
            if (RvdLoggers.local.isTraceEnabled()) {
                RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"interpret", (String)this.loggingContext.getPrefix(), (String)("override default target to " + this.targetParam)));
            }
        }
        this.dispatch(this.targetParam);
        return this.rcmlResult;
    }

    public MultivaluedMap<String, String> getRequestParams() {
        return this.requestParams;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void dispatch(String targetParam) throws StorageException, InterpreterException {
        if (RvdLoggers.local.isTraceEnabled()) {
            RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"interpret", (String)this.loggingContext.getPrefix(), (String)("starting interpeter for " + targetParam)));
        }
        if (this.projectSettings.getLogging().booleanValue()) {
            this.projectLogger.log().message((Object)("Running target: " + targetParam)).done();
        }
        this.target = Interpreter.parseTarget((String)targetParam);
        Node targetModule = this.loadNode(this.target.getNodename());
        if (this.target.action != null) {
            targetModule.getStepByName(this.target.stepname).handleAction(this, targetModule);
        } else {
            this.interpret(targetModule, null, null, null);
        }
    }

    public void interpret(Node module, String startingStepName, Step prependStep, Node originModule) throws StorageException, InterpreterException {
        String moduleName = null;
        if (module != null) {
            moduleName = module.getName();
        }
        if (this.rcmlResult == null) {
            this.rcmlResult = new RcmlResponse();
        }
        if (originModule != null && !originModule.getName().equals(moduleName)) {
            this.clearModuleVariables();
        }
        List nodeStepnames = module.getStepNames();
        if (startingStepName == null && !nodeStepnames.isEmpty()) {
            startingStepName = (String)nodeStepnames.get(0);
        }
        if (prependStep != null) {
            RcmlStep rcmlStep = prependStep.render(this, moduleName);
            if (RvdLoggers.local.isTraceEnabled()) {
                RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"interpret", (String)("Prepending say step: " + rcmlStep)));
            }
            this.rcmlResult.steps.add(rcmlStep);
        }
        boolean startstep_found = false;
        for (String stepname : nodeStepnames) {
            if (stepname.equals(startingStepName)) {
                startstep_found = true;
            }
            if (!startstep_found) continue;
            Step step = module.getStepByName(stepname);
            String rerouteTo = step.process(this, this.httpRequest);
            if (rerouteTo != null) {
                Node reroutedModule = this.loadNode(rerouteTo);
                this.interpret(reroutedModule, null, null, module);
                return;
            }
            RcmlStep rcmlStep = step.render(this, moduleName);
            if (rcmlStep == null) continue;
            this.rcmlResult.steps.add(rcmlStep);
        }
    }

    public void interpret(String moduleName, String startingStepName, Step prependStep, Node originModule) throws StorageException, InterpreterException {
        Node module = this.loadNode(moduleName);
        this.interpret(module, startingStepName, prependStep, originModule);
    }

    Node loadNode(String moduleName) throws StorageException {
        return this.projectDao.loadNode(moduleName);
    }

    public String evaluateExtractorExpression(ValueExtractor extractor, JsonElement response_element) throws InvalidAccessOperationAction, BadExternalServiceResponse {
        String value = "";
        JsonElement element = response_element;
        for (AccessOperation operation : extractor.getAccessOperations()) {
            if (element == null) {
                throw new BadExternalServiceResponse();
            }
            if ("object".equals(operation.getKind())) {
                if (!element.isJsonObject()) {
                    throw new BadExternalServiceResponse("No JSON object found");
                }
                if ("propertyNamed".equals(operation.getAction())) {
                    element = element.getAsJsonObject().get(operation.getProperty());
                    continue;
                }
                throw new InvalidAccessOperationAction();
            }
            if ("array".equals(operation.getKind())) {
                if (!element.isJsonArray()) {
                    throw new BadExternalServiceResponse("No JSON array found");
                }
                if ("itemAtPosition".equals(operation.getAction())) {
                    element = element.getAsJsonArray().get(operation.getPosition().intValue());
                    continue;
                }
                throw new InvalidAccessOperationAction();
            }
            if (!"value".equals(operation.getKind())) continue;
            if (!element.isJsonPrimitive()) {
                throw new BadExternalServiceResponse("No primitive value found (maybe null returned?)");
            }
            value = element.getAsString();
        }
        return value;
    }

    private String processStep(Step step) throws InterpreterException {
        if (step.getClass().equals(ExternalServiceStep.class)) {
            // empty if block
        }
        return null;
    }

    public String populateVariables(String sourceText) {
        if (sourceText == null) {
            return sourceText;
        }
        Pattern pattern = Pattern.compile("\\$([A-Za-z]+[A-Za-z0-9_]*)");
        Matcher matches = pattern.matcher(sourceText);
        int searchStart = 0;
        ArrayList<VariableInText> variablesInText = new ArrayList<VariableInText>();
        while (matches.find(searchStart)) {
            variablesInText.add(new VariableInText(this, matches.group(1), Integer.valueOf(matches.start())));
            searchStart = matches.end();
        }
        StringBuffer buffer = new StringBuffer(sourceText);
        Collections.reverse(variablesInText);
        for (VariableInText v : variablesInText) {
            String replaceValue = "";
            if (this.variables.containsKey(v.variableName)) {
                replaceValue = (String)this.variables.get(v.variableName);
            } else if (this.variables.containsKey("module_" + v.variableName)) {
                replaceValue = (String)this.variables.get("module_" + v.variableName);
            } else if (this.variables.containsKey("sticky_" + v.variableName)) {
                replaceValue = (String)this.variables.get("sticky_" + v.variableName);
            }
            buffer.replace(v.position, v.position + v.variableName.length() + 1, replaceValue == null ? "" : replaceValue);
        }
        return buffer.toString();
    }

    public String buildAction(Map<String, String> pairs) {
        String value;
        String encodedValue;
        String query = "";
        for (String key : pairs.keySet()) {
            query = "".equals(query) ? query + "?" : query + "&";
            encodedValue = "";
            value = pairs.get(key);
            if (value != null) {
                try {
                    encodedValue = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"buildAction", (String)this.loggingContext.getPrefix(), (String)("error encoding RVD variable " + key + ": " + value)), (Throwable)e);
                }
            }
            query = query + key + "=" + encodedValue;
        }
        for (String variableName : this.variables.keySet()) {
            if (!variableName.startsWith("sticky_") && !variableName.startsWith("module_")) continue;
            query = "".equals(query) ? query + "?" : query + "&";
            encodedValue = "";
            value = (String)this.variables.get(variableName);
            if (value != null) {
                try {
                    encodedValue = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"buildAction", (String)this.loggingContext.getPrefix(), (String)("error encoding RVD variable " + variableName + ": " + value)), (Throwable)e);
                }
            }
            query = query + variableName + "=" + encodedValue;
        }
        return "controller" + query;
    }

    public static Target parseTarget(String targetParam) {
        Target target = new Target();
        Pattern pattern = Pattern.compile("^([^.]+)(.([^.]+))?(.([^.]+))?");
        Matcher matcher = pattern.matcher(targetParam);
        if (matcher.find()) {
            if (matcher.groupCount() >= 1) {
                target.setNodename(matcher.group(1));
            }
            if (matcher.groupCount() >= 3) {
                target.setStepname(matcher.group(3));
            }
            if (matcher.groupCount() >= 5) {
                target.setAction(matcher.group(5));
            }
        }
        return target;
    }

    public String getNodeNameByLabel(String label) {
        for (NodeName nodename : this.nodeNames) {
            if (!label.equals(nodename.getLabel())) continue;
            return nodename.getName();
        }
        return null;
    }

    public String moduleUrl(String moduleName) {
        String url = null;
        for (NodeName nodeName : this.nodeNames) {
            if (!nodeName.getName().equals(moduleName)) continue;
            HashMap<String, String> pairs = new HashMap<String, String>();
            pairs.put("target", moduleName);
            url = this.buildAction(pairs);
            break;
        }
        return url;
    }

    public String convertRecordingFileResourceHttp(String fileResource) throws URISyntaxException {
        String httpResource = fileResource;
        URIBuilder fileUriBuilder = new URIBuilder(fileResource);
        if (!fileUriBuilder.isAbsolute()) {
            RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"convertRecordingFileResourceHttp", (String)this.loggingContext.getPrefix(), (String)("cannot convert file URL to http URL - " + fileResource)));
            return "";
        }
        if (fileUriBuilder.getScheme().startsWith("http")) {
            return fileResource;
        }
        if (fileUriBuilder.getScheme().startsWith("file")) {
            String wavFilename = "";
            int filenameBeforeStartPos = fileResource.lastIndexOf(47);
            if (filenameBeforeStartPos != -1) {
                wavFilename = fileResource.substring(filenameBeforeStartPos + 1);
                URIBuilder httpUriBuilder = new URIBuilder().setScheme(this.httpRequest.getScheme()).setHost(this.httpRequest.getLocalAddr()).setPort(this.httpRequest.getServerPort()).setPath("/restcomm/recordings/" + wavFilename);
                httpResource = httpUriBuilder.build().toString();
            }
        }
        return httpResource;
    }

    public void putStickyVariable(String name, String value) {
        this.variables.put("sticky_" + name, value);
    }

    public static String nameStickyRequestParam(String name) {
        return "sticky_" + name;
    }

    public static String nameModuleRequestParam(String name) {
        return "module_" + name;
    }

    public void putModuleVariable(String name, String value) {
        this.variables.put("module_" + name, value);
    }

    public void putVariable(String name, String value) {
        this.variables.put(name, value);
    }

    private void processRequestParameters() {
        for (String anyVariableName : this.getRequestParams().keySet()) {
            String variableValue;
            if (RvdConfiguration.builtinRestcommParameters.contains(anyVariableName)) {
                variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
                this.getVariables().put("core_" + anyVariableName, variableValue);
                continue;
            }
            if (this.isCustomRestcommHttpHeader(anyVariableName)) {
                variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
                this.getVariables().put("core_" + this.normalizeHTTPHeaderName(anyVariableName), variableValue);
                continue;
            }
            if (anyVariableName.startsWith("sticky_") || anyVariableName.startsWith("module_")) {
                variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
                this.getVariables().put(anyVariableName, variableValue);
                continue;
            }
            variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
            this.getVariables().put(anyVariableName, variableValue);
        }
    }

    private boolean isCustomRestcommHttpHeader(String headerName) {
        if (headerName.toLowerCase().startsWith("SipHeader_".toLowerCase())) {
            return true;
        }
        return headerName.toLowerCase().startsWith("DialSipHeader_".toLowerCase());
    }

    private String normalizeHTTPHeaderName(String headerName) {
        if (headerName.toLowerCase().startsWith("SipHeader_".toLowerCase())) {
            String stripedName = headerName.substring("SipHeader_".length()).toLowerCase();
            return this.sanitizeVariableName(stripedName);
        }
        if (headerName.toLowerCase().startsWith("DialSipHeader_".toLowerCase())) {
            String stripedName = headerName.substring("DialSipHeader_".length()).toLowerCase();
            return this.sanitizeVariableName(stripedName);
        }
        return headerName;
    }

    private String sanitizeVariableName(String name) {
        if (name != null) {
            return name.replaceAll("[^A-Za-z0-9_]", "_");
        }
        return null;
    }

    private void processBootstrapParameters() throws StorageException {
        JsonParser parser;
        JsonElement rootElement;
        String data;
        if (this.projectDao != null && (data = this.projectDao.loadBootstrapInfo()) != null && (rootElement = (parser = new JsonParser()).parse(data)).isJsonObject()) {
            JsonObject rootObject = rootElement.getAsJsonObject();
            for (Map.Entry entry : rootObject.entrySet()) {
                String name = (String)entry.getKey();
                JsonElement valueElement = (JsonElement)entry.getValue();
                if (valueElement.isJsonPrimitive() && valueElement.getAsJsonPrimitive().isString()) {
                    String value = valueElement.getAsJsonPrimitive().getAsString();
                    this.getVariables().put(name, value);
                    if (!RvdLoggers.local.isTraceEnabled()) continue;
                    RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"processBootstrapParameters", (String)this.loggingContext.getPrefix(), (String)("loaded bootstrap parameter: " + name + " - " + value)));
                    continue;
                }
                RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"processBootstrapParameters", (String)this.loggingContext.getPrefix(), (String)("warning. Not-string bootstrap value found for parameter: " + name)));
            }
        }
    }

    public void clearModuleVariables() {
        Iterator it = this.variables.keySet().iterator();
        while (it.hasNext()) {
            String variableName = (String)it.next();
            if (!variableName.startsWith("module_")) continue;
            it.remove();
        }
    }
}

