/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.jsonvalidation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restcomm.connect.rvd.jsonvalidation.ValidationErrorItem;

public class ValidationResult {
    private boolean success;
    private List<ValidationErrorItem> errorItems = new ArrayList();

    public ValidationResult(ProcessingReport report) {
        this.success = report.isSuccess();
        Iterator i = report.iterator();
        while (i.hasNext()) {
            JsonNode node = ((ProcessingMessage)i.next()).asJson();
            ValidationErrorItem item = new ValidationErrorItem(node.get("message").asText(), node.get("level").asText(), node.get("instance").get("pointer").asText());
            this.errorItems.add(item);
        }
    }

    public void appendError(ValidationErrorItem error) {
        this.errorItems.add(error);
        if ("error".equals(error.level)) {
            this.success = false;
        }
    }

    public boolean isSuccess() {
        return this.success;
    }
}

