/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.logging;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.concurrency.LogRotationSemaphore;
import org.restcomm.connect.rvd.logging.CustomLogger;
import org.restcomm.connect.rvd.logging.LoggerItem;
import org.restcomm.connect.rvd.logging.LoggerItemImpl;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.ModelMarshaler;

public class CustomLoggerImpl
implements CustomLogger {
    static final Logger logger = RvdLoggers.local;
    protected static final int MAX_TAGS = 5;
    int backlogCount = 3;
    int triggerRotationSize = 300000;
    String logFilenameBase;
    File mainLogFile;
    LogRotationSemaphore semaphore;
    ModelMarshaler marshaler;

    protected CustomLoggerImpl(String logFilenameBase, LogRotationSemaphore semaphore) {
        this.logFilenameBase = logFilenameBase;
        this.mainLogFile = new File(logFilenameBase + ".log");
        this.semaphore = semaphore;
    }

    protected CustomLoggerImpl(String logFilenameBase, int maxSize, int backlogCount, LogRotationSemaphore semaphore) {
        this(logFilenameBase, semaphore);
        if (maxSize <= 0 || backlogCount <= 0) {
            throw new IllegalArgumentException("Cannot initialize CustomLogger");
        }
        this.triggerRotationSize = maxSize;
        this.backlogCount = backlogCount;
    }

    public LoggerItem log() {
        return new LoggerItemImpl(this);
    }

    void done(LoggerItem item) {
        item.getBuffer().append(System.getProperty("line.separator"));
        try {
            FileUtils.writeStringToFile((File)this.mainLogFile, (String)item.getBuffer().toString(), (Charset)Charset.forName("UTF-8"), (boolean)true);
        }
        catch (IOException e) {
            logger.log((Priority)Level.WARN, (Object)("error writing to application log to " + this.logFilenameBase), (Throwable)e);
        }
        if (this.needsRotate()) {
            this.rotate();
        }
    }

    public String getLogFilePath() {
        return this.mainLogFile.getPath();
    }

    public void reset() {
        try {
            FileUtils.writeStringToFile((File)this.mainLogFile, (String)"");
        }
        catch (IOException e) {
            logger.log((Priority)Level.WARN, (Object)("error clearing application log to " + this.logFilenameBase), (Throwable)e);
        }
    }

    boolean needsRotate() {
        long length = this.mainLogFile.length();
        return length > (long)this.triggerRotationSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rotate() {
        LogRotationSemaphore logRotationSemaphore = this.semaphore;
        synchronized (logRotationSemaphore) {
            try {
                File newfile = new File(this.logFilenameBase + "-new.log");
                newfile.createNewFile();
                for (int i = this.backlogCount - 1; i >= 1; --i) {
                    File backlogFile = new File(this.logFilenameBase + "-" + i + ".log");
                    if (!backlogFile.exists()) continue;
                    backlogFile.renameTo(new File(this.logFilenameBase + "-" + (i + 1) + ".log"));
                }
                this.mainLogFile.renameTo(new File(this.logFilenameBase + "-1.log"));
                newfile.renameTo(this.mainLogFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error rotating application log files for project " + this.logFilenameBase, e);
            }
        }
    }
}

