/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restcomm.connect.rvd.model.project.Step;

public class Node {
    private String name;
    private String label;
    private String kind;
    private List<Step> steps;

    public static Node createDefault(String kind, String name, String label) {
        Node node = new Node();
        node.setName(name);
        node.setLabel(label);
        node.setKind(kind);
        ArrayList steps = new ArrayList();
        node.setSteps(steps);
        return node;
    }

    public String getName() {
        return this.name;
    }

    public Node setName(String name) {
        this.name = name;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Node setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public Node setKind(String kind) {
        this.kind = kind;
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public Node setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    public Step getStepByName(String stepName) {
        if (stepName == null) {
            throw new IllegalArgumentException("stepName shouldn't be null");
        }
        for (Step step : this.steps) {
            if (!stepName.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    public List<String> getStepNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            names.add(((Step)i.next()).getName());
        }
        return names;
    }
}

