/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.project;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.restcomm.connect.rvd.exceptions.IncompatibleProjectVersion;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.project.InvalidProjectKind;
import org.restcomm.connect.rvd.model.StepJsonDeserializer;
import org.restcomm.connect.rvd.model.StepJsonSerializer;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.ProjectState;
import org.restcomm.connect.rvd.model.project.SmsProject;
import org.restcomm.connect.rvd.model.project.StateHeader;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.project.UssdProject;
import org.restcomm.connect.rvd.model.project.VoiceProject;
import org.restcomm.connect.rvd.storage.exceptions.BadProjectHeader;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RvdProject {
    static final String MODULE_PREFIX_DEFAULT = "module";
    static final String STEP_PREFIX_DEFAULT = "step";
    String name;
    ProjectState state;

    public RvdProject(String name, ProjectState projectState) {
        this.name = name;
        this.state = projectState;
    }

    public RvdProject(String name) {
        this.name = name;
        this.state = new ProjectState();
        this.state.lastStepId = 0;
        this.state.lastNodeId = 0;
        this.state.nodes = new ArrayList();
        this.state.header = new StateHeader();
    }

    public RvdProject(String name, String owner, String version) {
        this(name);
        this.state.header.owner = owner;
        this.state.header.version = version;
    }

    public Node newModule(String kind) {
        ProjectState projectState = this.state;
        Integer moduleId = projectState.lastNodeId = Integer.valueOf(projectState.lastNodeId + 1);
        String moduleName = "module" + moduleId;
        Node newNode = new Node().setName(moduleName).setLabel(moduleName).setKind(kind);
        this.state.nodes.add(newNode);
        return newNode;
    }

    public void addStep(Step newStep, String parentModule) {
        String stepName;
        ProjectState projectState = this.state;
        Integer stepId = projectState.lastStepId = Integer.valueOf(projectState.lastStepId + 1);
        newStep.name = stepName = "step" + stepId;
        this.getModule(parentModule).getSteps().add(newStep);
    }

    private Node getModule(String searchedName) {
        if (this.state.nodes != null) {
            for (int i = 0; i < this.state.nodes.size(); ++i) {
                if (!"searchedName".equals(((Node)this.state.nodes.get(i)).getName())) continue;
                return (Node)this.state.nodes.get(i);
            }
        }
        return null;
    }

    public static RvdProject fromJson(String name, String projectJson) throws RvdException {
        ProjectState state = RvdProject.toModel((String)projectJson);
        String kind = state.getHeader().getProjectKind();
        VoiceProject project = null;
        if ("voice".equals(kind)) {
            project = new VoiceProject(name, state);
        } else if ("sms".equals(kind)) {
            project = new SmsProject(name, state);
        } else if ("ussd".equals(kind)) {
            project = new UssdProject(name, state);
        } else {
            throw new InvalidProjectKind("Can't create project " + name + ". Unknown project kind: " + kind);
        }
        return project;
    }

    public static ProjectState toModel(String projectJson) throws RvdException {
        Gson gson = new GsonBuilder().registerTypeAdapter(Step.class, (Object)new StepJsonDeserializer()).registerTypeAdapter(Step.class, (Object)new StepJsonSerializer()).create();
        JsonParser parser = new JsonParser();
        JsonElement header_element = parser.parse(projectJson).getAsJsonObject().get("header");
        if (header_element == null) {
            throw new BadProjectHeader("No header found. This is probably an old project");
        }
        StateHeader header = (StateHeader)gson.fromJson(header_element, StateHeader.class);
        if (!header.getVersion().equals("1.13")) {
            throw new IncompatibleProjectVersion("Error loading project. Project version: " + header.getVersion() + " - RVD project version: " + "1.13");
        }
        ProjectState projectState = (ProjectState)gson.fromJson(projectJson, ProjectState.class);
        return projectState;
    }

    public abstract boolean supportsWavs();

    public String getName() {
        return this.name;
    }

    public ProjectState getState() {
        return this.state;
    }
}

