/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.control;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.jsonvalidation.ValidationErrorItem;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.rcml.RcmlStep;
import org.restcomm.connect.rvd.model.steps.control.ControlStep;
import org.restcomm.connect.rvd.utils.RvdUtils;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ControlStep
extends Step {
    private List<Condition> conditions;
    private List<Action> actions;
    private String conditionExpression;

    public RcmlStep render(Interpreter interpreter, String containerModule) throws InterpreterException {
        return null;
    }

    public String process(Interpreter interpreter, HttpServletRequest httpRequest) throws InterpreterException {
        Boolean result = true;
        if (this.conditionExpression != null) {
            String[] parts = this.conditionExpression.split(" ");
            String previousOperation = null;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.startsWith("C")) {
                    if (previousOperation == null) {
                        result = this.evaluateCondition(this.getConditionByName(part), interpreter);
                        continue;
                    }
                    if ("AND".equals(previousOperation)) {
                        result = result != false && this.evaluateCondition(this.getConditionByName(part), interpreter);
                        continue;
                    }
                    if ("OR".equals(previousOperation)) {
                        result = result != false || this.evaluateCondition(this.getConditionByName(part), interpreter);
                        continue;
                    }
                    throw new RuntimeException("Invalid conditionExpression: " + this.conditionExpression);
                }
                if (!part.equals("AND") && !part.equals("OR")) continue;
                previousOperation = part;
            }
        }
        if (result.booleanValue() && this.actions != null && this.actions.size() > 0) {
            for (Action action : this.actions) {
                String next = this.executeAction(action, interpreter);
                if (next == null) continue;
                return next;
            }
        }
        return null;
    }

    Condition getConditionByName(String name) {
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.name.equals(name)) continue;
                return condition;
            }
        }
        return null;
    }

    boolean evaluateCondition(Condition condition, Interpreter interpreter) throws InterpreterException {
        if (condition.operator.equals("matches")) {
            String textExpanded = interpreter.populateVariables(condition.matcher.text);
            Pattern pattern = Pattern.compile(condition.matcher.regex);
            return pattern.matcher(textExpanded).matches();
        }
        String operand1Expanded = interpreter.populateVariables(condition.comparison.operand1);
        String operand2Expanded = interpreter.populateVariables(condition.comparison.operand2);
        if (condition.comparison.type == Condition.Comparison.ComparisonType.text || condition.comparison.type == null) {
            switch (condition.operator) {
                case "equals": {
                    return operand1Expanded.equals(operand2Expanded);
                }
                case "notequal": {
                    return !operand1Expanded.equals(operand2Expanded);
                }
                case "greater": {
                    return operand1Expanded.compareTo(operand2Expanded) > 0;
                }
                case "greaterEqual": {
                    return operand1Expanded.compareTo(operand2Expanded) >= 0;
                }
                case "less": {
                    return operand1Expanded.compareTo(operand2Expanded) < 0;
                }
                case "lessEqual": {
                    return operand1Expanded.compareTo(operand2Expanded) >= 0;
                }
            }
        } else if (condition.comparison.type == Condition.Comparison.ComparisonType.numeric) {
            try {
                Float operand1Float = Float.valueOf(Float.parseFloat(operand1Expanded));
                Float operand2Float = Float.valueOf(Float.parseFloat(operand2Expanded));
                switch (condition.operator) {
                    case "equals": {
                        return operand1Float.equals(operand2Float);
                    }
                    case "notequal": {
                        return !operand1Float.equals(operand2Float);
                    }
                    case "greater": {
                        return operand1Float.floatValue() > operand2Float.floatValue();
                    }
                    case "greaterEqual": {
                        return operand1Float.floatValue() >= operand2Float.floatValue();
                    }
                    case "less": {
                        return operand1Float.floatValue() < operand2Float.floatValue();
                    }
                    case "lessEqual": {
                        return operand1Float.floatValue() <= operand2Float.floatValue();
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new InterpreterException("Cannot parse numeric comparison operands. Operand1: " + operand1Expanded + " . Operand2: " + operand2Expanded);
            }
        }
        throw new NotImplementedException();
    }

    String executeAction(Action action, Interpreter interpreter) {
        if (action.continueTo != null) {
            return action.continueTo.target;
        }
        if (action.assign != null) {
            String expandedSource = interpreter.populateVariables(action.assign.expression);
            if (action.assign.varScope == null || action.assign.varScope.equals((Object)VariableScopes.mod)) {
                interpreter.putModuleVariable(action.assign.varName, expandedSource);
            } else {
                interpreter.putStickyVariable(action.assign.varName, expandedSource);
            }
        } else if (action.capture != null) {
            String expandedData = interpreter.populateVariables(action.capture.data);
            this.executeCaptureAction(expandedData, action.capture.regex, action.capture.varName, action.capture.varScope, interpreter);
        }
        return null;
    }

    private void executeCaptureAction(String data, String regex, String variable, VariableScopes variableScope, Interpreter interpreter) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(data);
        if (matcher.matches()) {
            String captured = matcher.group(1);
            if (variableScope == null || variableScope.equals((Object)VariableScopes.mod)) {
                interpreter.putModuleVariable(variable, captured);
            } else {
                interpreter.putStickyVariable(variable, captured);
            }
        }
    }

    public List<ValidationErrorItem> validate(String stepPath, Node module) {
        ArrayList<ValidationErrorItem> errorItems = new ArrayList<ValidationErrorItem>();
        if (this.conditions != null && this.conditions.size() > 0) {
            for (Condition condition : this.conditions) {
                if (condition.comparison != null || condition.matcher != null) continue;
                errorItems.add(new ValidationErrorItem("error", "Condition incomplete", stepPath));
            }
        }
        if (this.actions != null && this.actions.size() > 0) {
            for (Action action : this.actions) {
                if (action.continueTo != null) {
                    if (RvdUtils.isEmpty((String)action.continueTo.target)) {
                        errorItems.add(new ValidationErrorItem("error", "No target module specified", stepPath));
                        continue;
                    }
                    if (!action.continueTo.target.equals(module.getName())) continue;
                    errorItems.add(new ValidationErrorItem("error", "Cyclic module execution detected", stepPath));
                    continue;
                }
                if (action.assign != null) {
                    if (!RvdUtils.isEmpty((String)action.assign.varName)) continue;
                    errorItems.add(new ValidationErrorItem("error", "Assignment misses destination", stepPath));
                    continue;
                }
                if (action.capture == null || !RvdUtils.isEmpty((String)action.capture.varName)) continue;
                errorItems.add(new ValidationErrorItem("error", "Missing capture action variable", stepPath));
            }
        }
        return errorItems;
    }
}

