/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.dial;

import java.util.HashMap;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.model.steps.dial.DialNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlClientNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlNoun;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class ClientDialNoun
extends DialNoun {
    private String destination;
    private String beforeConnectModule;
    private String statusCallback;
    private String statusCallbackModule;
    Boolean enableVideo;
    String videoOverlay;
    String videoResolution;

    public ClientDialNoun() {
    }

    public ClientDialNoun(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getBeforeConnectModule() {
        return this.beforeConnectModule;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public RcmlNoun render(Interpreter interpreter) throws InterpreterException {
        HashMap<String, String> pairs;
        RcmlClientNoun rcmlNoun = new RcmlClientNoun();
        if (!RvdUtils.isEmpty((String)this.getBeforeConnectModule())) {
            pairs = new HashMap<String, String>();
            pairs.put("target", this.getBeforeConnectModule());
            rcmlNoun.setUrl(interpreter.buildAction(pairs));
        }
        rcmlNoun.setDestination(interpreter.populateVariables(this.getDestination()));
        if (!RvdUtils.isEmpty((String)this.statusCallback)) {
            rcmlNoun.statusCallback = this.statusCallback;
        } else if (!RvdUtils.isEmpty((String)this.statusCallbackModule)) {
            pairs = new HashMap();
            pairs.put("target", this.statusCallbackModule);
            rcmlNoun.statusCallback = interpreter.buildAction(pairs);
        }
        if (interpreter.getConfiguration().getVideoSupport().booleanValue() && this.enableVideo != null && this.enableVideo.booleanValue()) {
            rcmlNoun.video = new RcmlClientNoun.Video();
            rcmlNoun.video.enable = this.enableVideo;
            rcmlNoun.video.overlay = this.videoOverlay;
            rcmlNoun.video.resolution = this.videoResolution;
        }
        return rcmlNoun;
    }

    public Boolean getEnableVideo() {
        return this.enableVideo;
    }

    public String getVideoOverlay() {
        return this.videoOverlay;
    }

    public String getVideoResolution() {
        return this.videoResolution;
    }

    public void setVideoResolution(String videoResolution) {
        this.videoResolution = videoResolution;
    }
}

