/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.dial;

import java.util.HashMap;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.model.steps.dial.ConferenceDialNoun;
import org.restcomm.connect.rvd.model.steps.dial.DialNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlConferenceNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlNoun;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class ConferenceDialNoun
extends DialNoun {
    private String destination;
    private Boolean muted;
    private Boolean beep;
    private Boolean startConferenceOnEnter;
    private Boolean endConferenceOnExit;
    private String waitUrl;
    private String waitMethod;
    private String waitModule;
    private Integer maxParticipants;
    private String nextModule;
    private String statusCallback;
    private String statusCallbackModule;
    private Boolean enableVideo;
    private VideoMode videoMode;
    private String videoResolution;
    private VideoLayout videoLayout;
    private String videoOverlay;

    public String getWaitMethod() {
        return this.waitMethod;
    }

    public void setWaitMethod(String waitMethod) {
        this.waitMethod = waitMethod;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getNextModule() {
        return this.nextModule;
    }

    public void setNextModule(String nextModule) {
        this.nextModule = nextModule;
    }

    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public Boolean getBeep() {
        return this.beep;
    }

    public void setBeep(Boolean beep) {
        this.beep = beep;
    }

    public Boolean getStartConferenceOnEnter() {
        return this.startConferenceOnEnter;
    }

    public void setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
        this.startConferenceOnEnter = startConferenceOnEnter;
    }

    public Boolean getEndConferenceOnExit() {
        return this.endConferenceOnExit;
    }

    public void setEndConferenceOnExit(Boolean endConferenceOnExit) {
        this.endConferenceOnExit = endConferenceOnExit;
    }

    public String getWaitUrl() {
        return this.waitUrl;
    }

    public void setWaitUrl(String waitUrl) {
        this.waitUrl = waitUrl;
    }

    public String getWaitModule() {
        return this.waitModule;
    }

    public void setWaitModule(String waitModule) {
        this.waitModule = waitModule;
    }

    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    public Boolean getEnableVideo() {
        return this.enableVideo;
    }

    public VideoMode getVideoMode() {
        return this.videoMode;
    }

    public String getVideoResolution() {
        return this.videoResolution;
    }

    public VideoLayout getVideoLayout() {
        return this.videoLayout;
    }

    public String getVideoOverlay() {
        return this.videoOverlay;
    }

    public RcmlNoun render(Interpreter interpreter) throws InterpreterException {
        HashMap<String, String> pairs;
        RcmlConferenceNoun rcmlNoun = new RcmlConferenceNoun();
        if (!RvdUtils.isEmpty((String)this.getWaitModule())) {
            pairs = new HashMap<String, String>();
            pairs.put("target", this.getWaitModule());
            String action = interpreter.buildAction(pairs);
            rcmlNoun.setWaitUrl(interpreter.getConfiguration().getApplicationsRelativeUrl() + "/" + interpreter.getAppName() + "/" + action);
        } else if (!RvdUtils.isEmpty((String)this.getWaitUrl())) {
            rcmlNoun.setWaitUrl(interpreter.populateVariables(this.getWaitUrl()));
        }
        rcmlNoun.setBeep(this.getBeep());
        rcmlNoun.setMuted(this.getMuted());
        rcmlNoun.setEndConferenceOnExit(this.getEndConferenceOnExit());
        rcmlNoun.setStartConferenceOnEnter(this.getStartConferenceOnEnter());
        rcmlNoun.setMaxParticipants(this.getMaxParticipants());
        rcmlNoun.setWaitMethod(this.getWaitMethod());
        rcmlNoun.setDestination(interpreter.populateVariables(this.getDestination()));
        if (!RvdUtils.isEmpty((String)this.statusCallback)) {
            rcmlNoun.statusCallback = this.statusCallback;
        } else if (!RvdUtils.isEmpty((String)this.statusCallbackModule)) {
            pairs = new HashMap();
            pairs.put("target", this.statusCallbackModule);
            rcmlNoun.statusCallback = interpreter.buildAction(pairs);
        }
        if (interpreter.getConfiguration().getVideoSupport().booleanValue() && this.enableVideo != null && this.enableVideo.booleanValue()) {
            rcmlNoun.video = new RcmlConferenceNoun.Video();
            rcmlNoun.video.enable = this.enableVideo;
            if (this.videoMode != null) {
                rcmlNoun.video.mode = this.videoMode.toString();
            }
            rcmlNoun.video.resolution = this.videoResolution;
            if (this.videoLayout != null) {
                rcmlNoun.video.layout = this.videoLayout.toString();
            }
            rcmlNoun.video.overlay = this.videoOverlay;
        }
        return rcmlNoun;
    }
}

