/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.dial;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.steps.dial.ClientDialNoun;
import org.restcomm.connect.rvd.model.steps.dial.ConferenceDialNoun;
import org.restcomm.connect.rvd.model.steps.dial.DialNoun;
import org.restcomm.connect.rvd.model.steps.dial.NumberDialNoun;
import org.restcomm.connect.rvd.model.steps.dial.SipuriDialNoun;

public class DialNounJsonDeserializer
implements JsonDeserializer<DialNoun> {
    static final Logger logger = RvdLoggers.local;

    public DialNoun deserialize(JsonElement element, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        DialNoun noun;
        JsonObject noun_object = element.getAsJsonObject();
        String dialType = noun_object.get("dialType").getAsString();
        Gson gson = new GsonBuilder().create();
        if ("number".equals(dialType)) {
            noun = (DialNoun)gson.fromJson((JsonElement)noun_object, NumberDialNoun.class);
        } else if ("client".equals(dialType)) {
            noun = (DialNoun)gson.fromJson((JsonElement)noun_object, ClientDialNoun.class);
        } else if ("conference".equals(dialType)) {
            noun = (DialNoun)gson.fromJson((JsonElement)noun_object, ConferenceDialNoun.class);
        } else if ("sipuri".equals(dialType)) {
            noun = (DialNoun)gson.fromJson((JsonElement)noun_object, SipuriDialNoun.class);
        } else {
            noun = null;
            logger.error((Object)LoggingHelper.buildMessage(this.getClass(), (String)"deserialize", (String)("Cannot deserialize. Unknown noun found - " + dialType)));
        }
        return noun;
    }
}

