/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.es;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.concurrency.ResidentProjectInfo;
import org.restcomm.connect.rvd.exceptions.ESRequestException;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.exceptions.BadExternalServiceResponse;
import org.restcomm.connect.rvd.interpreter.exceptions.ESProcessFailed;
import org.restcomm.connect.rvd.interpreter.exceptions.ErrorParsingExternalServiceUrl;
import org.restcomm.connect.rvd.interpreter.exceptions.RemoteServiceError;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.client.UrlParam;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.rcml.RcmlStep;
import org.restcomm.connect.rvd.model.steps.es.Assignment;
import org.restcomm.connect.rvd.model.steps.es.RouteMapping;
import org.restcomm.connect.rvd.model.steps.es.ValueExtractor;
import org.restcomm.connect.rvd.stats.AggregateStats;
import org.restcomm.connect.rvd.stats.StatsHelper;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class ExternalServiceStep
extends Step {
    public static final String CONTENT_TYPE_WWWFORM = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    private String url;
    private String method;
    private String username;
    private String password;
    private List<UrlParam> urlParams;
    private String contentType;
    private String requestBody;
    private Boolean populatePostBodyFromParams;
    private List<Assignment> assignments;
    private String next;
    private String nextVariable;
    private Boolean doRouting;
    private String nextType;
    private ValueExtractor nextValueExtractor;
    private List<RouteMapping> routeMappings;
    private String exceptionNext;
    private Integer timeout;
    private String onTimeout;

    public ValueExtractor getNextValueExtractor() {
        return this.nextValueExtractor;
    }

    public void setNextValueExtractor(ValueExtractor nextValueExtractor) {
        this.nextValueExtractor = nextValueExtractor;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public List<RouteMapping> getRouteMappings() {
        return this.routeMappings;
    }

    public void setRouteMappings(List<RouteMapping> routeMappings) {
        this.routeMappings = routeMappings;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public Boolean getDoRouting() {
        return this.doRouting;
    }

    public void setDoRouting(Boolean doRouting) {
        this.doRouting = doRouting;
    }

    public String getNextType() {
        return this.nextType;
    }

    public void setNextType(String nextType) {
        this.nextType = nextType;
    }

    public String getNextVariable() {
        return this.nextVariable;
    }

    public void setNextVariable(String nextVariable) {
        this.nextVariable = nextVariable;
    }

    public List<UrlParam> getUrlParams() {
        return this.urlParams;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExceptionNext() {
        return this.exceptionNext;
    }

    public void setExceptionNext(String exceptionNext) {
        this.exceptionNext = exceptionNext;
    }

    public String getOnTimeout() {
        return this.onTimeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public RcmlStep render(Interpreter interpreter, String containerModule) throws InterpreterException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(Interpreter interpreter, HttpServletRequest httpRequest) throws InterpreterException {
        String next;
        AggregateStats globalStats;
        ResidentProjectInfo projectInfo;
        LoggingContext logging;
        block75: {
            String value;
            Object nextValue;
            JsonElement response_element;
            block74: {
                logging = interpreter.getLoggingContext();
                Integer requestTimeout = null;
                projectInfo = interpreter.getApplicationContext().getProjectRegistry().getResidentProjectInfo(interpreter.getAppName());
                globalStats = interpreter.getApplicationContext().getGlobalStats();
                StatsHelper.countEsCallTotal((AggregateStats)projectInfo.stats);
                StatsHelper.countEsCallTotal((AggregateStats)globalStats);
                next = null;
                try {
                    block73: {
                        CloseableHttpResponse response;
                        Object request;
                        CloseableHttpClient client;
                        BasicHttpContext httpContext;
                        URI url;
                        block76: {
                            block71: {
                                StringEntity stringBody;
                                String body;
                                block77: {
                                    try {
                                        URIBuilder uri_builder = new URIBuilder(interpreter.populateVariables(this.getUrl()));
                                        if (uri_builder.getHost() == null) {
                                            uri_builder.setScheme(httpRequest.getScheme());
                                            uri_builder.setHost(httpRequest.getServerName());
                                            uri_builder.setPort(httpRequest.getServerPort());
                                            if (!uri_builder.getPath().startsWith("/")) {
                                                uri_builder.setPath("/" + uri_builder.getPath());
                                            }
                                        }
                                        if (this.getMethod() == null || "GET".equals(this.getMethod()) || "DELETE".equals(this.getMethod())) {
                                            for (UrlParam urlParam : this.getUrlParams()) {
                                                uri_builder.addParameter(urlParam.getName(), interpreter.populateVariables(urlParam.getValue()));
                                            }
                                        }
                                        url = uri_builder.build();
                                    }
                                    catch (URISyntaxException e) {
                                        throw new ErrorParsingExternalServiceUrl("URL: " + this.getUrl(), (Throwable)e);
                                    }
                                    Integer configTimeout = interpreter.getConfiguration().getExternalServiceTimeout();
                                    requestTimeout = this.getTimeout() != null ? this.getTimeout() : interpreter.getConfiguration().getExternalServiceTimeout();
                                    if (requestTimeout > configTimeout) {
                                        requestTimeout = configTimeout;
                                    }
                                    httpContext = new BasicHttpContext();
                                    httpContext.setAttribute("http.request-config", (Object)RequestConfig.custom().setConnectTimeout(requestTimeout.intValue()).setSocketTimeout(requestTimeout.intValue()).setConnectionRequestTimeout(requestTimeout.intValue()).build());
                                    client = interpreter.getApplicationContext().getExternaltHttpClient();
                                    response_element = null;
                                    if (RvdLoggers.local.isDebugEnabled()) {
                                        RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)logging.getPrefix(), (String)("requesting from url: " + url)));
                                    }
                                    if (interpreter.getProjectSettings().getLogging().booleanValue()) {
                                        interpreter.getProjectLogger().log().tag("ES").tag("REQUEST").message((Object)("Requesting from url: " + url)).done();
                                    }
                                    if (!"POST".equals(this.getMethod()) && !"PUT".equals(this.getMethod())) break block76;
                                    request = "POST".equals(this.getMethod()) ? new HttpPost(url) : new HttpPut(url);
                                    body = interpreter.populateVariables(this.requestBody);
                                    if (!RvdUtils.isEmpty((String)this.getContentType()) && !this.getContentType().equals(CONTENT_TYPE_WWWFORM)) break block77;
                                    if (!RvdUtils.isEmpty((Boolean)this.populatePostBodyFromParams) && this.populatePostBodyFromParams.booleanValue()) {
                                        ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
                                        for (UrlParam urlParam : this.getUrlParams()) {
                                            values.add(new BasicNameValuePair(urlParam.getName(), interpreter.populateVariables(urlParam.getValue())));
                                        }
                                        request.setEntity((HttpEntity)new UrlEncodedFormEntity(values));
                                        break block71;
                                    } else {
                                        request.addHeader("Content-Type", CONTENT_TYPE_WWWFORM);
                                        if (body == null) {
                                            request.setEntity(null);
                                            break block71;
                                        } else {
                                            request.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
                                        }
                                    }
                                    break block71;
                                }
                                if (this.getContentType().equals(CONTENT_TYPE_JSON)) {
                                    request.addHeader("Content-Type", CONTENT_TYPE_JSON);
                                    stringBody = new StringEntity(body, "UTF-8");
                                    request.setEntity((HttpEntity)stringBody);
                                } else {
                                    RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)"{0} unknown content type found when POSTing to {1}: {2}", (Object[])new Object[]{logging.getPrefix(), url, this.getContentType()}));
                                    request.addHeader("Content-Type", this.getContentType());
                                    stringBody = new StringEntity(body, "UTF-8");
                                    request.setEntity((HttpEntity)stringBody);
                                }
                            }
                            if (!RvdUtils.isEmpty((String)this.getUsername())) {
                                request.addHeader("Authorization", "Basic " + RvdUtils.buildHttpAuthorizationToken((String)this.getUsername(), (String)this.getPassword()));
                            }
                            if (!RvdUtils.isEmpty((String)((String)interpreter.getVariables().get("core_CallSid")))) {
                                request.addHeader("X-RestComm-CallSid", (String)interpreter.getVariables().get("core_CallSid"));
                            }
                            String appName = interpreter.getAppName();
                            try {
                                StatsHelper.countEsCallPending((AggregateStats)projectInfo.stats, (int)1);
                                StatsHelper.countEsCallPending((AggregateStats)globalStats, (int)1);
                                response = client.execute((HttpUriRequest)request, (HttpContext)httpContext);
                            }
                            finally {
                                StatsHelper.countEsCallPending((AggregateStats)projectInfo.stats, (int)-1);
                                StatsHelper.countEsCallPending((AggregateStats)globalStats, (int)-1);
                            }
                        }
                        if (this.getMethod() != null && !this.getMethod().equals("GET")) {
                            if (!this.getMethod().equals("DELETE")) throw new InterpreterException("Unknonwn HTTP method specified: " + this.getMethod());
                        }
                        request = this.getMethod() == null || this.getMethod().equals("GET") ? new HttpGet(url) : new HttpDelete(url);
                        if (!RvdUtils.isEmpty((String)this.getUsername())) {
                            request.addHeader("Authorization", "Basic " + RvdUtils.buildHttpAuthorizationToken((String)this.getUsername(), (String)this.getPassword()));
                        }
                        if (!RvdUtils.isEmpty((String)((String)interpreter.getVariables().get("core_CallSid")))) {
                            request.addHeader("X-RestComm-CallSid", (String)interpreter.getVariables().get("core_CallSid"));
                        }
                        try {
                            StatsHelper.countEsCallPending((AggregateStats)projectInfo.stats, (int)1);
                            StatsHelper.countEsCallPending((AggregateStats)globalStats, (int)1);
                            response = client.execute((HttpUriRequest)request, (HttpContext)httpContext);
                        }
                        finally {
                            StatsHelper.countEsCallPending((AggregateStats)projectInfo.stats, (int)-1);
                            StatsHelper.countEsCallPending((AggregateStats)globalStats, (int)-1);
                        }
                        try {
                            int statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode >= 400 && statusCode < 600) {
                                StatsHelper.countEsCallServerError((AggregateStats)projectInfo.stats);
                                StatsHelper.countEsCallServerError((AggregateStats)globalStats);
                                if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                                    RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)logging.getPrefix(), (String)(" remove service failed with: " + response.getStatusLine())));
                                }
                                if (RvdUtils.isEmpty((String)this.getExceptionNext())) throw new RemoteServiceError("Service " + url + " failed with: " + response.getStatusLine() + ". Throwing an error since no 'On Remote Exception' has been defined.");
                                request = this.getExceptionNext();
                                return request;
                            }
                            if (this.getAssignments() != null && this.getAssignments().size() > 0 || this.getDoRouting().booleanValue() && ("responseBased".equals(this.getNextType()) || "mapped".equals(this.getNextType()))) {
                                HttpEntity entity = response.getEntity();
                                if (entity != null) {
                                    JsonParser parser = new JsonParser();
                                    String entity_string = EntityUtils.toString((HttpEntity)entity);
                                    if (interpreter.getProjectSettings().getLogging().booleanValue()) {
                                        interpreter.getProjectLogger().log().tag("ES").tag("RESPONSE").message((Object)entity_string).done();
                                    }
                                    response_element = parser.parse(entity_string);
                                }
                                break block73;
                            }
                            if (RvdLoggers.local.isTraceEnabled()) {
                                RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)logging.getPrefix(), (String)" no parsing will be done to the response"));
                            }
                        }
                        catch (JsonSyntaxException e) {
                            throw new BadExternalServiceResponse("External Service request received a malformed JSON response");
                        }
                        finally {
                            if (response != null) {
                                response.close();
                                client = null;
                            }
                        }
                    }
                    if (this.getDoRouting().booleanValue()) {
                        if ("fixed".equals(this.getNextType())) {
                            next = this.getNext();
                        } else if ("responseBased".equals(this.getNextType()) || "mapped".equals(this.getNextType())) {
                            nextValue = interpreter.evaluateExtractorExpression(this.getNextValueExtractor(), response_element);
                            if ("responseBased".equals(this.getNextType())) {
                                next = interpreter.getNodeNameByLabel((String)nextValue);
                            } else if ("mapped".equals(this.getNextType()) && this.getRouteMappings() != null) {
                                for (RouteMapping mapping : this.getRouteMappings()) {
                                    if (nextValue == null || !((String)nextValue).equals(mapping.getValue())) continue;
                                    next = mapping.getNext();
                                    break;
                                }
                            }
                        }
                        if ("fixed".equals(this.getNextType()) && RvdUtils.isEmpty((String)next)) {
                            throw new InterpreterException("No valid module could be found for ES routing");
                        }
                        if (RvdLoggers.local.isDebugEnabled()) {
                            RvdLoggers.local.log((Priority)Level.DEBUG, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)logging.getPrefix(), (String)(" routing enabled. Chosen target: " + next)));
                        }
                    }
                    try {
                        if (this.getDoRouting().booleanValue() && ("responseBased".equals(this.getNextType()) || "mapped".equals(this.getNextType()))) {
                            nextValue = this.getAssignments().iterator();
                            break block74;
                        }
                        for (Assignment assignment : this.getAssignments()) {
                            if (RvdLoggers.local.isEnabledFor((Priority)Level.ALL)) {
                                RvdLoggers.local.log((Priority)Level.ALL, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)"{0} working on variable {1}", (Object[])new Object[]{logging.getPrefix(), assignment.getDestVariable()}));
                            }
                            value = null;
                            try {
                                value = interpreter.evaluateExtractorExpression(assignment.getValueExtractor(), response_element);
                            }
                            catch (BadExternalServiceResponse e) {
                                String string;
                                StringBuilder stringBuilder = new StringBuilder().append("Could not parse variable '").append(assignment.getDestVariable()).append("'. Variable not found in response");
                                if (e.getMessage() != null) {
                                    string = " - " + e.getMessage();
                                    throw new ESProcessFailed(stringBuilder.append(string).toString());
                                }
                                string = "";
                                throw new ESProcessFailed(stringBuilder.append(string).toString());
                            }
                            if ("application".equals(assignment.getScope())) {
                                interpreter.putStickyVariable(assignment.getDestVariable(), value);
                            }
                            if (!"module".equals(assignment.getScope())) continue;
                            interpreter.putModuleVariable(assignment.getDestVariable(), value);
                        }
                        break block75;
                    }
                    catch (JsonSyntaxException e) {
                        throw new BadExternalServiceResponse("External Service request received a malformed JSON response");
                    }
                }
                catch (IOException e) {
                    String string;
                    if (e instanceof SocketTimeoutException) {
                        StatsHelper.countEsCallTimeout((AggregateStats)projectInfo.stats);
                        StatsHelper.countEsCallTimeout((AggregateStats)globalStats);
                        String message = LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)"[notify] {0} request to {1} timed out. Effective timeout was {2} ms.", (Object[])new Object[]{logging.getPrefix(), this.getUrl(), requestTimeout});
                        RvdLoggers.local.log((Priority)Level.WARN, (Object)message);
                        if (interpreter.getProjectSettings().getLogging().booleanValue()) {
                            interpreter.getProjectLogger().log().tag("ES").message((Object)("Request timed out. Timeout set to " + requestTimeout)).done();
                        }
                        if (RvdUtils.isEmpty((String)this.onTimeout)) return next;
                        return this.onTimeout;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Problem while processing ExternalService step ").append(this.getName());
                    if (e.getMessage() != null) {
                        string = " - " + e.getMessage();
                        throw new ESRequestException(stringBuilder.append(string).toString(), (Throwable)e);
                    }
                    string = "";
                    throw new ESRequestException(stringBuilder.append(string).toString(), (Throwable)e);
                }
            }
            while (nextValue.hasNext()) {
                Assignment assignment;
                assignment = (Assignment)nextValue.next();
                if (RvdLoggers.local.isEnabledFor((Priority)Level.ALL)) {
                    RvdLoggers.local.log((Priority)Level.ALL, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)"{0} working on variable {1}:{2}", (Object[])new Object[]{logging.getPrefix(), assignment.getModuleNameScope(), assignment.getDestVariable()}));
                }
                if (assignment.getModuleNameScope() != null && !assignment.getModuleNameScope().equals(next)) continue;
                value = null;
                try {
                    value = interpreter.evaluateExtractorExpression(assignment.getValueExtractor(), response_element);
                }
                catch (BadExternalServiceResponse e) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("Could not parse variable '").append(assignment.getDestVariable()).append("'. Variable not found in response - ");
                    if (e.getMessage() != null) {
                        string = " - " + e.getMessage();
                        throw new ESProcessFailed(stringBuilder.append(string).toString());
                    }
                    string = "";
                    throw new ESProcessFailed(stringBuilder.append(string).toString());
                }
                if ("application".equals(assignment.getScope())) {
                    interpreter.putStickyVariable(assignment.getDestVariable(), value);
                }
                if (!"module".equals(assignment.getScope())) continue;
                interpreter.putModuleVariable(assignment.getDestVariable(), value);
            }
        }
        if (RvdLoggers.local.isTraceEnabled()) {
            RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"process", (String)"{0} variables after processing ExternalService step: {1}", (Object[])new Object[]{logging.getPrefix(), interpreter.getVariables().toString()}));
        }
        StatsHelper.countEsCallSuccess((AggregateStats)projectInfo.stats);
        StatsHelper.countEsCallSuccess((AggregateStats)globalStats);
        return next;
    }
}

