/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.fax;

import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.steps.fax.RcmlFaxStep;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class FaxStep
extends Step {
    String to;
    String from;
    String text;
    String next;
    String method;
    String statusCallback;

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getStatusCallback() {
        return this.statusCallback;
    }

    public void setStatusCallback(String statusCallback) {
        this.statusCallback = statusCallback;
    }

    public RcmlFaxStep render(Interpreter interpreter, String containerModule) {
        RcmlFaxStep rcmlStep = new RcmlFaxStep();
        if (!RvdUtils.isEmpty((String)this.getNext())) {
            String newtarget = containerModule + "." + this.getName() + ".actionhandler";
            HashMap<String, String> pairs = new HashMap<String, String>();
            pairs.put("target", newtarget);
            String action = interpreter.buildAction(pairs);
            rcmlStep.setAction(action);
            rcmlStep.setMethod(this.getMethod());
        }
        rcmlStep.setFrom(interpreter.populateVariables(this.getFrom()));
        rcmlStep.setTo(interpreter.populateVariables(this.getTo()));
        rcmlStep.setStatusCallback(this.getStatusCallback());
        rcmlStep.setText(interpreter.populateVariables(this.getText()));
        return rcmlStep;
    }

    public void handleAction(Interpreter interpreter, Node handlerModule) throws InterpreterException, StorageException {
        LoggingContext logging = interpreter.getLoggingContext();
        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)logging.getPrefix(), (String)"handling fax action"));
        }
        if (RvdUtils.isEmpty((String)this.getNext())) {
            throw new InterpreterException("'next' module is not defined for step " + this.getName());
        }
        String FaxSid = (String)interpreter.getRequestParams().getFirst((Object)"FaxSid");
        String FaxStatus = (String)interpreter.getRequestParams().getFirst((Object)"FaxStatus");
        if (FaxSid != null) {
            interpreter.getVariables().put("core_FaxSid", FaxSid);
        }
        if (FaxStatus != null) {
            interpreter.getVariables().put("core_FaxStatus", FaxStatus);
        }
        interpreter.interpret(this.getNext(), null, null, handlerModule);
    }
}

