/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.gather;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.jsonvalidation.ValidationErrorItem;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.steps.gather.GatherStep;
import org.restcomm.connect.rvd.model.steps.gather.RcmlGatherStep;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;

/*
 * Exception performing whole class analysis ignored.
 */
public class GatherStep
extends Step {
    private String action;
    private String method;
    private Integer timeout;
    private String finishOnKey;
    private Integer numDigits;
    private List<Step> steps;
    private Validation validation;
    private Validation speechValidation;
    private Step invalidMessage;
    private Step speechInvalidMessage;
    private Menu menu;
    private Collectdigits collectdigits;
    private Collectdigits collectspeech;
    private String gatherType;
    private String inputType;
    private String hints;
    private String language;
    private String partialResultCallback;
    private String partialResultCallbackMethod;

    public RcmlGatherStep render(Interpreter interpreter, String containerModule) throws InterpreterException {
        RcmlGatherStep rcmlStep = new RcmlGatherStep();
        String newtarget = containerModule + "." + this.getName() + ".handle";
        HashMap<String, String> pairs = new HashMap<String, String>();
        pairs.put("target", newtarget);
        String action = interpreter.buildAction(pairs);
        rcmlStep.setAction(action);
        rcmlStep.setTimeout(this.timeout);
        if (this.finishOnKey != null && !"".equals(this.finishOnKey)) {
            rcmlStep.setFinishOnKey(this.finishOnKey);
        }
        rcmlStep.setMethod(this.method);
        rcmlStep.setNumDigits(this.numDigits);
        rcmlStep.setHints(this.hints);
        rcmlStep.setLanguage(this.language);
        rcmlStep.setInput(this.inputType);
        if (!"dtmf".equalsIgnoreCase(this.inputType) && !StringUtils.isEmpty((String)this.partialResultCallback)) {
            rcmlStep.setPartialResultCallback(this.partialResultCallback);
            rcmlStep.setPartialResultCallbackMethod(StringUtils.isEmpty((String)this.partialResultCallbackMethod) ? "POST" : this.partialResultCallbackMethod);
        }
        for (Step nestedStep : this.steps) {
            rcmlStep.getSteps().add(nestedStep.render(interpreter, containerModule));
        }
        return rcmlStep;
    }

    private boolean handleMapping(Interpreter interpreter, Node originModule, String key, List<? extends Mapping> mappings, boolean isPattern) throws StorageException, InterpreterException {
        LoggingContext logging = interpreter.getLoggingContext();
        if (mappings != null) {
            for (Mapping mapping : mappings) {
                if (RvdLoggers.local.isTraceEnabled()) {
                    RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)"{0} checking key: {1} - {2}", (Object[])new Object[]{logging.getPrefix(), mapping.getKey(), key}));
                }
                if (key == null || (isPattern || !mapping.getKey().equals(key)) && (!isPattern || !Pattern.matches(mapping.getKey(), key))) continue;
                if (RvdLoggers.local.isTraceEnabled()) {
                    RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)logging.getPrefix(), (String)(" seems we found our menu selection: " + key)));
                }
                interpreter.interpret(mapping.getNext(), null, null, originModule);
                return true;
            }
        }
        return false;
    }

    private String getPattern(Interpreter interpreter, Validation validation) {
        if (validation == null) {
            return null;
        }
        String effectivePattern = null;
        if (Validation.access$000((Validation)validation) != null) {
            effectivePattern = "^[" + interpreter.populateVariables(Validation.access$000((Validation)validation)) + "]$";
        } else if (Validation.access$100((Validation)validation) != null) {
            effectivePattern = interpreter.populateVariables(Validation.access$100((Validation)validation));
        } else {
            RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)interpreter.getLoggingContext().getPrefix(), (String)" Invalid validation information in gather. Validation object exists while other patterns are null"));
        }
        return effectivePattern;
    }

    private Step getInvalidMessage(InputType inputType) {
        switch (1.$SwitchMap$org$restcomm$connect$rvd$model$steps$gather$GatherStep$InputType[inputType.ordinal()]) {
            case 1: {
                return this.invalidMessage;
            }
            case 2: {
                return this.speechInvalidMessage;
            }
        }
        return null;
    }

    private void putVariable(Interpreter interpreter, Collectdigits collect, String varName, String varValue) {
        if ("application".equals(Collectdigits.access$200((Collectdigits)collect))) {
            interpreter.putStickyVariable(varName, varValue);
        } else if ("module".equals(Collectdigits.access$200((Collectdigits)collect))) {
            interpreter.putModuleVariable(varName, varValue);
        }
        interpreter.getVariables().put(varName, varValue);
    }

    private boolean isMatchesPattern(String pattern, String value, LoggingContext logging) {
        if (RvdLoggers.local.isTraceEnabled()) {
            RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)"{0} validating '{1}' against '{}'", (Object[])new Object[]{logging.getPrefix(), value, pattern}));
        }
        return !StringUtils.isEmpty((String)value) && value.matches(pattern);
    }

    private boolean handleCollect(Interpreter interpreter, Node originModule, Collectdigits collect, String newValue, Validation validation) throws StorageException, InterpreterException {
        LoggingContext logging = interpreter.getLoggingContext();
        String effectivePattern = this.getPattern(interpreter, validation);
        String variableName = Collectdigits.access$300((Collectdigits)collect);
        String variableValue = newValue;
        if (variableValue == null) {
            RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)logging.getPrefix(), (String)"'Digits/Speech' parameter was null. Is this a valid restcomm request?"));
            variableValue = "";
        }
        if (effectivePattern == null || this.isMatchesPattern(effectivePattern, variableValue, logging)) {
            this.putVariable(interpreter, collect, variableName, variableValue);
            interpreter.interpret(Collectdigits.access$400((Collectdigits)collect), null, null, originModule);
            return true;
        }
        if (RvdLoggers.local.isTraceEnabled()) {
            RvdLoggers.local.log((Priority)Level.TRACE, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)logging.getPrefix(), (String)"{0} Invalid input for gather/collectdigits. Will say the validation message and rerun the gather"));
        }
        return false;
    }

    public void handleAction(Interpreter interpreter, Node handlerModule) throws InterpreterException, StorageException {
        LoggingContext logging = interpreter.getLoggingContext();
        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)logging.getPrefix(), (String)"handling gather action"));
        }
        String digitsString = (String)interpreter.getRequestParams().getFirst((Object)"Digits");
        String unstableSpeechString = (String)interpreter.getRequestParams().getFirst((Object)"UnstableSpeechResult");
        String speechResultString = (String)interpreter.getRequestParams().getFirst((Object)"SpeechResult");
        if (digitsString != null) {
            interpreter.getVariables().put("core_Digits", digitsString);
        }
        if (unstableSpeechString != null) {
            interpreter.getVariables().put("core_UnstableSpeechResult", unstableSpeechString);
        }
        if (speechResultString != null) {
            interpreter.getVariables().put("core_SpeechResult", speechResultString);
        }
        boolean isValid = true;
        InputType inputTypeE = InputType.parse((String)this.inputType);
        InputType actualInputType = null;
        if ("menu".equals(this.gatherType)) {
            switch (1.$SwitchMap$org$restcomm$connect$rvd$model$steps$gather$GatherStep$InputType[inputTypeE.ordinal()]) {
                case 1: {
                    isValid = this.handleMapping(interpreter, handlerModule, digitsString, Menu.access$500((Menu)this.menu), false);
                    actualInputType = InputType.DTMF;
                    break;
                }
                case 2: {
                    if (!StringUtils.isEmpty((String)unstableSpeechString)) {
                        return;
                    }
                    if (!StringUtils.isEmpty((String)speechResultString)) {
                        isValid = this.handleMapping(interpreter, handlerModule, speechResultString, Menu.access$600((Menu)this.menu), true);
                    }
                    actualInputType = InputType.SPEECH;
                    break;
                }
                case 3: {
                    if (!StringUtils.isEmpty((String)digitsString)) {
                        isValid = this.handleMapping(interpreter, handlerModule, digitsString, Menu.access$500((Menu)this.menu), false);
                        actualInputType = InputType.DTMF;
                        break;
                    }
                    if (!StringUtils.isEmpty((String)unstableSpeechString)) {
                        return;
                    }
                    if (!StringUtils.isEmpty((String)speechResultString)) {
                        isValid = this.handleMapping(interpreter, handlerModule, speechResultString, Menu.access$600((Menu)this.menu), true);
                        actualInputType = InputType.SPEECH;
                        break;
                    }
                    actualInputType = InputType.DTMF;
                    isValid = false;
                }
            }
        } else if ("collectdigits".equals(this.gatherType)) {
            switch (1.$SwitchMap$org$restcomm$connect$rvd$model$steps$gather$GatherStep$InputType[inputTypeE.ordinal()]) {
                case 1: {
                    isValid = this.handleCollect(interpreter, handlerModule, this.collectdigits, digitsString, this.validation);
                    actualInputType = InputType.DTMF;
                    break;
                }
                case 2: {
                    if (!StringUtils.isEmpty((String)unstableSpeechString)) {
                        return;
                    }
                    if (!StringUtils.isEmpty((String)speechResultString)) {
                        isValid = this.handleCollect(interpreter, handlerModule, this.collectspeech, speechResultString, this.speechValidation);
                    }
                    actualInputType = InputType.SPEECH;
                    break;
                }
                case 3: {
                    if (!StringUtils.isEmpty((String)digitsString)) {
                        isValid = this.handleCollect(interpreter, handlerModule, this.collectdigits, digitsString, this.validation);
                        actualInputType = InputType.DTMF;
                        break;
                    }
                    if (!StringUtils.isEmpty((String)unstableSpeechString)) {
                        return;
                    }
                    if (!StringUtils.isEmpty((String)speechResultString)) {
                        isValid = this.handleCollect(interpreter, handlerModule, this.collectspeech, speechResultString, this.speechValidation);
                        actualInputType = InputType.SPEECH;
                        break;
                    }
                    actualInputType = InputType.DTMF;
                    isValid = false;
                }
            }
        }
        if (!isValid) {
            Step invalidMessage = this.getInvalidMessage(actualInputType);
            interpreter.interpret(handlerModule, this.getName(), (Step)(invalidMessage != null ? invalidMessage : null), handlerModule);
        }
    }

    public List<ValidationErrorItem> validate(String stepPath, Node module) {
        ArrayList<ValidationErrorItem> errorItems = new ArrayList<ValidationErrorItem>();
        InputType actualInputType = InputType.parse((String)this.inputType);
        if (actualInputType == InputType.DTMF && "menu".equals(this.gatherType) && (this.menu == null || Menu.access$500((Menu)this.menu) == null || Menu.access$500((Menu)this.menu).isEmpty())) {
            errorItems.add(new ValidationErrorItem("error", "No DTMF mappings found", stepPath));
        }
        if (actualInputType == InputType.SPEECH && "menu".equals(this.gatherType) && (this.menu == null || Menu.access$600((Menu)this.menu) == null || Menu.access$600((Menu)this.menu).isEmpty())) {
            errorItems.add(new ValidationErrorItem("error", "No speech mappings found", stepPath));
        }
        if (actualInputType == InputType.DTMF_SPEECH && "menu".equals(this.gatherType) && (this.menu == null || Menu.access$600((Menu)this.menu) == null || Menu.access$600((Menu)this.menu).isEmpty()) && (this.menu == null || Menu.access$500((Menu)this.menu) == null || Menu.access$500((Menu)this.menu).isEmpty())) {
            errorItems.add(new ValidationErrorItem("error", "Neither DTMF nor speech mappings found", stepPath));
        }
        if (!StringUtils.isEmpty((String)this.hints)) {
            List<String> hintList = Arrays.asList(this.hints.split(","));
            if (hintList.size() > 50) {
                errorItems.add(new ValidationErrorItem("error", "More than 50 phrases in Hot words", stepPath));
            }
            for (String hint : hintList) {
                if (hint.length() <= 100) continue;
                errorItems.add(new ValidationErrorItem("error", "More than 100 characters in one of Hot words", stepPath));
            }
        }
        return errorItems;
    }
}

