/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.record;

import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.logging.system.LoggingContext;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.Step;
import org.restcomm.connect.rvd.model.steps.record.RcmlRecordStep;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class RecordStep
extends Step {
    String next;
    String method;
    Integer timeout;
    String finishOnKey;
    Integer maxLength;
    Boolean transcribe;
    String transcribeCallback;
    Boolean playBeep;
    String media;

    public String getTranscribeCallback() {
        return this.transcribeCallback;
    }

    public void setTranscribeCallback(String transcribeCallback) {
        this.transcribeCallback = transcribeCallback;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getFinishOnKey() {
        return this.finishOnKey;
    }

    public void setFinishOnKey(String finishOnKey) {
        this.finishOnKey = finishOnKey;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getTranscribe() {
        return this.transcribe;
    }

    public void setTranscribe(Boolean transcribe) {
        this.transcribe = transcribe;
    }

    public Boolean getPlayBeep() {
        return this.playBeep;
    }

    public void setPlayBeep(Boolean playBeep) {
        this.playBeep = playBeep;
    }

    public String getMedia() {
        return this.media;
    }

    public RcmlRecordStep render(Interpreter interpreter, String containerModule) {
        RcmlRecordStep rcmlStep = new RcmlRecordStep();
        if (!RvdUtils.isEmpty((String)this.getNext())) {
            String newtarget = containerModule + "." + this.getName() + ".actionhandler";
            HashMap<String, String> pairs = new HashMap<String, String>();
            pairs.put("target", newtarget);
            String action = interpreter.buildAction(pairs);
            rcmlStep.setAction(action);
            rcmlStep.setMethod(this.getMethod());
        }
        rcmlStep.setFinishOnKey(this.getFinishOnKey());
        rcmlStep.setMaxLength(this.getMaxLength());
        rcmlStep.setPlayBeep(this.getPlayBeep());
        rcmlStep.setTimeout(this.getTimeout());
        rcmlStep.setTranscribe(this.getTranscribe());
        rcmlStep.setTranscribeCallback(this.getTranscribeCallback());
        if (interpreter.getConfiguration().getVideoSupport().booleanValue()) {
            rcmlStep.setMedia(this.getMedia());
        }
        return rcmlStep;
    }

    public void handleAction(Interpreter interpreter, Node handlerModule) throws InterpreterException, StorageException {
        String Digits;
        String RecordingDuration;
        String restcommRecordingUrl;
        LoggingContext logging = interpreter.getLoggingContext();
        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)logging.getPrefix(), (String)"handling record action"));
        }
        if (RvdUtils.isEmpty((String)this.getNext())) {
            throw new InterpreterException("'next' module is not defined for step " + this.getName());
        }
        String publicRecordingUrl = (String)interpreter.getRequestParams().getFirst((Object)"PublicRecordingUrl");
        if (publicRecordingUrl != null) {
            interpreter.getVariables().put("core_PublicRecordingUrl", publicRecordingUrl);
        }
        if ((restcommRecordingUrl = (String)interpreter.getRequestParams().getFirst((Object)"RecordingUrl")) != null) {
            try {
                String recordingUrl = interpreter.convertRecordingFileResourceHttp(restcommRecordingUrl);
                interpreter.getVariables().put("core_RecordingUrl", recordingUrl);
            }
            catch (URISyntaxException e) {
                RvdLoggers.local.log((Priority)Level.WARN, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"handleAction", (String)"{0} cannot convert file URL to http URL - {1}", (Object[])new Object[]{logging.getPrefix(), restcommRecordingUrl}));
            }
        }
        if ((RecordingDuration = (String)interpreter.getRequestParams().getFirst((Object)"RecordingDuration")) != null) {
            interpreter.getVariables().put("core_RecordingDuration", RecordingDuration);
        }
        if ((Digits = (String)interpreter.getRequestParams().getFirst((Object)"Digits")) != null) {
            interpreter.getVariables().put("core_Digits", Digits);
        }
        interpreter.interpret(this.getNext(), null, null, handlerModule);
    }
}

