/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.storage;

import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.project.Node;
import org.restcomm.connect.rvd.model.project.ProjectState;
import org.restcomm.connect.rvd.model.server.ProjectOptions;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.ProjectDao;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class FsProjectDao
implements ProjectDao {
    String applicationName;
    WorkspaceStorage workspaceStorage;

    public FsProjectDao(String applicationName, WorkspaceStorage workspaceStorage) {
        if (RvdUtils.isEmpty((String)applicationName)) {
            throw new IllegalStateException("Application name is null. Cannot create FsProjectDao");
        }
        this.applicationName = applicationName;
        this.workspaceStorage = workspaceStorage;
    }

    public String getName() {
        return this.applicationName;
    }

    public ProjectState loadProject() throws StorageException {
        try {
            return FsProjectStorage.loadProject((String)this.applicationName, (WorkspaceStorage)this.workspaceStorage);
        }
        catch (StorageEntityNotFound e) {
            return null;
        }
    }

    public ProjectOptions loadProjectOptions() throws StorageException {
        return FsProjectStorage.loadProjectOptions((String)this.applicationName, (WorkspaceStorage)this.workspaceStorage);
    }

    public Node loadNode(String moduleName) throws StorageException {
        return FsProjectStorage.loadNode((String)this.applicationName, (String)moduleName, (WorkspaceStorage)this.workspaceStorage);
    }

    public String loadBootstrapInfo() throws StorageException {
        try {
            return FsProjectStorage.loadBootstrapInfo((String)this.applicationName, (WorkspaceStorage)this.workspaceStorage);
        }
        catch (StorageEntityNotFound e) {
            return null;
        }
    }

    public ProjectSettings loadSettings() throws StorageException {
        try {
            return FsProjectStorage.loadProjectSettings((String)this.applicationName, (WorkspaceStorage)this.workspaceStorage);
        }
        catch (StorageEntityNotFound e) {
            return null;
        }
    }

    public void storeSettings(ProjectSettings projectSettings) throws StorageException {
        FsProjectStorage.storeProjectSettings((ProjectSettings)projectSettings, (String)this.applicationName, (WorkspaceStorage)this.workspaceStorage);
    }

    public String loadProjectStateRaw() throws StorageException {
        return FsProjectStorage.loadProjectString((String)this.applicationName, (WorkspaceStorage)this.workspaceStorage);
    }
}

