/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.upgrade;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.BuildService;
import org.restcomm.connect.rvd.exceptions.InvalidProjectVersion;
import org.restcomm.connect.rvd.logging.system.LoggingHelper;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.model.project.ProjectState;
import org.restcomm.connect.rvd.model.project.StateHeader;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.BadProjectHeader;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.upgrade.ProjectUpgrader;
import org.restcomm.connect.rvd.upgrade.ProjectUpgraderFactory;
import org.restcomm.connect.rvd.upgrade.UpgradeService;
import org.restcomm.connect.rvd.upgrade.exceptions.NoUpgradePathException;
import org.restcomm.connect.rvd.upgrade.exceptions.UpgradeException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UpgradeService {
    static Logger logger = RvdLoggers.local;
    static final String[] versionPath = new String[]{"rvd714", "1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "1.10", "1.11", "1.12", "1.13"};
    static final List<String> upgradesPath = Arrays.asList("1.0", "1.6", "1.13");
    private WorkspaceStorage workspaceStorage;

    public UpgradeService(WorkspaceStorage workspaceStorage) {
        this.workspaceStorage = workspaceStorage;
    }

    public static boolean checkBackwardCompatible(String checkedProjectVesion, String referenceProjectVersion) throws InvalidProjectVersion {
        if ("1.13".equals(referenceProjectVersion)) {
            return "1.13".equals(checkedProjectVesion);
        }
        if ("1.12".equals(referenceProjectVersion)) {
            return "1.12".equals(checkedProjectVesion) || "1.11".equals(checkedProjectVesion) || "1.10".equals(checkedProjectVesion) || "1.9".equals(checkedProjectVesion) || "1.8".equals(checkedProjectVesion) || "1.7".equals(checkedProjectVesion) || "1.6".equals(checkedProjectVesion);
        }
        if ("1.11".equals(referenceProjectVersion)) {
            return "1.11".equals(checkedProjectVesion) || "1.10".equals(checkedProjectVesion) || "1.9".equals(checkedProjectVesion) || "1.8".equals(checkedProjectVesion) || "1.7".equals(checkedProjectVesion) || "1.6".equals(checkedProjectVesion);
        }
        if ("1.10".equals(referenceProjectVersion)) {
            return "1.10".equals(checkedProjectVesion) || "1.9".equals(checkedProjectVesion) || "1.8".equals(checkedProjectVesion) || "1.7".equals(checkedProjectVesion) || "1.6".equals(checkedProjectVesion);
        }
        if ("1.9".equals(referenceProjectVersion)) {
            return "1.9".equals(checkedProjectVesion) || "1.8".equals(checkedProjectVesion) || "1.7".equals(checkedProjectVesion) || "1.6".equals(checkedProjectVesion);
        }
        if ("1.8".equals(referenceProjectVersion)) {
            return "1.8".equals(checkedProjectVesion) || "1.7".equals(checkedProjectVesion) || "1.6".equals(checkedProjectVesion);
        }
        if ("1.7".equals(referenceProjectVersion)) {
            return "1.7".equals(checkedProjectVesion) || "1.6".equals(checkedProjectVesion);
        }
        if ("1.6".equals(referenceProjectVersion)) {
            return "1.6".equals(checkedProjectVesion);
        }
        if ("1.5".equals(referenceProjectVersion)) {
            return "1.5".equals(checkedProjectVesion) || "1.4".equals(checkedProjectVesion) || "1.3".equals(checkedProjectVesion) || "1.2".equals(checkedProjectVesion) || "1.1".equals(checkedProjectVesion) || "1.0".equals(checkedProjectVesion);
        }
        if ("1.4".equals(referenceProjectVersion)) {
            return "1.4".equals(checkedProjectVesion) || "1.3".equals(checkedProjectVesion) || "1.2".equals(checkedProjectVesion) || "1.1".equals(checkedProjectVesion) || "1.0".equals(checkedProjectVesion);
        }
        if ("1.3".equals(referenceProjectVersion)) {
            return "1.3".equals(checkedProjectVesion) || "1.2".equals(checkedProjectVesion) || "1.1".equals(checkedProjectVesion) || "1.0".equals(checkedProjectVesion);
        }
        if ("1.2".equals(referenceProjectVersion)) {
            return "1.2".equals(checkedProjectVesion) || "1.1".equals(checkedProjectVesion) || "1.0".equals(checkedProjectVesion);
        }
        if ("1.1.1".equals(referenceProjectVersion)) {
            return "1.1.1".equals(checkedProjectVesion) || "1.1".equals(checkedProjectVesion) || "1.0".equals(checkedProjectVesion);
        }
        if ("1.1".equals(referenceProjectVersion)) {
            return "1.1".equals(checkedProjectVesion) || "1.0".equals(checkedProjectVesion);
        }
        if ("1.0".equals(referenceProjectVersion)) {
            return "1.0".equals(checkedProjectVesion);
        }
        throw new InvalidProjectVersion("Invalid version identifier: " + referenceProjectVersion);
    }

    public static UpgradabilityStatus checkUpgradability(String projectVersion, String rvdProjectVersion) throws InvalidProjectVersion {
        int i;
        int projectIndex = -1;
        int rvdIndex = -1;
        for (i = 0; i < versionPath.length; ++i) {
            if (versionPath[i].equals(projectVersion)) {
                projectIndex = i;
            }
            if (!versionPath[i].equals(rvdProjectVersion)) continue;
            rvdIndex = i;
        }
        if (rvdIndex == -1) {
            throw new IllegalStateException("RVD project version not found in the versionPath.");
        }
        if (projectIndex == -1) {
            return UpgradabilityStatus.NOT_SUPPORTED;
        }
        boolean upgradesInvolved = false;
        for (i = projectIndex + 1; i <= rvdIndex; ++i) {
            if (!upgradesPath.contains(versionPath[i])) continue;
            upgradesInvolved = true;
        }
        if (upgradesInvolved) {
            return UpgradabilityStatus.UPGRADABLE;
        }
        return UpgradabilityStatus.NOT_NEEDED;
    }

    public JsonElement upgradeProject(String projectName) throws StorageException, UpgradeException {
        StateHeader header = null;
        String startVersion = null;
        try {
            header = FsProjectStorage.loadStateHeader((String)projectName, (WorkspaceStorage)this.workspaceStorage);
            startVersion = header.getVersion();
        }
        catch (BadProjectHeader e) {
            startVersion = "rvd714";
        }
        if (startVersion.equals("1.13")) {
            return null;
        }
        if (UpgradeService.checkBackwardCompatible((String)startVersion, (String)"1.13")) {
            return null;
        }
        if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeProject", (String)("upgrading '" + projectName + "' from version " + startVersion)));
        }
        String version = startVersion;
        String source = FsProjectStorage.loadProjectString((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(source);
        for (int i = 0; i < versionPath.length; ++i) {
            if (!versionPath[i].equals(version)) continue;
            ProjectUpgrader upgrader = ProjectUpgraderFactory.create((String)version);
            root = upgrader.upgrade(root);
            version = upgrader.getResultingVersion();
            if (version.equals(versionPath[versionPath.length - 1])) break;
        }
        if (!version.equals(versionPath[versionPath.length - 1])) {
            throw new NoUpgradePathException("No upgrade path for project " + projectName + ". Best effort from version: " + startVersion + " - to version: " + versionPath[versionPath.length - 1]);
        }
        FsProjectStorage.backupProjectState((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        FsProjectStorage.updateProjectState((String)projectName, (String)root.toString(), (WorkspaceStorage)this.workspaceStorage);
        return root;
    }

    public void upgradeWorkspace() throws StorageException {
        BuildService buildService = new BuildService(this.workspaceStorage);
        int upgradedCount = 0;
        int uptodateCount = 0;
        int failedCount = 0;
        List projectNames = FsProjectStorage.listProjectNames((WorkspaceStorage)this.workspaceStorage);
        for (String projectName : projectNames) {
            try {
                if (this.upgradeProject(projectName) != null) {
                    ++upgradedCount;
                    if (RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
                        RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeWorkspace", (String)("project '" + projectName + "' upgraded to version " + "1.13")));
                    }
                    try {
                        ProjectState projectState = FsProjectStorage.loadProject((String)projectName, (WorkspaceStorage)this.workspaceStorage);
                        buildService.buildProject(projectName, projectState);
                        if (!RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) continue;
                        RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeWorkspace", (String)("project '" + projectName + "' built")));
                    }
                    catch (StorageException e) {
                        RvdLoggers.local.log((Priority)Level.WARN, (Object)("error building upgraded project '" + projectName + "'"), (Throwable)e);
                    }
                    continue;
                }
                ++uptodateCount;
            }
            catch (StorageException | UpgradeException e) {
                ++failedCount;
                RvdLoggers.local.log((Priority)Level.ERROR, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeWorkspace", (String)("error upgrading project '" + projectName + "' to version " + "1.13")), e);
            }
        }
        if (failedCount > 0 && RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeWorkspace", (String)("" + failedCount + " RVD projects failed upgrade")));
        }
        if (upgradedCount > 0 && RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeWorkspace", (String)("" + upgradedCount + " RVD projects upgraded")));
        }
        if (projectNames.size() > 0 && failedCount == 0 && RvdLoggers.local.isEnabledFor((Priority)Level.INFO)) {
            RvdLoggers.local.log((Priority)Level.INFO, (Object)LoggingHelper.buildMessage(this.getClass(), (String)"upgradeWorkspace", (String)"all RVD projects are up to date (or don't need upgrade)"));
        }
    }
}

