/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.StreamDoesNotFitInFile;

public class RvdUtils {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final int STREAM_COPY_BUFFER_SIZE = 1024;

    public static File createTempDir() throws RvdException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new RvdException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean isEmpty(Boolean value) {
        return value == null || value == false;
    }

    public static boolean safeEquals(String value1, String value2) {
        return value1 == null ? value1 == value2 : value1.equals(value2);
    }

    public static boolean isTrue(Boolean booleanValue) {
        return booleanValue != null && booleanValue != false;
    }

    public static Map<String, String> reduceHttpRequestParameterMap(Map<String, String[]> requestMap) {
        HashMap<String, String> reducedMap = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : requestMap.entrySet()) {
            reducedMap.put(entry.getKey(), entry.getValue()[0]);
        }
        return reducedMap;
    }

    public static String buildHttpAuthorizationToken(String username, String password) {
        byte[] usernamePassBytes = (username + ":" + password).getBytes(Charset.forName("UTF-8"));
        String authenticationToken = Base64.encodeBase64String((byte[])usernamePassBytes);
        return authenticationToken;
    }

    public static String myUrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int streamToFile(InputStream input, File outputFile, Integer max_bytes) throws IOException, StreamDoesNotFitInFile {
        byte[] buffer = new byte[1024];
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            int copiedSize = 0;
            int readCount = input.read(buffer);
            while (readCount > 0) {
                if (max_bytes != null && copiedSize + readCount > max_bytes) {
                    outputStream.close();
                    FileUtils.deleteQuietly((File)outputFile);
                    throw new StreamDoesNotFitInFile();
                }
                outputStream.write(buffer, 0, readCount);
                copiedSize += readCount;
                readCount = input.read(buffer);
            }
            int n = copiedSize;
            return n;
        }
    }

    public static String addTrailingSlashIfMissing(String urlOrPath) {
        if (urlOrPath != null && !urlOrPath.endsWith("/")) {
            urlOrPath = urlOrPath + "/";
        }
        return urlOrPath;
    }

    public static String getOriginFromRequest(HttpServletRequest request) {
        if (request != null) {
            String origin = request.getScheme() + "://" + request.getServerName();
            int port = request.getServerPort();
            if (port != -1 && port != 80 && port != 443) {
                origin = origin + ":" + port;
            }
            return origin;
        }
        return null;
    }
}

