/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Unzipper {
    File outputDirectory;

    public Unzipper(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void unzip(InputStream zipStream) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(zipStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName();
                String pathname = this.outputDirectory.getPath() + File.separator + fileName;
                String destinationDirPath = FilenameUtils.getFullPath((String)pathname);
                File destinationDir = new File(destinationDirPath);
                if (!destinationDir.exists()) {
                    destinationDir.mkdirs();
                }
                if (!zipEntry.isDirectory()) {
                    FileOutputStream fileEntryStream = new FileOutputStream(new File(pathname));
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)fileEntryStream);
                    fileEntryStream.close();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

