/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.restcomm.connect.rvd.exceptions.XmlParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParser {
    private XPathFactory xPathfactory;
    private Document doc;
    private String xmlFilePath;

    public XmlParser(String filepath) throws XmlParserException {
        this.xmlFilePath = filepath;
        this.xPathfactory = XPathFactory.newInstance();
        File xmlFile = new File(filepath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(xmlFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlParserException("Error parsing xml file: " + this.xmlFilePath, (Throwable)e);
        }
        this.doc.getDocumentElement().normalize();
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getElementContent(String xpathString) throws XmlParserException {
        Node node = this.getElement(xpathString);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    public Node getElement(String xpathString) throws XmlParserException {
        XPath xpath = this.xPathfactory.newXPath();
        try {
            XPathExpression expr = xpath.compile(xpathString);
            Node node = (Node)expr.evaluate(this.doc, XPathConstants.NODE);
            return node;
        }
        catch (XPathExpressionException e) {
            throw new XmlParserException("Error parsing xml file: " + this.xmlFilePath, (Throwable)e);
        }
    }

    public List<String> getElementList(String xpathString) throws XmlParserException {
        XPath xpath = this.xPathfactory.newXPath();
        try {
            XPathExpression expr = xpath.compile(xpathString);
            NodeList nodes = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            if (nodes != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    list.add(node.getTextContent());
                }
                return list;
            }
        }
        catch (XPathExpressionException e) {
            throw new XmlParserException("Error parsing xml file: " + this.xmlFilePath, (Throwable)e);
        }
        return null;
    }
}

