/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.restcomm.connect.rvd.logging.system.RvdLoggers;
import org.restcomm.connect.rvd.utils.exceptions.ZipperException;

public class Zipper {
    static Logger logger = RvdLoggers.local;
    ZipOutputStream zipOut;
    File zipFile;

    public Zipper(File tempFile) throws ZipperException {
        this.zipFile = tempFile;
        try {
            this.zipOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
        }
        catch (FileNotFoundException e) {
            throw new ZipperException("Error creating zip " + this.zipFile, (Throwable)e);
        }
    }

    public void addDirectory(String name) throws ZipperException {
        try {
            this.zipOut.putNextEntry(new ZipEntry(name));
            this.zipOut.closeEntry();
        }
        catch (IOException e) {
            throw new ZipperException("Error adding directory " + name + " to zip " + this.zipFile, (Throwable)e);
        }
    }

    public void addFile(String filepath, InputStream fileStream) throws ZipperException {
        try {
            this.zipOut.putNextEntry(new ZipEntry(filepath));
            IOUtils.copy((InputStream)fileStream, (OutputStream)this.zipOut);
            this.zipOut.closeEntry();
        }
        catch (IOException e) {
            throw new ZipperException("Error adding file " + filepath + " to zip " + this.zipFile, (Throwable)e);
        }
    }

    public void addFileContent(String filepath, String fileContent) throws ZipperException {
        try {
            this.zipOut.putNextEntry(new ZipEntry(filepath));
            IOUtils.write((String)fileContent, (OutputStream)this.zipOut, (String)"UTF-8");
            this.zipOut.closeEntry();
        }
        catch (IOException e) {
            throw new ZipperException("Error adding string content to zip " + this.zipFile, (Throwable)e);
        }
    }

    public void addDirectoryRecursively(String dirpath, boolean includeRoot) throws ZipperException {
        File dir = new File(dirpath);
        if (dir.exists() && dir.isDirectory()) {
            String dirName = dir.getName();
            String dirParent = dir.getParent();
            if (includeRoot) {
                this.addDirectory(dirName + "/");
                this.addNestedDirectoryContents(dirParent + "/", dirName);
            } else {
                this.addNestedDirectoryContents(dirParent + "/" + dirName, "");
            }
        } else {
            throw new ZipperException(dirpath + " is not a directory or does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNestedDirectoryContents(String rootPath, String childPath) throws ZipperException {
        File[] childrenFiles;
        String nestedPath = rootPath + childPath;
        File dir = new File(nestedPath);
        assert (dir.isDirectory());
        for (File file : childrenFiles = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) {
            if (file.isDirectory()) {
                this.addDirectory(childPath + "/" + file.getName() + "/");
                this.addNestedDirectoryContents(rootPath, childPath + "/" + file.getName());
                continue;
            }
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.addFile(childPath + "/" + file.getName(), (InputStream)inputStream);
            }
            catch (FileNotFoundException e) {
                throw new ZipperException("Error adding file " + file + " to zip", (Throwable)e);
            }
            catch (IOException e) {
                throw new ZipperException("Error closingfile " + file + " after adding it to zip", (Throwable)e);
            }
        }
    }

    public void finish() {
        try {
            this.zipOut.finish();
        }
        catch (IOException e) {
            logger.log((Priority)Level.WARN, (Object)("Error closing Zipper " + this.zipFile + ". There is nothing more that can be done."), (Throwable)e);
        }
    }
}

