/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.restcomm.connect.rvd.ApplicationContext;
import org.restcomm.connect.rvd.ProjectApplicationsApi;
import org.restcomm.connect.rvd.exceptions.AccessApiException;
import org.restcomm.connect.rvd.exceptions.ApplicationAlreadyExists;
import org.restcomm.connect.rvd.exceptions.ApplicationApiNotSynchedException;
import org.restcomm.connect.rvd.exceptions.ApplicationsApiSyncException;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.restcomm.RestcommApplicationResponse;
import org.restcomm.connect.rvd.restcomm.RestcommClient;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class ProjectApplicationsApi {
    private UserIdentityContext identity;
    private ApplicationContext appContext;
    private Gson gson;

    public ProjectApplicationsApi(UserIdentityContext identity, ApplicationContext appContext) {
        this.identity = identity;
        this.appContext = appContext;
        this.gson = new Gson();
    }

    public String createApplication(String friendlyName, String projectKind) throws ApplicationsApiSyncException, UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FriendlyName", friendlyName);
        params.put("Kind", projectKind);
        String applicationSid = this.accessApi(params, AccessApiAction.CREATE);
        String rcmlUrl = "/restcomm-rvd/services/apps/" + applicationSid + "/controller";
        params.clear();
        params.put("Sid", applicationSid);
        params.put("RcmlUrl", rcmlUrl);
        this.updateApplication(applicationSid, null, rcmlUrl, null);
        return applicationSid;
    }

    public void rollbackCreateApplication(String applicationSid) throws ApplicationsApiSyncException {
        this.removeApplication(applicationSid);
    }

    public void renameApplication(String applicationSid, String newName) throws ApplicationsApiSyncException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sid", applicationSid);
        params.put("NewFriendlyName", newName);
        this.accessApi(params, AccessApiAction.RENAME);
    }

    public void removeApplication(String applicationSid) throws ApplicationsApiSyncException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sid", applicationSid);
        this.accessApi(params, AccessApiAction.DELETE);
    }

    public void updateApplication(String applicationSid, String friendlyName, String rcmlUrl, String kind) throws ApplicationsApiSyncException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sid", applicationSid);
        if (friendlyName != null && !friendlyName.isEmpty()) {
            params.put("FriendlyName", friendlyName);
        }
        if (kind != null && !kind.isEmpty()) {
            params.put("Kind", kind);
        }
        if (rcmlUrl != null && !rcmlUrl.isEmpty()) {
            params.put("RcmlUrl", rcmlUrl);
        }
        this.accessApi(params, AccessApiAction.UPDATE);
    }

    /*
     * Unable to fully structure code
     */
    private String accessApi(HashMap<String, String> params, AccessApiAction action) throws ApplicationsApiSyncException {
        try {
            restcommBaseUri = this.appContext.getConfiguration().getRestcommBaseUri();
            if (RvdUtils.isEmpty((String)this.identity.getEffectiveAuthorizationHeader())) {
                throw new ApplicationsApiSyncException("Could not determine credentials to access API.");
            }
            client = new RestcommClient(restcommBaseUri, this.identity.getEffectiveAuthorizationHeader(), this.appContext.getHttpClientBuilder());
            accountSid = this.identity.getAccountInfo().getSid();
            applicationResponse = null;
            switch (1.$SwitchMap$org$restcomm$connect$rvd$ProjectApplicationsApi$AccessApiAction[action.ordinal()]) {
                case 1: {
                    applicationSid = params.get("Sid");
                    try {
                        applicationResponse = (RestcommApplicationResponse)client.get("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + applicationSid + ".json").done(this.gson, RestcommApplicationResponse.class);
                    }
                    catch (RestcommClient.RestcommClientException e) {
                        if (e.getStatusCode() == 404) {
                            return null;
                        }
                        throw e;
                    }
                    applicationSid = applicationResponse.getSid();
                    if (applicationSid == null) {
                        throw new ApplicationsApiSyncException("Invalid Application sid obtained from API response.");
                    }
                    client.delete("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + applicationSid + ".json").done(this.gson, RestcommApplicationResponse.class);
                    return null;
                }
                case 2: {
                    applicationResponse = (RestcommApplicationResponse)client.post("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications.json").addParams(params).done(this.gson, RestcommApplicationResponse.class);
                    if (applicationResponse.getSid() == null) {
                        throw new ApplicationsApiSyncException("Invalid Application sid obtained from API response.");
                    }
                    return applicationResponse.getSid();
                }
                case 3: {
                    newFriendlyName = String.valueOf(params.get("NewFriendlyName"));
                    newNameTemp = RvdUtils.myUrlEncode((String)newFriendlyName);
                    try {
                        applicationResponse = (RestcommApplicationResponse)client.get("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + newNameTemp + ".json").done(this.gson, RestcommApplicationResponse.class);
                    }
                    catch (RestcommClient.RestcommClientException e) {
                        if (e.getStatusCode() == 404) ** GOTO lbl38
                        throw e;
                    }
lbl38:
                    // 2 sources

                    if (applicationResponse != null) {
                        throw new ApplicationAlreadyExists();
                    }
                    applicationSid = params.get("Sid");
                    try {
                        applicationResponse = (RestcommApplicationResponse)client.get("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + applicationSid + ".json").done(this.gson, RestcommApplicationResponse.class);
                    }
                    catch (RestcommClient.RestcommClientException e) {
                        if (e.getStatusCode() == 404) {
                            throw new ApplicationApiNotSynchedException("Cannot rename project '" + applicationSid + "'. The project was not found as restcomm Application.", (Throwable)e);
                        }
                        throw e;
                    }
                    applicationSid = applicationResponse.getSid();
                    if (applicationSid == null) {
                        throw new ApplicationsApiSyncException("Invalid Application sid obtained from API response.");
                    }
                    applicationResponse = (RestcommApplicationResponse)client.post("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + applicationSid + ".json").addParam("FriendlyName", newFriendlyName).done(this.gson, RestcommApplicationResponse.class);
                    if (!applicationResponse.getFriendly_name().equalsIgnoreCase(newFriendlyName)) {
                        throw new ApplicationsApiSyncException("Fail to change the name through the API.");
                    }
                }
                case 4: {
                    applicationSid = params.get("Sid");
                    try {
                        applicationResponse = (RestcommApplicationResponse)client.get("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + applicationSid + ".json").done(this.gson, RestcommApplicationResponse.class);
                    }
                    catch (RestcommClient.RestcommClientException e) {
                        if (e.getStatusCode() == 404) {
                            return null;
                        }
                        throw e;
                    }
                    applicationSid = applicationResponse.getSid();
                    if (applicationSid == null) {
                        throw new ApplicationsApiSyncException("Invalid Application sid obtained from API response.");
                    }
                    client.post("/restcomm/2012-04-24/Accounts/" + accountSid + "/Applications/" + applicationSid + ".json").addParams(params).done(this.gson, RestcommApplicationResponse.class);
                    return null;
                }
            }
            return null;
        }
        catch (AccessApiException e) {
            if (e.getStatusCode() != null && e.getStatusCode() == 409) {
                throw new ApplicationAlreadyExists();
            }
            throw new ApplicationsApiSyncException(e.getMessage(), (Throwable)e).setStatusCode(e.getStatusCode());
        }
        catch (ApplicationsApiSyncException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationsApiSyncException(e.getMessage(), (Throwable)e);
        }
    }
}

