/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.BuildService;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.InvalidServiceParameters;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.project.ProjectException;
import org.restcomm.connect.rvd.exceptions.project.UnsupportedProjectVersion;
import org.restcomm.connect.rvd.jsonvalidation.ProjectValidator;
import org.restcomm.connect.rvd.jsonvalidation.ValidationResult;
import org.restcomm.connect.rvd.jsonvalidation.exceptions.ValidationException;
import org.restcomm.connect.rvd.jsonvalidation.exceptions.ValidationFrameworkException;
import org.restcomm.connect.rvd.model.client.ProjectItem;
import org.restcomm.connect.rvd.model.client.ProjectState;
import org.restcomm.connect.rvd.model.client.StateHeader;
import org.restcomm.connect.rvd.model.client.WavItem;
import org.restcomm.connect.rvd.model.project.RvdProject;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.BadProjectHeader;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.storage.exceptions.WavItemDoesNotExist;
import org.restcomm.connect.rvd.upgrade.UpgradeService;
import org.restcomm.connect.rvd.utils.RvdUtils;
import org.restcomm.connect.rvd.utils.Unzipper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectService {
    static final Logger logger = Logger.getLogger((String)ProjectService.class.getName());
    private ServletContext servletContext;
    RvdConfiguration settings;
    RvdContext rvdContext;
    WorkspaceStorage workspaceStorage;

    public ProjectService(RvdContext rvdContext, WorkspaceStorage workspaceStorage) {
        this.rvdContext = rvdContext;
        this.servletContext = rvdContext.getServletContext();
        this.settings = rvdContext.getSettings();
        this.workspaceStorage = workspaceStorage;
    }

    public ProjectService() {
    }

    public String buildStartUrl(String projectName) throws ProjectException {
        URI uri;
        String path = this.servletContext.getContextPath() + "/" + "services" + "/apps/" + projectName + "/controller";
        try {
            uri = new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new ProjectException("Error building startUrl for project " + projectName, (Throwable)e);
        }
        return uri.getRawPath();
    }

    public void fillStartUrlsForProjects(List<ProjectItem> items, HttpServletRequest httpRequest) throws ProjectException {
        for (ProjectItem item : items) {
            item.setStartUrl(this.buildStartUrl(item.getName()));
        }
    }

    public List<ProjectItem> getAvailableProjectsByOwner(String ownerFilter) throws StorageException {
        ArrayList<ProjectItem> items = new ArrayList<ProjectItem>();
        for (String entry : FsProjectStorage.listProjectNames((WorkspaceStorage)this.workspaceStorage)) {
            String kind = "voice";
            String owner = null;
            ProjectItem item = new ProjectItem();
            item.setName(entry);
            try {
                StateHeader header = FsProjectStorage.loadStateHeader((String)entry, (WorkspaceStorage)this.workspaceStorage);
                item.setStatus(ProjectService.projectStatus((StateHeader)header));
                kind = header.getProjectKind();
                owner = header.getOwner();
            }
            catch (BadProjectHeader e) {
                JsonParser parser = new JsonParser();
                JsonObject root_element = parser.parse(FsProjectStorage.loadProjectString((String)entry, (WorkspaceStorage)this.workspaceStorage)).getAsJsonObject();
                JsonElement projectKind_element = root_element.get("projectKind");
                if (projectKind_element != null) {
                    kind = projectKind_element.getAsString();
                }
                item.setStatus(Status.BAD);
            }
            if (ownerFilter != null) {
                if (owner != null && !owner.equals(ownerFilter)) continue;
                item.setKind(kind);
                items.add(item);
                continue;
            }
            item.setKind(kind);
            items.add(item);
        }
        return items;
    }

    static Status projectStatus(StateHeader header) {
        if (header == null || header.getVersion() == null) {
            return Status.BAD;
        }
        try {
            UpgradeService.UpgradabilityStatus upgradable = UpgradeService.checkUpgradability((String)header.getVersion(), (String)RvdConfiguration.getRvdProjectVersion());
            if (upgradable == UpgradeService.UpgradabilityStatus.NOT_NEEDED) {
                return Status.OK;
            }
            if (upgradable == UpgradeService.UpgradabilityStatus.UPGRADABLE) {
                return Status.SHOULD_UPGRADE;
            }
            if (upgradable == UpgradeService.UpgradabilityStatus.NOT_SUPPORTED) {
                return Status.UNKNOWN_VERSION;
            }
            return Status.BAD;
        }
        catch (Exception e) {
            return Status.UNKNOWN_VERSION;
        }
    }

    public ProjectState createProject(String projectName, String kind, String owner) throws StorageException, InvalidServiceParameters {
        if (!("voice".equals(kind) || "ussd".equals(kind) || "sms".equals(kind))) {
            throw new InvalidServiceParameters("Invalid project kind specified - '" + kind + "'");
        }
        ProjectState state = null;
        if ("voice".equals(kind)) {
            state = ProjectState.createEmptyVoice((String)owner);
        } else if ("ussd".equals(kind)) {
            state = ProjectState.createEmptyUssd((String)owner);
        } else if ("sms".equals(kind)) {
            state = ProjectState.createEmptySms((String)owner);
        }
        FsProjectStorage.createProjectSlot((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        FsProjectStorage.storeProject((boolean)true, (ProjectState)state, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
        return state;
    }

    public ValidationResult validateProject(String stateData) throws RvdException {
        try {
            ProjectValidator validator = new ProjectValidator();
            ValidationResult result = validator.validate(stateData);
            return result;
        }
        catch (IOException e) {
            throw new RvdException("Internal error while validating raw project", (Throwable)e);
        }
        catch (ProcessingException e) {
            throw new ValidationFrameworkException("Error while validating raw project", (Throwable)e);
        }
    }

    public void updateProject(HttpServletRequest request, String projectName, ProjectState existingProject) throws RvdException {
        String stateData = null;
        try {
            stateData = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new RvdException("Internal error while retrieving raw project", (Throwable)e);
        }
        ValidationResult validationResult = this.validateProject(stateData);
        ProjectState state = (ProjectState)this.rvdContext.getMarshaler().toModel(stateData, ProjectState.class);
        ProjectService projectService = this;
        state.getHeader().setVersion(projectService.settings.getRvdProjectVersion());
        state.getHeader().setOwner(existingProject.getHeader().getOwner());
        FsProjectStorage.storeProject((boolean)false, (ProjectState)state, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
    }

    public void deleteProject(String projectName) throws ProjectDoesNotExist, StorageException {
        if (!FsProjectStorage.projectExists((String)projectName, (WorkspaceStorage)this.workspaceStorage)) {
            throw new ProjectDoesNotExist();
        }
        FsProjectStorage.deleteProject((String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }

    public InputStream archiveProject(String projectName) throws StorageException {
        return FsProjectStorage.archiveProject((String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }

    public void importProjectFromRawArchive(InputStream archiveStream, String applicationSid, String owner) throws RvdException {
        File tempProjectDir;
        File archiveFile = new File(applicationSid);
        String projectName = FilenameUtils.getBaseName((String)archiveFile.getName());
        try {
            tempProjectDir = RvdUtils.createTempDir();
        }
        catch (RvdException e) {
            throw new StorageException("Error importing project from archive. Cannot create temp directory for project: " + projectName, (Throwable)e);
        }
        Unzipper unzipper = new Unzipper(tempProjectDir);
        unzipper.unzip(archiveStream);
        this.importProject(tempProjectDir, applicationSid, owner);
    }

    public String importProject(File tempProjectDir, String suggestedName, String owner) throws RvdException {
        try {
            String stateFilename = tempProjectDir.getPath() + "/state";
            FileReader reader = new FileReader(stateFilename);
            JsonParser parser = new JsonParser();
            JsonElement rootElement = parser.parse((Reader)reader);
            String version = rootElement.getAsJsonObject().get("header").getAsJsonObject().get("version").getAsString();
            WorkspaceStorage tempStorage = new WorkspaceStorage(tempProjectDir.getParent(), this.rvdContext.getMarshaler());
            if (!UpgradeService.checkBackwardCompatible((String)version, (String)RvdConfiguration.getRvdProjectVersion())) {
                if (UpgradeService.checkUpgradability((String)version, (String)RvdConfiguration.getRvdProjectVersion()) == UpgradeService.UpgradabilityStatus.UPGRADABLE) {
                    UpgradeService upgradeService = new UpgradeService(tempStorage);
                    upgradeService.upgradeProject(tempProjectDir.getName());
                    BuildService buildService = new BuildService(tempStorage);
                    buildService.buildProject(tempProjectDir.getName());
                } else {
                    throw new UnsupportedProjectVersion("Imported project version (" + version + ") not supported");
                }
            }
            ProjectState state = FsProjectStorage.loadProject((String)tempProjectDir.getName(), (WorkspaceStorage)tempStorage);
            state.getHeader().setOwner(owner);
            FsProjectStorage.storeProject((boolean)false, (ProjectState)state, (String)tempProjectDir.getName(), (WorkspaceStorage)tempStorage);
            suggestedName = FsProjectStorage.getAvailableProjectName((String)suggestedName, (WorkspaceStorage)this.workspaceStorage);
            FsProjectStorage.createProjectSlot((String)suggestedName, (WorkspaceStorage)this.workspaceStorage);
            FsProjectStorage.importProjectFromDirectory((File)tempProjectDir, (String)suggestedName, (boolean)true, (WorkspaceStorage)this.workspaceStorage);
            String string = suggestedName;
            return string;
        }
        catch (UnsupportedProjectVersion e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("Error importing project from archive.", (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempProjectDir);
        }
    }

    public void addWavToProject(String projectName, String wavName, InputStream wavStream) throws StorageException {
        FsProjectStorage.storeWav((String)projectName, (String)wavName, (InputStream)wavStream, (WorkspaceStorage)this.workspaceStorage);
    }

    public List<WavItem> getWavs(String appName) throws StorageException {
        return FsProjectStorage.listWavs((String)appName, (WorkspaceStorage)this.workspaceStorage);
    }

    public void removeWavFromProject(String projectName, String wavName) throws WavItemDoesNotExist {
        FsProjectStorage.deleteWav((String)projectName, (String)wavName, (WorkspaceStorage)this.workspaceStorage);
    }

    public RvdProject load(String projectName) throws RvdException {
        String projectJson = FsProjectStorage.loadProjectString((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        RvdProject project = RvdProject.fromJson((String)projectName, (String)projectJson);
        return project;
    }
}

