/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.packaging.PackagingException;
import org.restcomm.connect.rvd.exceptions.project.UnsupportedProjectVersion;
import org.restcomm.connect.rvd.exceptions.ras.RestcommAppAlreadyExists;
import org.restcomm.connect.rvd.exceptions.ras.UnsupportedRasApplicationVersion;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.RappItem;
import org.restcomm.connect.rvd.model.client.WavItem;
import org.restcomm.connect.rvd.model.packaging.Rapp;
import org.restcomm.connect.rvd.model.packaging.RappBinaryInfo;
import org.restcomm.connect.rvd.model.packaging.RappConfig;
import org.restcomm.connect.rvd.model.packaging.RappInfo;
import org.restcomm.connect.rvd.model.project.RvdProject;
import org.restcomm.connect.rvd.storage.FsPackagingStorage;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.upgrade.UpgradeService;
import org.restcomm.connect.rvd.utils.RvdUtils;
import org.restcomm.connect.rvd.utils.Unzipper;
import org.restcomm.connect.rvd.utils.Zipper;
import org.restcomm.connect.rvd.validation.ValidationReport;
import org.restcomm.connect.rvd.validation.exceptions.RvdValidationException;

public class RasService {
    static final Logger logger = Logger.getLogger((String)RasService.class.getName());
    ModelMarshaler marshaler;
    WorkspaceStorage workspaceStorage;

    public RasService(RvdContext rvdContext, WorkspaceStorage workspaceStorage) {
        this.marshaler = rvdContext.getMarshaler();
        this.workspaceStorage = workspaceStorage;
    }

    public RappConfig toModel(Class<RappConfig> clazz, String data) {
        Gson gson = new Gson();
        RappConfig rappConfig = (RappConfig)gson.fromJson(data, RappConfig.class);
        return rappConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createZipPackage(RvdProject project) throws RvdException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating zip package for project " + project.getName()));
        }
        String projectName = project.getName();
        Gson gson = new Gson();
        XStream xstream = this.marshaler.getXStream();
        xstream.alias("restcommApplication", RappInfo.class);
        Rapp rapp = FsPackagingStorage.loadRapp((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        String configData = gson.toJson((Object)rapp.getConfig());
        String infoData = xstream.toXML((Object)rapp.getInfo());
        try {
            File tempFile = File.createTempFile("rapp", ".tmp");
            Zipper zipper = new Zipper(tempFile);
            try {
                zipper.addDirectory("/app/");
                zipper.addFileContent("/app/info.xml", infoData);
                zipper.addFileContent("/app/config", configData);
                zipper.addDirectory("/app/rvd/");
                zipper.addFileContent("/app/rvd/state", this.marshaler.toData((Object)project.getState()));
                if (project.supportsWavs()) {
                    zipper.addDirectory("/app/rvd/wavs/");
                    for (WavItem wavItem : FsProjectStorage.listWavs((String)projectName, (WorkspaceStorage)this.workspaceStorage)) {
                        try (InputStream wavStream = FsProjectStorage.getWav((String)projectName, (String)wavItem.getFilename(), (WorkspaceStorage)this.workspaceStorage);){
                            zipper.addFile("app/rvd/wavs/" + wavItem.getFilename(), wavStream);
                        }
                    }
                }
            }
            finally {
                zipper.finish();
            }
            FsPackagingStorage.storeRappBinary((File)tempFile, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Zip package created for project " + projectName));
            }
            return FsPackagingStorage.getRappBinary((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        }
        catch (IOException e) {
            throw new PackagingException("Error creating temporaty zip file ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importAppToWorkspace(String applicationSid, InputStream packageZipStream, String loggedUser, ProjectService projectService) throws RvdException {
        String newProjectName;
        File tempDir = RvdUtils.createTempDir();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unzipping ras package to temporary directory " + tempDir.getPath()));
        }
        Unzipper unzipper = new Unzipper(tempDir);
        unzipper.unzip(packageZipStream);
        try {
            int runtimePackageVersion;
            RappInfo info = (RappInfo)this.workspaceStorage.loadModelFromXMLFile(tempDir.getPath() + "/app/" + "info.xml", RappInfo.class);
            RappConfig config = (RappConfig)this.workspaceStorage.loadModelFromFile(tempDir.getPath() + "/app/" + "config", RappConfig.class);
            if (!UpgradeService.checkBackwardCompatible((String)info.getRvdAppVersion(), (String)RvdConfiguration.getRvdProjectVersion()) && UpgradeService.checkUpgradability((String)info.getRvdAppVersion(), (String)RvdConfiguration.getRvdProjectVersion()) != UpgradeService.UpgradabilityStatus.UPGRADABLE) {
                throw new UnsupportedProjectVersion("Project version " + info.getRvdAppVersion() + " is not supported");
            }
            int effectivePackageVersion = 1;
            if (info.getRasVersion() != null) {
                try {
                    effectivePackageVersion = Integer.parseInt(info.getRasVersion());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((runtimePackageVersion = Integer.parseInt(RvdConfiguration.getRasApplicationVersion())) < effectivePackageVersion) {
                throw new UnsupportedRasApplicationVersion("Incompatible application package. Version " + effectivePackageVersion + " is not supported");
            }
            List rappItems = FsProjectStorage.listRapps((List)FsProjectStorage.listProjectNames((WorkspaceStorage)this.workspaceStorage), (WorkspaceStorage)this.workspaceStorage, (ProjectService)projectService);
            for (RappItem rappItem : rappItems) {
                if (rappItem.getRappInfo() == null || rappItem.getRappInfo().getId() == null || !rappItem.getRappInfo().getId().equals(info.getId())) continue;
                throw new RestcommAppAlreadyExists("A restcomm application with id " + rappItem.getRappInfo().getId() + "  already exists. Cannot import " + info.getName() + " app");
            }
            File tempProjectDir = new File(tempDir.getPath() + "/app/rvd");
            projectService.importProject(tempProjectDir, applicationSid, loggedUser);
            newProjectName = info.getName();
            Rapp rapp = new Rapp(info, config);
            FsProjectStorage.storeRapp((Rapp)rapp, (String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
        return newProjectName;
    }

    public void saveApp(Rapp rapp, String projectName) throws RvdValidationException, StorageException {
        ValidationReport report = rapp.validate();
        if (!report.isOk()) {
            throw new RvdValidationException("Cannot validate rapp", report);
        }
        rapp.getInfo().setRasVersion(RvdConfiguration.getRasApplicationVersion());
        rapp.getInfo().setRvdAppVersion(RvdConfiguration.getRvdProjectVersion());
        Rapp existingRapp = FsPackagingStorage.loadRapp((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        rapp.getInfo().setId(existingRapp.getInfo().getId());
        FsPackagingStorage.storeRapp((Rapp)rapp, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }

    public void createApp(Rapp rapp, String projectName) throws RvdValidationException, StorageException {
        ValidationReport report = rapp.validate();
        if (!report.isOk()) {
            throw new RvdValidationException("Cannot validate rapp", report);
        }
        rapp.getInfo().setRasVersion(RvdConfiguration.getRasApplicationVersion());
        rapp.getInfo().setRvdAppVersion(RvdConfiguration.getRvdProjectVersion());
        FsPackagingStorage.storeRapp((Rapp)rapp, (String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }

    public Rapp getApp(String projectName) throws StorageException {
        return FsPackagingStorage.loadRapp((String)projectName, (WorkspaceStorage)this.workspaceStorage);
    }

    public RappConfig getRappConfig(String projectName) throws StorageException {
        Rapp rapp = FsProjectStorage.loadRapp((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        return rapp.getConfig();
    }

    public RappBinaryInfo getBinaryInfo(String projectName) {
        RappBinaryInfo binaryInfo = new RappBinaryInfo();
        binaryInfo.setExists(FsPackagingStorage.binaryAvailable((String)projectName, (WorkspaceStorage)this.workspaceStorage));
        return binaryInfo;
    }

    protected String generateAppId(String projectName) {
        String id = UUID.randomUUID().toString();
        return id;
    }
}

