/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.commons.http.SslMode;
import org.restcomm.connect.rvd.configuration.RestcommConfig;
import org.restcomm.connect.rvd.exceptions.RestcommConfigNotFound;
import org.restcomm.connect.rvd.exceptions.RestcommConfigurationException;
import org.restcomm.connect.rvd.http.utils.UriUtils;
import org.restcomm.connect.rvd.model.RvdConfig;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class RvdConfiguration {
    static final Logger logger = Logger.getLogger((String)RvdConfiguration.class.getName());
    private static RvdConfiguration instance = null;
    private static final String WORKSPACE_DIRECTORY_NAME = "workspace";
    public static final String PROTO_DIRECTORY_PREFIX = "_proto";
    public static final String REST_SERVICES_PATH = "services";
    public static final String USERS_DIRECTORY_NAME = "@users";
    public static final String WAVS_DIRECTORY_NAME = "wavs";
    private static final String RVD_PROJECT_VERSION = "1.6";
    private static final String PACKAGING_VERSION = "1.0";
    private static final String RAS_APPLICATION_VERSION = "2";
    public static final String STICKY_PREFIX = "sticky_";
    public static final String MODULE_PREFIX = "module_";
    public static final String CORE_VARIABLE_PREFIX = "core_";
    public static final String PACKAGING_DIRECTORY_NAME = "packaging";
    public static final String TICKET_COOKIE_NAME = "rvdticket";
    private static Set<String> restcommParameterNames = new HashSet<String>(Arrays.asList("CallSid", "AccountSid", "From", "To", "Body", "CallStatus", "ApiVersion", "Direction", "CallerName", "CallTimestamp", "ForwardedFrom"));
    public static final String PROJECT_LOG_FILENAME = "projectLog";
    public static final String DEFAULT_APPSTORE_DOMAIN = "apps.restcomm.com";
    public static final HashSet<String> builtinRestcommParameters = new HashSet<String>(Arrays.asList("CallSid", "AccountSid", "From", "To", "Body", "CallStatus", "ApiVersion", "Direction", "CallerName", "CallTimestamp", "ForwardedFrom"));
    public static final String RESTCOMM_HEADER_PREFIX = "SipHeader_";
    public static final String RESTCOMM_HEADER_PREFIX_DIAL = "DialSipHeader_";
    private String workspaceBasePath;
    private RvdConfig rvdConfig;
    private RestcommConfig restcommConfig;
    private String contextRootPath;
    private URI restcommBaseUri;

    RvdConfiguration() {
    }

    public RvdConfiguration(ServletContext servletContext) {
        this.contextRootPath = servletContext.getRealPath("/");
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contextRootPath: " + this.contextRootPath));
        }
        this.load();
    }

    public RvdConfiguration(String contextRootPath) {
        this.contextRootPath = contextRootPath;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contextRootPath: " + contextRootPath));
        }
        this.load();
    }

    private void load() {
        this.rvdConfig = this.loadRvdXmlConfig(this.contextRootPath + "WEB-INF/rvd.xml");
        String workspaceBasePath = this.contextRootPath + WORKSPACE_DIRECTORY_NAME;
        if (this.rvdConfig.getWorkspaceLocation() != null && !"".equals(this.rvdConfig.getWorkspaceLocation())) {
            workspaceBasePath = this.rvdConfig.getWorkspaceLocation().startsWith("/") ? this.rvdConfig.getWorkspaceLocation() : this.contextRootPath + this.rvdConfig.getWorkspaceLocation();
        }
        this.workspaceBasePath = workspaceBasePath;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Using workspace at " + workspaceBasePath));
        }
        try {
            this.restcommConfig = this.loadRestcommXmlConfig(this.contextRootPath + "../restcomm.war/WEB-INF/conf/restcomm.xml");
        }
        catch (RestcommConfigNotFound e) {
            try {
                this.restcommConfig = this.loadRestcommXmlConfig(this.contextRootPath + "WEB-INF/restcomm.xml");
            }
            catch (RestcommConfigNotFound restcommConfigNotFound) {
                this.restcommConfig = null;
                logger.error((Object)"Could not load restcomm configuration.");
            }
        }
    }

    private RvdConfig loadRvdXmlConfig(String pathToXml) {
        try {
            FileInputStream input = new FileInputStream(pathToXml);
            XStream xstream = new XStream();
            xstream.alias("rvd", RvdConfig.class);
            this.rvdConfig = (RvdConfig)xstream.fromXML((InputStream)input);
            return this.rvdConfig;
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)("RVD configuration file not found: " + pathToXml));
            return null;
        }
    }

    private RestcommConfig loadRestcommXmlConfig(String pathToXml) throws RestcommConfigNotFound {
        try {
            RestcommConfig restcommConfig = new RestcommConfig(pathToXml);
            return restcommConfig;
        }
        catch (RestcommConfigNotFound e) {
            throw e;
        }
        catch (RestcommConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getWorkspaceBasePath() {
        return this.workspaceBasePath;
    }

    public String getProjectBasePath(String projectName) {
        return this.workspaceBasePath + File.separator + projectName;
    }

    public static String getRvdProjectVersion() {
        return RVD_PROJECT_VERSION;
    }

    public static String getPackagingVersion() {
        return PACKAGING_VERSION;
    }

    public static String getRasApplicationVersion() {
        return RAS_APPLICATION_VERSION;
    }

    public static Set<String> getRestcommParameterNames() {
        return restcommParameterNames;
    }

    public SslMode getSslMode() {
        return this.restcommConfig.getSslMode();
    }

    public boolean getUseHostnameToResolveRelativeUrl() {
        return this.restcommConfig.isUseHostnameToResolveRelativeUrl();
    }

    public String getHostnameOverride() {
        return this.restcommConfig.getHostname();
    }

    public URI getRestcommBaseUri() {
        if (this.restcommBaseUri == null) {
            String rawUrl = this.rvdConfig.getRestcommBaseUrl();
            if (!RvdUtils.isEmpty((String)rawUrl)) {
                try {
                    URI uri = new URI(rawUrl);
                    if (!RvdUtils.isEmpty((String)uri.getScheme()) && !RvdUtils.isEmpty((String)uri.getHost())) {
                        this.restcommBaseUri = uri;
                    }
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            if (this.restcommBaseUri == null) {
                UriUtils uriUtils = new UriUtils(this);
                try {
                    URI uri = new URI("/");
                    this.restcommBaseUri = uriUtils.resolve(uri);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Using Restcomm server at " + this.restcommBaseUri.toString()));
            }
        }
        return this.restcommBaseUri;
    }

    public String getAuthServerUrl() {
        if (this.restcommConfig != null && !RvdUtils.isEmpty((String)this.restcommConfig.getAuthServerUrl())) {
            return this.restcommConfig.getAuthServerUrl();
        }
        return null;
    }

    public String getRealm() {
        if (this.restcommConfig != null) {
            return this.restcommConfig.getRealm();
        }
        return null;
    }

    public String getRealmPublicKey() {
        if (this.restcommConfig != null) {
            return this.restcommConfig.getRealmPublicKey();
        }
        return null;
    }

    public boolean keycloakEnabled() {
        return this.getAuthServerUrl() != null;
    }

    public String getApplicationsRelativeUrl() {
        return "/restcomm-rvd/services/apps";
    }

    void setRestcommBaseUri(URI uri) {
        this.restcommBaseUri = uri;
    }
}

