/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.BuildService;
import org.restcomm.connect.rvd.ProjectApplicationsApi;
import org.restcomm.connect.rvd.ProjectService;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.RvdContext;
import org.restcomm.connect.rvd.exceptions.ApplicationAlreadyExists;
import org.restcomm.connect.rvd.exceptions.ApplicationApiNotSynchedException;
import org.restcomm.connect.rvd.exceptions.ApplicationsApiSyncException;
import org.restcomm.connect.rvd.exceptions.IncompatibleProjectVersion;
import org.restcomm.connect.rvd.exceptions.InvalidServiceParameters;
import org.restcomm.connect.rvd.exceptions.ProjectDoesNotExist;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.project.ProjectException;
import org.restcomm.connect.rvd.exceptions.project.UnsupportedProjectVersion;
import org.restcomm.connect.rvd.http.RvdResponse;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.jsonvalidation.exceptions.ValidationException;
import org.restcomm.connect.rvd.model.CallControlInfo;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.ProjectSettings;
import org.restcomm.connect.rvd.model.client.ProjectState;
import org.restcomm.connect.rvd.model.client.StateHeader;
import org.restcomm.connect.rvd.storage.FsCallControlInfoStorage;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.BadWorkspaceDirectoryStructure;
import org.restcomm.connect.rvd.storage.exceptions.ProjectAlreadyExists;
import org.restcomm.connect.rvd.storage.exceptions.StorageEntityNotFound;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.storage.exceptions.WavItemDoesNotExist;
import org.restcomm.connect.rvd.upgrade.UpgradeService;
import org.restcomm.connect.rvd.upgrade.exceptions.UpgradeException;
import org.restcomm.connect.rvd.utils.RvdUtils;

@Path(value="projects")
public class ProjectRestService
extends SecuredRestService {
    static final Logger logger = Logger.getLogger((String)ProjectRestService.class.getName());
    @Context
    HttpServletRequest request;
    private ProjectService projectService;
    private RvdConfiguration rvdSettings;
    private ProjectState activeProject;
    private ModelMarshaler marshaler;
    private WorkspaceStorage workspaceStorage;
    RvdContext rvdContext;

    @PostConstruct
    public void init() {
        super.init();
        this.rvdContext = new RvdContext(this.request, this.servletContext, this.applicationContext.getConfiguration());
        this.rvdSettings = this.rvdContext.getSettings();
        this.marshaler = this.rvdContext.getMarshaler();
        this.workspaceStorage = new WorkspaceStorage(this.rvdSettings.getWorkspaceBasePath(), this.marshaler);
        this.projectService = new ProjectService(this.rvdContext, this.workspaceStorage);
    }

    public ProjectRestService() {
    }

    ProjectRestService(UserIdentityContext context) {
        super(context);
    }

    void assertProjectAvailable(String projectName) throws StorageException, ProjectDoesNotExist {
        if (!FsProjectStorage.projectExists((String)projectName, (WorkspaceStorage)this.workspaceStorage)) {
            throw new ProjectDoesNotExist("Project " + projectName + " does not exist");
        }
        ProjectState project = FsProjectStorage.loadProject((String)projectName, (WorkspaceStorage)this.workspaceStorage);
        if (project.getHeader().getOwner() != null) {
            String loggedUser = this.getUserIdentityContext().getAccountUsername();
            if (loggedUser != null && loggedUser.equals(project.getHeader().getOwner())) {
                this.activeProject = project;
                return;
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.activeProject = project;
    }

    @GET
    @Produces(value={"application/json"})
    public Response listProjects(@Context HttpServletRequest request) {
        List items;
        this.secure();
        try {
            items = this.projectService.getAvailableProjectsByOwner(this.getLoggedUsername());
            this.projectService.fillStartUrlsForProjects(items, request);
        }
        catch (BadWorkspaceDirectoryStructure e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (ProjectException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson((Object)items), (String)"application/json").build();
    }

    @PUT
    @Path(value="{name}")
    public Response createProject(@PathParam(value="name") String name, @QueryParam(value="kind") String kind, @QueryParam(value="ticket") String ticket) {
        this.secure();
        ProjectApplicationsApi applicationsApi = null;
        String applicationSid = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating project " + name));
        }
        try {
            applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext);
            applicationSid = applicationsApi.createApplication(name, kind);
            ProjectState projectState = this.projectService.createProject(applicationSid, kind, this.getLoggedUsername());
            BuildService buildService = new BuildService(this.workspaceStorage);
            buildService.buildProject(applicationSid, projectState);
        }
        catch (ProjectAlreadyExists e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                applicationsApi.rollbackCreateApplication(applicationSid);
            }
            catch (ApplicationsApiSyncException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (StorageException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidServiceParameters e) {
            logger.error((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ApplicationAlreadyExists e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (ApplicationsApiSyncException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Gson gson = new Gson();
        JsonObject projectInfo = new JsonObject();
        projectInfo.addProperty("name", name);
        projectInfo.addProperty("sid", applicationSid);
        projectInfo.addProperty("kind", kind);
        return Response.ok((Object)gson.toJson((JsonElement)projectInfo), (String)"application/json").build();
    }

    @GET
    @Path(value="{applicationSid}/info")
    public Response projectInfo(@PathParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        this.assertProjectAvailable(applicationSid);
        StateHeader header = this.activeProject.getHeader();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.marshaler.getGson().toJson((Object)header)).type("application/json").build();
    }

    @POST
    @Path(value="{applicationSid}")
    public Response updateProject(@Context HttpServletRequest request, @PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (applicationSid != null && !applicationSid.equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Saving project " + applicationSid));
            }
            try {
                ProjectState existingProject = FsProjectStorage.loadProject((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
                if (this.getLoggedUsername().equals(existingProject.getHeader().getOwner()) || existingProject.getHeader().getOwner() == null) {
                    this.projectService.updateProject(request, applicationSid, existingProject);
                    return this.buildOkResponse();
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (ValidationException e) {
                RvdResponse rvdResponse = new RvdResponse().setValidationException(e);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)rvdResponse.asJson()).build();
            }
            catch (IncompatibleProjectVersion e) {
                logger.error((Object)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.asJson()).type("application/json").build();
            }
            catch (RvdException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return this.buildErrorResponse(Response.Status.OK, RvdResponse.Status.ERROR, e);
            }
        }
        logger.warn((Object)"Empty project name specified for updating");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="{applicationSid}/cc")
    public Response storeCcInfo(@PathParam(value="applicationSid") String applicationSid, @Context HttpServletRequest request) {
        this.secure();
        try {
            String data = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            CallControlInfo ccInfo = (CallControlInfo)this.marshaler.toModel(data, CallControlInfo.class);
            if (ccInfo != null) {
                FsCallControlInfoStorage.storeInfo((CallControlInfo)ccInfo, (String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            } else {
                FsCallControlInfoStorage.clearInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            }
            return Response.ok().build();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/cc")
    public Response getCcInfo(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            CallControlInfo ccInfo = FsCallControlInfoStorage.loadInfo((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)this.marshaler.toData((Object)ccInfo), (String)"application/json").build();
        }
        catch (StorageEntityNotFound e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="{applicationSid}/rename")
    public Response renameProject(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="newName") String projectNewName, @QueryParam(value="ticket") String ticket) throws StorageException, ProjectDoesNotExist {
        this.secure();
        if (!RvdUtils.isEmpty((String)applicationSid) && !RvdUtils.isEmpty((String)projectNewName)) {
            this.assertProjectAvailable(applicationSid);
            try {
                ProjectApplicationsApi applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext);
                try {
                    applicationsApi.renameApplication(applicationSid, projectNewName);
                }
                catch (ApplicationApiNotSynchedException e) {
                    logger.warn((Object)e.getMessage());
                }
                return Response.ok().build();
            }
            catch (ApplicationAlreadyExists e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            catch (ApplicationsApiSyncException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @PUT
    @Path(value="{applicationSid}/upgrade")
    public Response upgradeProject(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (!RvdUtils.isEmpty((String)applicationSid)) {
            try {
                UpgradeService upgradeService = new UpgradeService(this.workspaceStorage);
                upgradeService.upgradeProject(applicationSid);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("project '" + applicationSid + "' upgraded to version " + RvdConfiguration.getRvdProjectVersion()));
                }
                BuildService buildService = new BuildService(this.workspaceStorage);
                buildService.buildProject(applicationSid, this.activeProject);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("project '" + applicationSid + "' built"));
                }
                return Response.ok().build();
            }
            catch (StorageException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            catch (UpgradeException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.asJson()).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @DELETE
    @Path(value="{applicationSid}")
    public Response deleteProject(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="ticket") String ticket) throws ProjectDoesNotExist {
        this.secure();
        if (!RvdUtils.isEmpty((String)applicationSid)) {
            try {
                ProjectApplicationsApi applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext);
                applicationsApi.removeApplication(applicationSid);
                this.projectService.deleteProject(applicationSid);
                return Response.ok().build();
            }
            catch (StorageException e) {
                logger.error((Object)("Error deleting project '" + applicationSid + "'"), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            catch (ApplicationsApiSyncException e) {
                logger.error((Object)("Error deleting project '" + applicationSid + "' through the API"), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="{applicationSid}/archive")
    public Response downloadArchive(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="projectName") String projectName) throws StorageException, ProjectDoesNotExist, UnsupportedEncodingException, EncoderException {
        this.secure();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("downloading raw archive for project " + applicationSid));
        }
        this.assertProjectAvailable(applicationSid);
        try {
            InputStream archiveStream = this.projectService.archiveProject(applicationSid);
            String dispositionHeader = "attachment; filename*=UTF-8''" + RvdUtils.myUrlEncode((String)(projectName + ".zip"));
            return Response.ok((Object)archiveStream, (String)"application/zip").header("Content-Disposition", (Object)dispositionHeader).build();
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    @POST
    public Response importProjectArchive(@Context HttpServletRequest request, @QueryParam(value="ticket") String ticket) {
        this.secure();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Importing project from raw archive");
        }
        ProjectApplicationsApi applicationsApi = null;
        String applicationSid = null;
        try {
            if (request.getHeader("Content-Type") != null && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
                Gson gson = new Gson();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                JsonArray fileinfos = new JsonArray();
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    JsonObject fileinfo = new JsonObject();
                    fileinfo.addProperty("field", item.getFieldName());
                    if (item.getName() != null) {
                        String tempName = "RvdImport-" + UUID.randomUUID().toString().replace("-", "");
                        applicationsApi = new ProjectApplicationsApi(this.getUserIdentityContext(), this.applicationContext);
                        applicationSid = applicationsApi.createApplication(tempName, "");
                        String effectiveProjectName = null;
                        try {
                            this.projectService.importProjectFromRawArchive(item.openStream(), applicationSid, this.getLoggedUsername());
                            effectiveProjectName = FilenameUtils.getBaseName((String)item.getName());
                            String projectString = FsProjectStorage.loadProjectString((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
                            ProjectState state = (ProjectState)this.marshaler.toModel(projectString, ProjectState.class);
                            String projectKind = state.getHeader().getProjectKind();
                            applicationsApi.updateApplication(applicationSid, effectiveProjectName, null, projectKind);
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Successfully imported project '" + applicationSid + "' from raw archive '" + item.getName() + "'"));
                            }
                        }
                        catch (Exception e) {
                            applicationsApi.rollbackCreateApplication(applicationSid);
                            throw e;
                        }
                        fileinfo.addProperty("name", effectiveProjectName);
                        fileinfo.addProperty("id", applicationSid);
                    }
                    if (item.getName() == null) {
                        logger.warn((Object)"non-file part found in upload");
                        fileinfo.addProperty("value", this.read(item.openStream()));
                    }
                    fileinfos.add((JsonElement)fileinfo);
                }
                return Response.ok((Object)gson.toJson((JsonElement)fileinfos), (String)"application/json").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (UnsupportedProjectVersion | StorageException e) {
            logger.warn((Object)e, e);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, e);
            }
            return this.buildErrorResponse(Response.Status.BAD_REQUEST, RvdResponse.Status.ERROR, (RvdException)e);
        }
        catch (ApplicationAlreadyExists e) {
            logger.warn((Object)e, (Throwable)e);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, (Throwable)e);
            }
            try {
                applicationsApi.rollbackCreateApplication(applicationSid);
            }
            catch (ApplicationsApiSyncException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                return this.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, RvdResponse.Status.ERROR, (RvdException)((Object)e));
            }
            return this.buildErrorResponse(Response.Status.CONFLICT, RvdResponse.Status.ERROR, (RvdException)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}")
    @Produces(value={"application/json"})
    public Response openProject(@PathParam(value="applicationSid") String applicationSid, @Context HttpServletRequest request) throws StorageException, ProjectDoesNotExist {
        this.secure();
        this.assertProjectAvailable(applicationSid);
        return Response.ok().entity((Object)this.marshaler.toData((Object)this.activeProject)).build();
    }

    @POST
    @Path(value="{applicationSid}/wavs")
    public Response uploadWavFile(@PathParam(value="applicationSid") String applicationSid, @Context HttpServletRequest request) throws StorageException, ProjectDoesNotExist {
        this.secure();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"running /uploadwav");
        }
        this.assertProjectAvailable(applicationSid);
        try {
            if (request.getHeader("Content-Type") != null && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
                Gson gson = new Gson();
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                JsonArray fileinfos = new JsonArray();
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    JsonObject fileinfo = new JsonObject();
                    fileinfo.addProperty("fieldName", item.getFieldName());
                    if (item.getName() != null) {
                        this.projectService.addWavToProject(applicationSid, item.getName(), item.openStream());
                        fileinfo.addProperty("name", item.getName());
                    }
                    if (item.getName() == null) {
                        logger.warn((Object)"non-file part found in upload");
                        fileinfo.addProperty("value", this.read(item.openStream()));
                    }
                    fileinfos.add((JsonElement)fileinfo);
                }
                return Response.ok((Object)gson.toJson((JsonElement)fileinfos), (String)"application/json").build();
            }
            String json_response = "{\"result\":[{\"size\":" + this.size((InputStream)request.getInputStream()) + "}]}";
            return Response.ok((Object)json_response, (String)"application/json").build();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="{applicationSid}/wavs")
    public Response removeWavFile(@PathParam(value="applicationSid") String applicationSid, @QueryParam(value="filename") String wavname, @Context HttpServletRequest request) throws StorageException, ProjectDoesNotExist {
        this.secure();
        this.assertProjectAvailable(applicationSid);
        try {
            this.projectService.removeWavFromProject(applicationSid, wavname);
            return Response.ok().build();
        }
        catch (WavItemDoesNotExist e) {
            logger.warn((Object)("Cannot delete " + wavname + " from " + applicationSid + " app"));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/wavs")
    @Produces(value={"application/json"})
    public Response listWavs(@PathParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        this.assertProjectAvailable(applicationSid);
        try {
            List items = this.projectService.getWavs(applicationSid);
            Gson gson = new Gson();
            return Response.ok((Object)gson.toJson((Object)items), (String)"application/json").build();
        }
        catch (BadWorkspaceDirectoryStructure e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageException e) {
            logger.error((Object)("Error getting wav list for project '" + applicationSid + "'"), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/wavs/{filename}.wav")
    public Response getWavNoQueryParams(@PathParam(value="applicationSid") String applicationSid, @PathParam(value="filename") String filename) {
        try {
            InputStream wavStream = FsProjectStorage.getWav((String)applicationSid, (String)(filename + ".wav"), (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)wavStream, (String)"audio/x-wav").header("Content-Disposition", (Object)("attachment; filename = " + filename)).build();
        }
        catch (WavItemDoesNotExist e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="{applicationSid}/build")
    public Response buildProject(@PathParam(value="applicationSid") String applicationSid) throws StorageException, ProjectDoesNotExist {
        this.secure();
        this.assertProjectAvailable(applicationSid);
        BuildService buildService = new BuildService(this.workspaceStorage);
        try {
            buildService.buildProject(applicationSid, this.activeProject);
            return Response.ok().build();
        }
        catch (StorageException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="{applicationSid}/settings")
    public Response saveProjectSettings(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("saving project settings for " + applicationSid));
        }
        try {
            String data = IOUtils.toString((InputStream)this.request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            ProjectSettings projectSettings = (ProjectSettings)this.marshaler.toModel(data, ProjectSettings.class);
            FsProjectStorage.storeProjectSettings((ProjectSettings)projectSettings, (String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok().build();
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{applicationSid}/settings")
    public Response getProjectSettings(@PathParam(value="applicationSid") String applicationSid) {
        this.secure();
        try {
            ProjectSettings projectSettings = FsProjectStorage.loadProjectSettings((String)applicationSid, (WorkspaceStorage)this.workspaceStorage);
            return Response.ok((Object)this.marshaler.toData((Object)projectSettings)).build();
        }
        catch (StorageEntityNotFound e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (StorageException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

