/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.exceptions.AuthorizationException;
import org.restcomm.connect.rvd.http.RestService;
import org.restcomm.connect.rvd.identity.AccountProvider;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfoResponse;

public class SecuredRestService
extends RestService {
    private UserIdentityContext userIdentityContext;

    public void init() {
        super.init();
        RvdConfiguration config = this.applicationContext.getConfiguration();
        AccountProvider accountProvider = this.applicationContext.getAccountProvider();
        if (config.keycloakEnabled()) {
            throw new UnsupportedOperationException();
        }
        String authorizationHeader = this.request.getHeader("Authorization");
        this.userIdentityContext = new UserIdentityContext(authorizationHeader, accountProvider);
    }

    public SecuredRestService() {
    }

    SecuredRestService(UserIdentityContext context) {
        this.userIdentityContext = context;
    }

    public UserIdentityContext getUserIdentityContext() {
        return this.userIdentityContext;
    }

    protected void secure() {
        RestcommAccountInfoResponse account = this.userIdentityContext.getAccountInfo();
        if (account == null || !"active".equals(account.getStatus())) {
            throw new AuthorizationException();
        }
    }

    protected String getLoggedUsername() {
        return this.userIdentityContext.getAccountUsername();
    }
}

