/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.resources;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.http.resources.RasRestService;
import org.restcomm.connect.rvd.http.resources.SecuredRestService;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.UserProfile;
import org.restcomm.connect.rvd.model.client.SettingsModel;
import org.restcomm.connect.rvd.storage.FsProfileDao;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;

@Path(value="settings")
public class SettingsRestService
extends SecuredRestService {
    static final Logger logger = Logger.getLogger((String)RasRestService.class.getName());
    RvdConfiguration settings;
    ModelMarshaler marshaler;
    WorkspaceStorage workspaceStorage;

    @PostConstruct
    public void init() {
        super.init();
        this.settings = this.applicationContext.getConfiguration();
        this.marshaler = new ModelMarshaler();
        this.workspaceStorage = new WorkspaceStorage(this.settings.getWorkspaceBasePath(), this.marshaler);
    }

    public SettingsRestService() {
    }

    SettingsRestService(UserIdentityContext context) {
        super(context);
    }

    @POST
    public Response setProfile(@Context HttpServletRequest request) {
        this.secure();
        try {
            String data = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
            SettingsModel settingsForm = (SettingsModel)this.marshaler.toModel(data, SettingsModel.class);
            FsProfileDao profileDao = new FsProfileDao(this.workspaceStorage);
            String loggedUsername = this.getLoggedUsername();
            UserProfile profile = profileDao.loadUserProfile(loggedUsername);
            if (profile == null) {
                profile = new UserProfile();
            }
            profile.setUsername(settingsForm.getApiServerUsername());
            profile.setToken(settingsForm.getApiServerPass());
            profileDao.saveUserProfile(loggedUsername, profile);
            return Response.ok().build();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (JsonSyntaxException e) {
            logger.error((Object)e, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProfile() {
        this.secure();
        FsProfileDao profileDao = new FsProfileDao(this.workspaceStorage);
        String loggedUsername = this.getLoggedUsername();
        UserProfile profile = profileDao.loadUserProfile(loggedUsername);
        SettingsModel settingsForm = new SettingsModel();
        if (profile != null) {
            settingsForm.setApiServerUsername(profile.getUsername());
            settingsForm.setApiServerPass(profile.getToken());
        }
        Gson gson = new Gson();
        String data = gson.toJson((Object)settingsForm);
        return Response.ok((Object)data, (String)"application/json").build();
    }
}

