/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.http.utils;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.http.utils.HttpConnector;
import org.restcomm.connect.rvd.http.utils.HttpConnectorList;

public final class UriUtils {
    private static Logger logger = Logger.getLogger(UriUtils.class);
    private HttpConnector httpConnector;
    private HttpConnectorList httpConnectorList;
    private RvdConfiguration rvdConfiguration;

    public UriUtils(RvdConfiguration rvdConfiguration) {
        this.rvdConfiguration = rvdConfiguration;
    }

    public URI resolve(URI base, URI uri) {
        if (base.equals(uri)) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return base.resolve(uri);
        }
        return uri;
    }

    private HttpConnectorList getHttpConnectors() throws MalformedObjectNameException, NullPointerException, UnknownHostException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> jbossObjs = mbs.queryNames(new ObjectName("jboss.as:socket-binding-group=standard-sockets,socket-binding=http*"), null);
        Set<ObjectName> tomcatObjs = mbs.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
        ArrayList<HttpConnector> endPoints = new ArrayList<HttpConnector>();
        if (jbossObjs != null && jbossObjs.size() > 0) {
            for (ObjectName obj : jbossObjs) {
                Boolean bound = (Boolean)mbs.getAttribute(obj, "bound");
                if (!bound.booleanValue()) continue;
                String scheme = mbs.getAttribute(obj, "name").toString().replaceAll("\"", "");
                Integer port = (Integer)mbs.getAttribute(obj, "boundPort");
                String address = ((String)mbs.getAttribute(obj, "boundAddress")).replaceAll("\"", "");
                HttpConnector httpConnector = new HttpConnector(scheme, address, port.intValue(), scheme.equalsIgnoreCase("https"));
                endPoints.add(httpConnector);
            }
        } else if (tomcatObjs != null && tomcatObjs.size() > 0) {
            for (ObjectName obj : tomcatObjs) {
                String scheme = mbs.getAttribute(obj, "scheme").toString().replaceAll("\"", "");
                String port = obj.getKeyProperty("port").replaceAll("\"", "");
                String address = obj.getKeyProperty("address").replaceAll("\"", "");
                HttpConnector httpConnector = new HttpConnector(scheme, address, Integer.parseInt(port), scheme.equalsIgnoreCase("https"));
                endPoints.add(httpConnector);
            }
        }
        if (endPoints.isEmpty()) {
            logger.error((Object)"Coundn't discover any Http Interfaces");
        }
        this.httpConnectorList = new HttpConnectorList(endPoints);
        return this.httpConnectorList;
    }

    public URI resolve(URI uri) {
        if (this.httpConnector == null) {
            if (this.httpConnectorList == null) {
                try {
                    this.httpConnectorList = this.getHttpConnectors();
                }
                catch (NullPointerException | UnknownHostException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
                    logger.error((Object)"Exception during HTTP Connectors discovery: ", (Throwable)exception);
                }
            }
            if (this.httpConnectorList != null && !this.httpConnectorList.getConnectors().isEmpty()) {
                List connectors = this.httpConnectorList.getConnectors();
                for (HttpConnector connector : connectors) {
                    if (!connector.isSecure()) continue;
                    this.httpConnector = connector;
                }
                if (this.httpConnector == null) {
                    this.httpConnector = (HttpConnector)connectors.get(0);
                }
            }
        }
        String restcommAddress = null;
        if (this.rvdConfiguration.getUseHostnameToResolveRelativeUrl()) {
            restcommAddress = this.rvdConfiguration.getHostnameOverride();
            if (restcommAddress == null || restcommAddress.isEmpty()) {
                try {
                    InetAddress addr = InetAddress.getByName(this.httpConnector.getAddress());
                    restcommAddress = addr.getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    logger.error((Object)("Unable to resolve: " + this.httpConnector + " to hostname: " + e));
                    restcommAddress = this.httpConnector.getAddress();
                }
            }
        } else {
            restcommAddress = this.httpConnector.getAddress();
        }
        String base = this.httpConnector.getScheme() + "://" + restcommAddress + ":" + this.httpConnector.getPort();
        try {
            return this.resolve(new URI(base), uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Badly formed URI: " + base, e);
        }
    }

    public HttpConnectorList getHttpConnectorList() {
        if (this.httpConnectorList == null) {
            this.getHttpConnectorList();
        }
        return this.httpConnectorList;
    }
}

