/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.identity;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.restcomm.connect.rvd.commons.http.CustomHttpClientBuilder;
import org.restcomm.connect.rvd.identity.BasicAuthCredentials;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfoResponse;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class AccountProvider {
    String restcommUrl;
    CustomHttpClientBuilder httpClientBuilder;

    public AccountProvider(String restcommUrl, CustomHttpClientBuilder httpClientBuilder) {
        if (restcommUrl == null) {
            throw new IllegalStateException("restcommUrl cannot be null");
        }
        this.restcommUrl = this.sanitizeRestcommUrl(restcommUrl);
        this.httpClientBuilder = httpClientBuilder;
    }

    private String sanitizeRestcommUrl(String restcommUrl) {
        if ((restcommUrl = restcommUrl.trim()).endsWith("/")) {
            return restcommUrl.substring(0, restcommUrl.length() - 1);
        }
        return restcommUrl;
    }

    private URI buildAccountQueryUrl(String username) {
        try {
            URI uri = new URIBuilder(this.restcommUrl).setPath("/restcomm/2012-04-24/Accounts.json/" + username).build();
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public RestcommAccountInfoResponse getAccount(String username, String authorizationHeader) {
        CloseableHttpClient client = this.httpClientBuilder.buildHttpClient();
        HttpGet GETRequest = new HttpGet(this.buildAccountQueryUrl(username));
        GETRequest.addHeader("Authorization", authorizationHeader);
        try {
            String accountJson;
            Gson gson;
            RestcommAccountInfoResponse accountResponse;
            HttpEntity entity;
            CloseableHttpResponse response = client.execute((HttpUriRequest)GETRequest);
            if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null && "active".equals((accountResponse = (RestcommAccountInfoResponse)(gson = new Gson()).fromJson(accountJson = EntityUtils.toString((HttpEntity)entity), RestcommAccountInfoResponse.class)).getStatus())) {
                return accountResponse;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public RestcommAccountInfoResponse getAccount(BasicAuthCredentials creds) {
        String header = "Basic " + RvdUtils.buildHttpAuthorizationToken((String)creds.getUsername(), (String)creds.getPassword());
        return this.getAccount(creds.getUsername(), header);
    }
}

