/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.identity;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.restcomm.connect.rvd.identity.AccountProvider;
import org.restcomm.connect.rvd.identity.BasicAuthCredentials;
import org.restcomm.connect.rvd.identity.UserIdentityContext;
import org.restcomm.connect.rvd.restcomm.RestcommAccountInfoResponse;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class UserIdentityContext {
    private String oauthTokenString;
    private BasicAuthCredentials basicCredentials;
    private String effectiveAuthHeader;
    private AuthType authType = AuthType.None;
    private RestcommAccountInfoResponse accountInfo;
    private Set<String> accountRoles;

    public UserIdentityContext(String authorizationHeader, AccountProvider accountProvider) {
        this.oauthTokenString = this.extractOauthTokenString(authorizationHeader);
        this.basicCredentials = this.extractBasicAuthCredentials(authorizationHeader);
        if (this.basicCredentials != null) {
            this.accountInfo = accountProvider.getAccount(this.basicCredentials.getUsername(), authorizationHeader);
            if (this.accountInfo != null) {
                this.authType = AuthType.Basic;
                this.effectiveAuthHeader = authorizationHeader;
            }
        }
        if (this.accountInfo != null) {
            HashSet<String> accountRoles = new HashSet<String>();
            if (!RvdUtils.isEmpty((String)this.accountInfo.getRole())) {
                accountRoles.add(this.accountInfo.getRole());
            }
            this.accountRoles = accountRoles;
        }
    }

    public RestcommAccountInfoResponse getAccountInfo() {
        return this.accountInfo;
    }

    public String getAccountUsername() {
        if (this.accountInfo != null) {
            return this.accountInfo.getEmail_address();
        }
        return null;
    }

    public Set<String> getAccountRoles() {
        return this.accountRoles;
    }

    public String getEffectiveAuthorizationHeader() {
        return this.effectiveAuthHeader;
    }

    private String extractOauthTokenString(String authHeader) {
        String[] parts;
        if (authHeader != null && (parts = authHeader.split(" ")).length >= 2 && parts[0].equals("Bearer")) {
            String tokenString = parts[1];
            return tokenString;
        }
        return null;
    }

    private BasicAuthCredentials extractBasicAuthCredentials(String authHeader) {
        String base64Credentials;
        String credentials;
        String[] values;
        String[] parts;
        if (authHeader != null && (parts = authHeader.split(" ")).length >= 2 && parts[0].equals("Basic") && (values = (credentials = new String(Base64.decodeBase64((String)(base64Credentials = parts[1].trim())), Charset.forName("UTF-8"))).split(":", 2)).length >= 2) {
            BasicAuthCredentials creds = new BasicAuthCredentials(values[0], values[1]);
            return creds;
        }
        return null;
    }
}

