/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.interpreter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.ApplicationContext;
import org.restcomm.connect.rvd.ProjectAwareRvdContext;
import org.restcomm.connect.rvd.ProjectLogger;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.exceptions.RvdException;
import org.restcomm.connect.rvd.exceptions.UndefinedTarget;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.Target;
import org.restcomm.connect.rvd.interpreter.exceptions.BadExternalServiceResponse;
import org.restcomm.connect.rvd.interpreter.exceptions.InvalidAccessOperationAction;
import org.restcomm.connect.rvd.model.ModelMarshaler;
import org.restcomm.connect.rvd.model.StepJsonDeserializer;
import org.restcomm.connect.rvd.model.client.Step;
import org.restcomm.connect.rvd.model.rcml.RcmlResponse;
import org.restcomm.connect.rvd.model.rcml.RcmlStep;
import org.restcomm.connect.rvd.model.server.NodeName;
import org.restcomm.connect.rvd.model.server.ProjectOptions;
import org.restcomm.connect.rvd.model.steps.dial.ClientNounConverter;
import org.restcomm.connect.rvd.model.steps.dial.ConferenceNounConverter;
import org.restcomm.connect.rvd.model.steps.dial.NumberNounConverter;
import org.restcomm.connect.rvd.model.steps.dial.RcmlClientNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlConferenceNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlDialStep;
import org.restcomm.connect.rvd.model.steps.dial.RcmlNumberNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlSipuriNoun;
import org.restcomm.connect.rvd.model.steps.dial.SipuriNounConverter;
import org.restcomm.connect.rvd.model.steps.email.EmailStepConverter;
import org.restcomm.connect.rvd.model.steps.email.RcmlEmailStep;
import org.restcomm.connect.rvd.model.steps.es.AccessOperation;
import org.restcomm.connect.rvd.model.steps.es.ExternalServiceStep;
import org.restcomm.connect.rvd.model.steps.es.ValueExtractor;
import org.restcomm.connect.rvd.model.steps.fax.FaxStepConverter;
import org.restcomm.connect.rvd.model.steps.fax.RcmlFaxStep;
import org.restcomm.connect.rvd.model.steps.gather.RcmlGatherStep;
import org.restcomm.connect.rvd.model.steps.hangup.RcmlHungupStep;
import org.restcomm.connect.rvd.model.steps.pause.RcmlPauseStep;
import org.restcomm.connect.rvd.model.steps.play.PlayStepConverter;
import org.restcomm.connect.rvd.model.steps.play.RcmlPlayStep;
import org.restcomm.connect.rvd.model.steps.record.RcmlRecordStep;
import org.restcomm.connect.rvd.model.steps.redirect.RcmlRedirectStep;
import org.restcomm.connect.rvd.model.steps.redirect.RedirectStepConverter;
import org.restcomm.connect.rvd.model.steps.reject.RcmlRejectStep;
import org.restcomm.connect.rvd.model.steps.say.RcmlSayStep;
import org.restcomm.connect.rvd.model.steps.say.SayStepConverter;
import org.restcomm.connect.rvd.model.steps.sms.RcmlSmsStep;
import org.restcomm.connect.rvd.model.steps.sms.SmsStepConverter;
import org.restcomm.connect.rvd.model.steps.ussdcollect.UssdCollectRcml;
import org.restcomm.connect.rvd.model.steps.ussdlanguage.UssdLanguageConverter;
import org.restcomm.connect.rvd.model.steps.ussdlanguage.UssdLanguageRcml;
import org.restcomm.connect.rvd.model.steps.ussdsay.UssdSayRcml;
import org.restcomm.connect.rvd.model.steps.ussdsay.UssdSayStepConverter;
import org.restcomm.connect.rvd.storage.FsProjectStorage;
import org.restcomm.connect.rvd.storage.WorkspaceStorage;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Interpreter {
    static final Logger logger = Logger.getLogger((String)Interpreter.class.getName());
    private RvdConfiguration rvdSettings;
    private HttpServletRequest httpRequest;
    private ProjectLogger projectLogger;
    private ProjectAwareRvdContext rvdContext;
    private ApplicationContext applicationContext;
    private WorkspaceStorage workspaceStorage;
    private ModelMarshaler marshaler;
    private XStream xstream;
    private Gson gson;
    private String targetParam;
    private Target target;
    private String appName;
    MultivaluedMap<String, String> requestParams;
    private String contextPath;
    private String rcmlResult;
    private Map<String, String> variables = new HashMap();
    private List<NodeName> nodeNames;

    public ProjectLogger getProjectLogger() {
        return this.projectLogger;
    }

    public ProjectAwareRvdContext getRvdContext() {
        return this.rvdContext;
    }

    public void setProjectLogger(ProjectLogger projectLogger) {
        this.projectLogger = projectLogger;
    }

    public void setRvdSettings(RvdConfiguration rvdSettings) {
        this.rvdSettings = rvdSettings;
    }

    public static String rcmlOnException() {
        return "<Response><Hangup/></Response>";
    }

    public Interpreter(ProjectAwareRvdContext rvdContext, String targetParam, String appName, HttpServletRequest httpRequest, MultivaluedMap<String, String> requestParams, WorkspaceStorage workspaceStorage, ApplicationContext applicationContext) {
        this.rvdContext = rvdContext;
        this.rvdSettings = rvdContext.getSettings();
        this.httpRequest = httpRequest;
        this.targetParam = (String)requestParams.getFirst((Object)"target");
        this.appName = appName;
        this.requestParams = requestParams;
        this.workspaceStorage = workspaceStorage;
        this.marshaler = rvdContext.getMarshaler();
        this.projectLogger = rvdContext.getProjectLogger();
        this.applicationContext = applicationContext;
        this.contextPath = httpRequest.getContextPath();
        this.init();
    }

    private void init() {
        this.xstream = new XStream();
        this.xstream.registerConverter((Converter)new SayStepConverter());
        this.xstream.registerConverter((Converter)new PlayStepConverter());
        this.xstream.registerConverter((Converter)new RedirectStepConverter());
        this.xstream.registerConverter((Converter)new SmsStepConverter());
        this.xstream.registerConverter((Converter)new FaxStepConverter());
        this.xstream.registerConverter((Converter)new EmailStepConverter());
        this.xstream.registerConverter((Converter)new NumberNounConverter());
        this.xstream.registerConverter((Converter)new ClientNounConverter());
        this.xstream.registerConverter((Converter)new ConferenceNounConverter());
        this.xstream.registerConverter((Converter)new SipuriNounConverter());
        this.xstream.registerConverter((Converter)new UssdSayStepConverter());
        this.xstream.registerConverter((Converter)new UssdLanguageConverter());
        this.xstream.addImplicitCollection(RcmlDialStep.class, "nouns");
        this.xstream.alias("Response", RcmlResponse.class);
        this.xstream.addImplicitCollection(RcmlResponse.class, "steps");
        this.xstream.alias("Say", RcmlSayStep.class);
        this.xstream.alias("Play", RcmlPlayStep.class);
        this.xstream.alias("Gather", RcmlGatherStep.class);
        this.xstream.alias("Dial", RcmlDialStep.class);
        this.xstream.alias("Hangup", RcmlHungupStep.class);
        this.xstream.alias("Redirect", RcmlRedirectStep.class);
        this.xstream.alias("Reject", RcmlRejectStep.class);
        this.xstream.alias("Pause", RcmlPauseStep.class);
        this.xstream.alias("Sms", RcmlSmsStep.class);
        this.xstream.alias("Email", RcmlEmailStep.class);
        this.xstream.alias("Record", RcmlRecordStep.class);
        this.xstream.alias("Fax", RcmlFaxStep.class);
        this.xstream.alias("Number", RcmlNumberNoun.class);
        this.xstream.alias("Client", RcmlClientNoun.class);
        this.xstream.alias("Conference", RcmlConferenceNoun.class);
        this.xstream.alias("Sip", RcmlSipuriNoun.class);
        this.xstream.alias("UssdMessage", UssdSayRcml.class);
        this.xstream.alias("UssdCollect", UssdCollectRcml.class);
        this.xstream.alias("Language", UssdLanguageRcml.class);
        this.xstream.addImplicitCollection(RcmlGatherStep.class, "steps");
        this.xstream.addImplicitCollection(UssdCollectRcml.class, "messages");
        this.xstream.useAttributeFor(UssdCollectRcml.class, "action");
        this.xstream.useAttributeFor(RcmlGatherStep.class, "action");
        this.xstream.useAttributeFor(RcmlGatherStep.class, "timeout");
        this.xstream.useAttributeFor(RcmlGatherStep.class, "finishOnKey");
        this.xstream.useAttributeFor(RcmlGatherStep.class, "method");
        this.xstream.useAttributeFor(RcmlGatherStep.class, "numDigits");
        this.xstream.useAttributeFor(RcmlSayStep.class, "voice");
        this.xstream.useAttributeFor(RcmlSayStep.class, "language");
        this.xstream.useAttributeFor(RcmlSayStep.class, "loop");
        this.xstream.useAttributeFor(RcmlPlayStep.class, "loop");
        this.xstream.useAttributeFor(RcmlRejectStep.class, "reason");
        this.xstream.useAttributeFor(RcmlPauseStep.class, "length");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "action");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "method");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "timeout");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "finishOnKey");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "maxLength");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "transcribe");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "transcribeCallback");
        this.xstream.useAttributeFor(RcmlRecordStep.class, "playBeep");
        this.xstream.useAttributeFor(RcmlDialStep.class, "action");
        this.xstream.useAttributeFor(RcmlDialStep.class, "method");
        this.xstream.useAttributeFor(RcmlDialStep.class, "timeout");
        this.xstream.useAttributeFor(RcmlDialStep.class, "timeLimit");
        this.xstream.useAttributeFor(RcmlDialStep.class, "callerId");
        this.xstream.useAttributeFor(RcmlDialStep.class, "record");
        this.xstream.aliasField("Number", RcmlDialStep.class, "number");
        this.xstream.aliasField("Client", RcmlDialStep.class, "client");
        this.xstream.aliasField("Conference", RcmlDialStep.class, "conference");
        this.xstream.aliasField("Uri", RcmlDialStep.class, "sipuri");
        this.gson = new GsonBuilder().registerTypeAdapter(Step.class, (Object)new StepJsonDeserializer()).create();
    }

    public RvdConfiguration getRvdSettings() {
        return this.rvdSettings;
    }

    public String getAppName() {
        return this.appName;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String interpret() throws RvdException {
        String response = null;
        ProjectOptions projectOptions = FsProjectStorage.loadProjectOptions((String)this.appName, (WorkspaceStorage)this.workspaceStorage);
        this.nodeNames = projectOptions.getNodeNames();
        if (this.targetParam == null || "".equals(this.targetParam)) {
            this.targetParam = projectOptions.getDefaultTarget();
            if (this.targetParam == null) {
                throw new UndefinedTarget();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("override default target to " + this.targetParam));
            }
        }
        this.processBootstrapParameters();
        this.processRequestParameters();
        response = this.interpret(this.targetParam, null, null, null);
        return response;
    }

    public MultivaluedMap<String, String> getRequestParams() {
        return this.requestParams;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String interpret(String targetParam, RcmlResponse rcmlModel, Step prependStep, Target originTarget) throws InterpreterException, StorageException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("starting interpeter for " + targetParam));
        }
        if (this.rvdContext.getProjectSettings().getLogging().booleanValue()) {
            this.projectLogger.log((Object)("Running target: " + targetParam)).tag("app", this.appName).done();
        }
        this.target = Interpreter.parseTarget((String)targetParam);
        if (originTarget != null && !RvdUtils.safeEquals((String)this.target.getNodename(), (String)originTarget.getNodename())) {
            this.clearModuleVariables();
        }
        if (this.target.action != null) {
            this.loadStep(this.target.stepname).handleAction(this, this.target);
        } else {
            if (rcmlModel == null) {
                rcmlModel = new RcmlResponse();
            }
            List nodeStepnames = FsProjectStorage.loadNodeStepnames((String)this.appName, (String)this.target.getNodename(), (WorkspaceStorage)this.workspaceStorage);
            if (this.target.getStepname() == null && !nodeStepnames.isEmpty()) {
                this.target.setStepname((String)nodeStepnames.get(0));
            }
            if (prependStep != null) {
                RcmlStep rcmlStep = prependStep.render(this);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Prepending say step: " + rcmlStep));
                }
                rcmlModel.steps.add(rcmlStep);
            }
            boolean startstep_found = false;
            for (String stepname : nodeStepnames) {
                if (stepname.equals(this.target.getStepname())) {
                    startstep_found = true;
                }
                if (!startstep_found) continue;
                Step step = this.loadStep(stepname);
                String rerouteTo = step.process(this, this.httpRequest);
                if (rerouteTo != null) {
                    return this.interpret(rerouteTo, rcmlModel, null, this.target);
                }
                RcmlStep rcmlStep = step.render(this);
                if (rcmlStep == null) continue;
                rcmlModel.steps.add(rcmlStep);
            }
            this.rcmlResult = this.xstream.toXML((Object)rcmlModel);
        }
        return this.rcmlResult;
    }

    private Step loadStep(String stepname) throws StorageException {
        String stepfile_json = FsProjectStorage.loadStep((String)this.appName, (String)this.target.getNodename(), (String)stepname, (WorkspaceStorage)this.workspaceStorage);
        Step step = (Step)this.gson.fromJson(stepfile_json, Step.class);
        return step;
    }

    public String evaluateExtractorExpression(ValueExtractor extractor, JsonElement response_element) throws InvalidAccessOperationAction, BadExternalServiceResponse {
        String value = "";
        JsonElement element = response_element;
        for (AccessOperation operation : extractor.getAccessOperations()) {
            if (element == null) {
                throw new BadExternalServiceResponse();
            }
            if ("object".equals(operation.getKind())) {
                if (!element.isJsonObject()) {
                    throw new BadExternalServiceResponse("No JSON object found");
                }
                if ("propertyNamed".equals(operation.getAction())) {
                    element = element.getAsJsonObject().get(operation.getProperty());
                    continue;
                }
                throw new InvalidAccessOperationAction();
            }
            if ("array".equals(operation.getKind())) {
                if (!element.isJsonArray()) {
                    throw new BadExternalServiceResponse("No JSON array found");
                }
                if ("itemAtPosition".equals(operation.getAction())) {
                    element = element.getAsJsonArray().get(operation.getPosition().intValue());
                    continue;
                }
                throw new InvalidAccessOperationAction();
            }
            if (!"value".equals(operation.getKind())) continue;
            if (!element.isJsonPrimitive()) {
                throw new BadExternalServiceResponse("No primitive value found (maybe null returned?)");
            }
            value = element.getAsString();
        }
        return value;
    }

    private String processStep(Step step) throws InterpreterException {
        if (step.getClass().equals(ExternalServiceStep.class)) {
            // empty if block
        }
        return null;
    }

    public String populateVariables(String sourceText) {
        if (sourceText == null) {
            return sourceText;
        }
        Pattern pattern = Pattern.compile("\\$([A-Za-z]+[A-Za-z0-9_]*)");
        Matcher matches = pattern.matcher(sourceText);
        int searchStart = 0;
        ArrayList<VariableInText> variablesInText = new ArrayList<VariableInText>();
        while (matches.find(searchStart)) {
            variablesInText.add(new VariableInText(this, matches.group(1), Integer.valueOf(matches.start())));
            searchStart = matches.end();
        }
        StringBuffer buffer = new StringBuffer(sourceText);
        Collections.reverse(variablesInText);
        for (VariableInText v : variablesInText) {
            String replaceValue = "";
            if (this.variables.containsKey(v.variableName)) {
                replaceValue = (String)this.variables.get(v.variableName);
            } else if (this.variables.containsKey("module_" + v.variableName)) {
                replaceValue = (String)this.variables.get("module_" + v.variableName);
            } else if (this.variables.containsKey("sticky_" + v.variableName)) {
                replaceValue = (String)this.variables.get("sticky_" + v.variableName);
            }
            buffer.replace(v.position, v.position + v.variableName.length() + 1, replaceValue == null ? "" : replaceValue);
        }
        return buffer.toString();
    }

    public String buildAction(Map<String, String> pairs) {
        String value;
        String encodedValue;
        String query = "";
        for (String key : pairs.keySet()) {
            query = "".equals(query) ? query + "?" : query + "&";
            encodedValue = "";
            value = pairs.get(key);
            if (value != null) {
                try {
                    encodedValue = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)("Error encoding RVD variable " + key + ": " + value), (Throwable)e);
                }
            }
            query = query + key + "=" + encodedValue;
        }
        for (String variableName : this.variables.keySet()) {
            if (!variableName.startsWith("sticky_") && !variableName.startsWith("module_")) continue;
            query = "".equals(query) ? query + "?" : query + "&";
            encodedValue = "";
            value = (String)this.variables.get(variableName);
            if (value != null) {
                try {
                    encodedValue = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)("Error encoding RVD variable " + variableName + ": " + value), (Throwable)e);
                }
            }
            query = query + variableName + "=" + encodedValue;
        }
        return "controller" + query;
    }

    public static Target parseTarget(String targetParam) {
        Target target = new Target();
        Pattern pattern = Pattern.compile("^([^.]+)(.([^.]+))?(.([^.]+))?");
        Matcher matcher = pattern.matcher(targetParam);
        if (matcher.find()) {
            if (matcher.groupCount() >= 1) {
                target.setNodename(matcher.group(1));
            }
            if (matcher.groupCount() >= 3) {
                target.setStepname(matcher.group(3));
            }
            if (matcher.groupCount() >= 5) {
                target.setAction(matcher.group(5));
            }
        }
        return target;
    }

    public String getNodeNameByLabel(String label) {
        for (NodeName nodename : this.nodeNames) {
            if (!label.equals(nodename.getLabel())) continue;
            return nodename.getName();
        }
        return null;
    }

    public String moduleUrl(String moduleName) {
        String url = null;
        for (NodeName nodeName : this.nodeNames) {
            if (!nodeName.getName().equals(moduleName)) continue;
            HashMap<String, String> pairs = new HashMap<String, String>();
            pairs.put("target", moduleName);
            url = this.buildAction(pairs);
            break;
        }
        return url;
    }

    public String convertRecordingFileResourceHttp(String fileResource, HttpServletRequest request) throws URISyntaxException {
        String httpResource = fileResource;
        URIBuilder fileUriBuilder = new URIBuilder(fileResource);
        if (!fileUriBuilder.isAbsolute()) {
            logger.warn((Object)("Cannot convert file URL to http URL - " + fileResource));
            return "";
        }
        if (fileUriBuilder.getScheme().startsWith("http")) {
            return fileResource;
        }
        if (fileUriBuilder.getScheme().startsWith("file")) {
            String wavFilename = "";
            int filenameBeforeStartPos = fileResource.lastIndexOf(47);
            if (filenameBeforeStartPos != -1) {
                wavFilename = fileResource.substring(filenameBeforeStartPos + 1);
                URIBuilder httpUriBuilder = new URIBuilder().setScheme(request.getScheme()).setHost(request.getLocalAddr()).setPort(request.getServerPort()).setPath("/restcomm/recordings/" + wavFilename);
                httpResource = httpUriBuilder.build().toString();
            }
        }
        return httpResource;
    }

    public void putStickyVariable(String name, String value) {
        this.variables.put("sticky_" + name, value);
    }

    public static String nameStickyRequestParam(String name) {
        return "sticky_" + name;
    }

    public static String nameModuleRequestParam(String name) {
        return "module_" + name;
    }

    public void putModuleVariable(String name, String value) {
        this.variables.put("module_" + name, value);
    }

    public void putVariable(String name, String value) {
        this.variables.put(name, value);
    }

    private void processRequestParameters() {
        for (String anyVariableName : this.getRequestParams().keySet()) {
            String variableValue;
            if (RvdConfiguration.builtinRestcommParameters.contains(anyVariableName)) {
                variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
                this.getVariables().put("core_" + anyVariableName, variableValue);
                continue;
            }
            if (this.isCustomRestcommHttpHeader(anyVariableName)) {
                variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
                this.getVariables().put("core_" + this.normalizeHTTPHeaderName(anyVariableName), variableValue);
                continue;
            }
            if (anyVariableName.startsWith("sticky_") || anyVariableName.startsWith("module_")) {
                variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
                this.getVariables().put(anyVariableName, variableValue);
                continue;
            }
            variableValue = (String)this.getRequestParams().getFirst((Object)anyVariableName);
            this.getVariables().put(anyVariableName, variableValue);
        }
    }

    private boolean isCustomRestcommHttpHeader(String headerName) {
        if (headerName.toLowerCase().startsWith("SipHeader_".toLowerCase())) {
            return true;
        }
        return headerName.toLowerCase().startsWith("DialSipHeader_".toLowerCase());
    }

    private String normalizeHTTPHeaderName(String headerName) {
        if (headerName.toLowerCase().startsWith("SipHeader_".toLowerCase())) {
            String stripedName = headerName.substring("SipHeader_".length()).toLowerCase();
            return this.sanitizeVariableName(stripedName);
        }
        if (headerName.toLowerCase().startsWith("DialSipHeader_".toLowerCase())) {
            String stripedName = headerName.substring("DialSipHeader_".length()).toLowerCase();
            return this.sanitizeVariableName(stripedName);
        }
        return headerName;
    }

    private String sanitizeVariableName(String name) {
        if (name != null) {
            return name.replaceAll("[^A-Za-z0-9_]", "_");
        }
        return null;
    }

    private void processBootstrapParameters() throws StorageException {
        if (!FsProjectStorage.hasBootstrapInfo((String)this.appName, (WorkspaceStorage)this.workspaceStorage)) {
            return;
        }
        JsonParser parser = new JsonParser();
        String data = FsProjectStorage.loadBootstrapInfo((String)this.appName, (WorkspaceStorage)this.workspaceStorage);
        JsonElement rootElement = parser.parse(data);
        if (rootElement.isJsonObject()) {
            JsonObject rootObject = rootElement.getAsJsonObject();
            for (Map.Entry entry : rootObject.entrySet()) {
                String name = (String)entry.getKey();
                JsonElement valueElement = (JsonElement)entry.getValue();
                if (valueElement.isJsonPrimitive() && valueElement.getAsJsonPrimitive().isString()) {
                    String value = valueElement.getAsJsonPrimitive().getAsString();
                    this.getVariables().put(name, value);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Loaded bootstrap parameter: " + name + " - " + value));
                    continue;
                }
                logger.warn((Object)("Warning. Not-string bootstrap value found for parameter: " + name));
            }
        }
    }

    public void clearModuleVariables() {
        Iterator it = this.variables.keySet().iterator();
        while (it.hasNext()) {
            String variableName = (String)it.next();
            if (!variableName.startsWith("module_")) continue;
            it.remove();
        }
    }
}

