/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.jsonvalidation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import org.restcomm.connect.rvd.RvdConfiguration;
import org.restcomm.connect.rvd.jsonvalidation.ValidationResult;
import org.restcomm.connect.rvd.jsonvalidation.Validator;
import org.restcomm.connect.rvd.jsonvalidation.exceptions.ValidationFrameworkException;

public class ProjectValidator
implements Validator {
    String schemaVersion;
    JsonSchema projectSchema;

    public ProjectValidator() throws ProcessingException, IOException {
        this.init(RvdConfiguration.getRvdProjectVersion());
    }

    public ProjectValidator(String schemaVersion) throws ProcessingException, IOException {
        this.init(schemaVersion);
    }

    private void init(String schemaVersion) throws ProcessingException {
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        this.projectSchema = factory.getJsonSchema("resource:/validation/rvdproject/" + schemaVersion + "/rvdproject-schema.json#/rvdproject");
    }

    public ValidationResult validate(String json) throws ValidationFrameworkException {
        try {
            JsonNode state = JsonLoader.fromString((String)json);
            ProcessingReport report = this.projectSchema.validate(state);
            return new ValidationResult(report);
        }
        catch (IOException e) {
            throw new ValidationFrameworkException("Internal validation error", (Throwable)e);
        }
        catch (ProcessingException e) {
            throw new ValidationFrameworkException("Internal validation error", (Throwable)e);
        }
    }
}

