/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.dial;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.Target;
import org.restcomm.connect.rvd.model.client.Step;
import org.restcomm.connect.rvd.model.steps.dial.DialNoun;
import org.restcomm.connect.rvd.model.steps.dial.RcmlDialStep;
import org.restcomm.connect.rvd.storage.exceptions.StorageException;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class DialStep
extends Step {
    static final Logger logger = Logger.getLogger((String)DialStep.class.getName());
    private List<DialNoun> dialNouns;
    private String action;
    private String method;
    private Integer timeout;
    private Integer timeLimit;
    private String callerId;
    private String nextModule;
    private Boolean record;

    public RcmlDialStep render(Interpreter interpreter) throws InterpreterException {
        RcmlDialStep rcmlStep = new RcmlDialStep();
        for (DialNoun noun : this.dialNouns) {
            rcmlStep.nouns.add(noun.render(interpreter));
        }
        if (!RvdUtils.isEmpty((String)this.nextModule)) {
            String action;
            String newtarget = interpreter.getTarget().getNodename() + "." + this.getName() + ".actionhandler";
            HashMap<String, String> pairs = new HashMap<String, String>();
            pairs.put("target", newtarget);
            rcmlStep.action = action = interpreter.buildAction(pairs);
            rcmlStep.method = this.method;
        }
        rcmlStep.timeout = this.timeout == null ? null : this.timeout.toString();
        rcmlStep.timeLimit = this.timeLimit == null ? null : this.timeLimit.toString();
        rcmlStep.callerId = interpreter.populateVariables(this.callerId);
        rcmlStep.record = this.record;
        return rcmlStep;
    }

    public void handleAction(Interpreter interpreter, Target originTarget) throws InterpreterException, StorageException {
        String DialRingDuration;
        String DialCallDuration;
        String DialCallSid;
        String DialCallStatus;
        String restcommRecordingUrl;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"handling dial action");
        }
        if (RvdUtils.isEmpty((String)this.nextModule)) {
            throw new InterpreterException("'next' module is not defined for step " + this.getName());
        }
        String publicRecordingUrl = (String)interpreter.getRequestParams().getFirst((Object)"PublicRecordingUrl");
        if (publicRecordingUrl != null) {
            interpreter.getVariables().put("core_PublicRecordingUrl", publicRecordingUrl);
        }
        if ((restcommRecordingUrl = (String)interpreter.getRequestParams().getFirst((Object)"RecordingUrl")) != null) {
            try {
                String recordingUrl = interpreter.convertRecordingFileResourceHttp(restcommRecordingUrl, interpreter.getHttpRequest());
                interpreter.getVariables().put("core_RecordingUrl", recordingUrl);
            }
            catch (URISyntaxException e) {
                logger.warn((Object)("Cannot convert file URL to http URL - " + restcommRecordingUrl), (Throwable)e);
            }
        }
        if ((DialCallStatus = (String)interpreter.getRequestParams().getFirst((Object)"DialCallStatus")) != null) {
            interpreter.getVariables().put("core_DialCallStatus", DialCallStatus);
        }
        if ((DialCallSid = (String)interpreter.getRequestParams().getFirst((Object)"DialCallSid")) != null) {
            interpreter.getVariables().put("core_DialCallSid", DialCallSid);
        }
        if ((DialCallDuration = (String)interpreter.getRequestParams().getFirst((Object)"DialCallDuration")) != null) {
            interpreter.getVariables().put("core_DialCallDuration", DialCallDuration);
        }
        if ((DialRingDuration = (String)interpreter.getRequestParams().getFirst((Object)"DialRingDuration")) != null) {
            interpreter.getVariables().put("core_DialRingDuration", DialRingDuration);
        }
        interpreter.interpret(this.nextModule, null, null, originTarget);
    }
}

