/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.rvd.model.steps.es;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.restcomm.connect.rvd.exceptions.ESRequestException;
import org.restcomm.connect.rvd.exceptions.InterpreterException;
import org.restcomm.connect.rvd.interpreter.Interpreter;
import org.restcomm.connect.rvd.interpreter.exceptions.BadExternalServiceResponse;
import org.restcomm.connect.rvd.interpreter.exceptions.ErrorParsingExternalServiceUrl;
import org.restcomm.connect.rvd.interpreter.exceptions.RemoteServiceError;
import org.restcomm.connect.rvd.model.client.Step;
import org.restcomm.connect.rvd.model.client.UrlParam;
import org.restcomm.connect.rvd.model.rcml.RcmlStep;
import org.restcomm.connect.rvd.model.steps.es.Assignment;
import org.restcomm.connect.rvd.model.steps.es.RouteMapping;
import org.restcomm.connect.rvd.model.steps.es.ValueExtractor;
import org.restcomm.connect.rvd.utils.RvdUtils;

public class ExternalServiceStep
extends Step {
    public static final String CONTENT_TYPE_WWWFORM = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    static final Logger logger = Logger.getLogger((String)ExternalServiceStep.class.getName());
    private String url;
    private String method;
    private String username;
    private String password;
    private List<UrlParam> urlParams;
    private String contentType;
    private String requestBody;
    private Boolean populatePostBodyFromParams;
    private List<Assignment> assignments;
    private String next;
    private String nextVariable;
    private Boolean doRouting;
    private String nextType;
    private ValueExtractor nextValueExtractor;
    private List<RouteMapping> routeMappings;
    private String exceptionNext;

    public ValueExtractor getNextValueExtractor() {
        return this.nextValueExtractor;
    }

    public void setNextValueExtractor(ValueExtractor nextValueExtractor) {
        this.nextValueExtractor = nextValueExtractor;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public List<RouteMapping> getRouteMappings() {
        return this.routeMappings;
    }

    public void setRouteMappings(List<RouteMapping> routeMappings) {
        this.routeMappings = routeMappings;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public Boolean getDoRouting() {
        return this.doRouting;
    }

    public void setDoRouting(Boolean doRouting) {
        this.doRouting = doRouting;
    }

    public String getNextType() {
        return this.nextType;
    }

    public void setNextType(String nextType) {
        this.nextType = nextType;
    }

    public String getNextVariable() {
        return this.nextVariable;
    }

    public void setNextVariable(String nextVariable) {
        this.nextVariable = nextVariable;
    }

    public List<UrlParam> getUrlParams() {
        return this.urlParams;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExceptionNext() {
        return this.exceptionNext;
    }

    public void setExceptionNext(String exceptionNext) {
        this.exceptionNext = exceptionNext;
    }

    public RcmlStep render(Interpreter interpreter) throws InterpreterException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String process(Interpreter interpreter, HttpServletRequest httpRequest) throws InterpreterException {
        String next;
        block66: {
            String value;
            Iterator iterator;
            JsonElement response_element;
            block65: {
                next = null;
                try {
                    block64: {
                        CloseableHttpResponse response;
                        URI url;
                        try {
                            URIBuilder uri_builder = new URIBuilder(interpreter.populateVariables(this.getUrl()));
                            if (uri_builder.getHost() == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"External Service: Relative url is used. Will override from http request to RVD controller");
                                }
                                uri_builder.setScheme(httpRequest.getScheme());
                                uri_builder.setHost(httpRequest.getServerName());
                                uri_builder.setPort(httpRequest.getServerPort());
                                if (!uri_builder.getPath().startsWith("/")) {
                                    uri_builder.setPath("/" + uri_builder.getPath());
                                }
                            }
                            if (this.getMethod() == null || "GET".equals(this.getMethod()) || "DELETE".equals(this.getMethod())) {
                                for (UrlParam urlParam : this.getUrlParams()) {
                                    uri_builder.addParameter(urlParam.getName(), interpreter.populateVariables(urlParam.getValue()));
                                }
                            }
                            url = uri_builder.build();
                        }
                        catch (URISyntaxException e) {
                            throw new ErrorParsingExternalServiceUrl("URL: " + this.getUrl(), (Throwable)e);
                        }
                        CloseableHttpClient client = interpreter.getApplicationContext().getHttpClientBuilder().buildHttpClient();
                        response_element = null;
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Requesting from url: " + url));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Requesting from url: " + url));
                        }
                        if (interpreter.getRvdContext().getProjectSettings().getLogging().booleanValue()) {
                            interpreter.getProjectLogger().log((Object)("Requesting from url: " + url)).tag("app", interpreter.getAppName()).tag("ES").tag("REQUEST").done();
                        }
                        if ("POST".equals(this.getMethod()) || "PUT".equals(this.getMethod())) {
                            StringEntity stringBody;
                            void var9_14;
                            if ("POST".equals(this.getMethod())) {
                                HttpPost httpPost = new HttpPost(url);
                            } else {
                                HttpPut httpPut = new HttpPut(url);
                            }
                            String body = interpreter.populateVariables(this.requestBody);
                            if (RvdUtils.isEmpty((String)this.getContentType()) || this.getContentType().equals(CONTENT_TYPE_WWWFORM)) {
                                if (!RvdUtils.isEmpty((Boolean)this.populatePostBodyFromParams) && this.populatePostBodyFromParams.booleanValue()) {
                                    ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>();
                                    for (UrlParam urlParam : this.getUrlParams()) {
                                        values.add(new BasicNameValuePair(urlParam.getName(), interpreter.populateVariables(urlParam.getValue())));
                                    }
                                    var9_14.setEntity((HttpEntity)new UrlEncodedFormEntity(values));
                                } else {
                                    var9_14.addHeader("Content-Type", CONTENT_TYPE_WWWFORM);
                                    stringBody = new StringEntity(body, "UTF-8");
                                    var9_14.setEntity((HttpEntity)stringBody);
                                }
                            } else if (this.getContentType().equals(CONTENT_TYPE_JSON)) {
                                var9_14.addHeader("Content-Type", CONTENT_TYPE_JSON);
                                stringBody = new StringEntity(body, "UTF-8");
                                var9_14.setEntity((HttpEntity)stringBody);
                            } else {
                                logger.warn((Object)("Unknown content type found when POSTing to " + url + " : " + this.getContentType()));
                                var9_14.addHeader("Content-Type", this.getContentType());
                                stringBody = new StringEntity(body, "UTF-8");
                                var9_14.setEntity((HttpEntity)stringBody);
                            }
                            if (!RvdUtils.isEmpty((String)this.getUsername())) {
                                var9_14.addHeader("Authorization", "Basic " + RvdUtils.buildHttpAuthorizationToken((String)this.getUsername(), (String)this.getPassword()));
                            }
                            response = client.execute((HttpUriRequest)var9_14);
                        } else {
                            void var9_17;
                            if (this.getMethod() != null && !this.getMethod().equals("GET")) {
                                if (!this.getMethod().equals("DELETE")) throw new InterpreterException("Unknonwn HTTP method specified: " + this.getMethod());
                            }
                            if (this.getMethod() == null || this.getMethod().equals("GET")) {
                                HttpGet httpGet = new HttpGet(url);
                            } else {
                                HttpDelete httpDelete = new HttpDelete(url);
                            }
                            if (!RvdUtils.isEmpty((String)this.getUsername())) {
                                var9_17.addHeader("Authorization", "Basic " + RvdUtils.buildHttpAuthorizationToken((String)this.getUsername(), (String)this.getPassword()));
                            }
                            response = client.execute((HttpUriRequest)var9_17);
                        }
                        try {
                            int statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode >= 400 && statusCode < 600) {
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)("Remote service failed with: " + response.getStatusLine()));
                                }
                                if (RvdUtils.isEmpty((String)this.getExceptionNext())) throw new RemoteServiceError("Service " + url + " failed with: " + response.getStatusLine() + ". Throwing an error since no 'On Remote Exception' has been defined.");
                                String string = this.getExceptionNext();
                                return string;
                            }
                            if (this.getAssignments() != null && this.getAssignments().size() > 0 || this.getDoRouting().booleanValue() && ("responseBased".equals(this.getNextType()) || "mapped".equals(this.getNextType()))) {
                                HttpEntity httpEntity = response.getEntity();
                                if (httpEntity != null) {
                                    JsonParser parser = new JsonParser();
                                    String entity_string = EntityUtils.toString((HttpEntity)httpEntity);
                                    if (interpreter.getRvdContext().getProjectSettings().getLogging().booleanValue()) {
                                        interpreter.getProjectLogger().log((Object)entity_string).tag("app", interpreter.getAppName()).tag("ES").tag("RESPONSE").done();
                                    }
                                    response_element = parser.parse(entity_string);
                                }
                                break block64;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"ES: No parsing will be done to the response");
                            }
                        }
                        finally {
                            if (response != null) {
                                response.close();
                                HttpClientUtils.closeQuietly((HttpClient)client);
                                client = null;
                            }
                        }
                    }
                    if (this.getDoRouting().booleanValue()) {
                        if ("fixed".equals(this.getNextType())) {
                            next = this.getNext();
                        } else if ("responseBased".equals(this.getNextType()) || "mapped".equals(this.getNextType())) {
                            String string = interpreter.evaluateExtractorExpression(this.getNextValueExtractor(), response_element);
                            if ("responseBased".equals(this.getNextType())) {
                                next = interpreter.getNodeNameByLabel(string);
                            } else if ("mapped".equals(this.getNextType()) && this.getRouteMappings() != null) {
                                for (RouteMapping mapping : this.getRouteMappings()) {
                                    if (string == null || !string.equals(mapping.getValue())) continue;
                                    next = mapping.getNext();
                                    break;
                                }
                            }
                        }
                        if ("fixed".equals(this.getNextType()) && RvdUtils.isEmpty((String)next)) {
                            throw new InterpreterException("No valid module could be found for ES routing");
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Routing enabled. Chosen target: " + next));
                        }
                    }
                    try {
                        if (this.getDoRouting().booleanValue() && ("responseBased".equals(this.getNextType()) || "mapped".equals(this.getNextType()))) {
                            iterator = this.getAssignments().iterator();
                            break block65;
                        }
                        for (Assignment assignment : this.getAssignments()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("working on variable " + assignment.getDestVariable()));
                            }
                            value = null;
                            try {
                                value = interpreter.evaluateExtractorExpression(assignment.getValueExtractor(), response_element);
                            }
                            catch (BadExternalServiceResponse e) {
                                logger.error((Object)("Could not parse variable " + assignment.getDestVariable() + ". Variable not found in response"));
                                throw e;
                            }
                            if ("application".equals(assignment.getScope())) {
                                interpreter.putStickyVariable(assignment.getDestVariable(), value);
                            }
                            if (!"module".equals(assignment.getScope())) continue;
                            interpreter.putModuleVariable(assignment.getDestVariable(), value);
                        }
                        break block66;
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        throw new BadExternalServiceResponse("External Service request received a malformed JSON response");
                    }
                }
                catch (IOException e) {
                    throw new ESRequestException("Error processing ExternalService step " + this.getName(), (Throwable)e);
                }
            }
            while (iterator.hasNext()) {
                Assignment assignment;
                assignment = (Assignment)iterator.next();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("working on variable " + assignment.getDestVariable()));
                    logger.debug((Object)("moduleNameScope: " + assignment.getModuleNameScope()));
                }
                if (assignment.getModuleNameScope() == null || assignment.getModuleNameScope().equals(next)) {
                    value = null;
                    try {
                        value = interpreter.evaluateExtractorExpression(assignment.getValueExtractor(), response_element);
                    }
                    catch (BadExternalServiceResponse e) {
                        logger.error((Object)("Could not parse variable " + assignment.getDestVariable() + ". Variable not found in response"));
                        throw e;
                    }
                    if ("application".equals(assignment.getScope())) {
                        interpreter.putStickyVariable(assignment.getDestVariable(), value);
                    }
                    if (!"module".equals(assignment.getScope())) continue;
                    interpreter.putModuleVariable(assignment.getDestVariable(), value);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("skipped assignment to " + assignment.getDestVariable()));
            }
        }
        if (!logger.isDebugEnabled()) return next;
        logger.debug((Object)("variables after processing ExternalService step: " + interpreter.getVariables().toString()));
        return next;
    }
}

